set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9011057';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '1432144',
      NULL,
      0.337414,
      0,
      1,
      '0411',
      0.880255,
      1,
      NULL,
      NULL,
      '10-28-1996',
      NULL,
      NULL,
      1,
      1.388325,
      0,
      ' 4- 2-1986',
      NULL,
      NULL,
      49,
      68.799601,
      0,
      ' 6-21-1988',
      ' 6-28-1974',
      ' 0-17-1979',
      1.896279,
      NULL,
      3,
      0.113509,
      0,
      NULL,
      2,
      0,
      1.930042,
      NULL,
      4,
      2,
      2,
      22,
      18.155597,
      NULL,
      NULL,
      2,
      0,
      9.077939,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.699038,
      0,
      NULL,
      0.496945,
      NULL,
      1.273898,
      0,
      0,
      3,
      0.542430,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      4,
      1,
      1,
      3,
      0,
      5.407090,
      0,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.569694,
      0.132528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      2,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1.909927,
      NULL,
      0.200783,
      3,
      NULL,
      1,
      5,
      1,
      2,
      NULL,
      0,
      3,
      0,
      0,
      0,
      4,
      1,
      0,
      1,
      NULL,
      3,
      3,
      1,
      1,
      NULL,
      0,
      3,
      0,
      0.199686,
      1.237332,
      ' 9-22-2000',
      124.550765,
      '10-10-1997',
      16,
      0.134536,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8,
      NULL,
      1.282517,
      5,
      0,
      3.954922,
      0,
      1,
      2.706826,
      0,
      2.104785,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      4.938225,
      0,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      7,
      1.139585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625825,
      0,
      0,
      1.813619,
      0,
      1,
      0,
      2,
      NULL,
      1.300429,
      1.146592,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      1,
      0,
      3,
      0,
      0,
      0,
      0,
      NULL,
      2,
      0,
      0.550604,
      1,
      NULL,
      0,
      NULL,
      0,
      1.016289,
      0.046079,
      NULL,
      1.636297,
      1,
      0.318260,
      NULL,
      1.415253,
      1,
      3,
      0.895695,
      NULL,
      9,
      9,
      7.561646,
      1,
      8.515699,
      0,
      2,
      1.292322,
      4.848087,
      2,
      1.405956,
      0,
      20.730922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      1.595050,
      7.294477,
      NULL,
      '00334',
      '12311',
      0.510495,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      19.950744,
      43,
      33,
      0.920350,
      3,
      2.193737,
      7,
      NULL,
      0,
      2.148587,
      1.658364,
      0.706840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.875561,
      1,
      0,
      0.338554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.871321,
      NULL,
      NULL,
      1.465859,
      NULL,
      NULL,
      0.270032,
      NULL,
      NULL,
      1.370237,
      NULL,
      NULL,
      9.543278,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.231203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989352,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150884,
      NULL,
      NULL,
      1.509185,
      0,
      0.576199,
      2.756292,
      NULL,
      1,
      NULL,
      NULL,
      1.619707,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.007159,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3.944128,
      2.951089,
      NULL,
      NULL,
      0.529062,
      6,
      5,
      0.584679,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653120,
      NULL,
      NULL,
      0.682130,
      NULL,
      NULL,
      1.249503,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.370281,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419836,
      1.490755,
      0.996430,
      3,
      2,
      3,
      NULL,
      3.858477,
      3,
      1,
      NULL,
      3,
      NULL,
      0.899906,
      1.587206,
      0.058723,
      NULL,
      NULL,
      NULL,
      1.087759,
      0.166234,
      0,
      NULL,
      NULL,
      1.596162,
      5,
      NULL,
      1.610050,
      5.926947,
      1.055055,
      3,
      2,
      0,
      1.766820,
      1.462968,
      0.144105,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487117,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.552150,
      NULL,
      NULL,
      1.395849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.437423,
      0,
      0.283022,
      1,
      NULL,
      NULL,
      NULL,
      0.409189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.387266,
      1.134927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.720763,
      3.953551,
      NULL,
      NULL,
      0.558611,
      0.573922,
      NULL,
      NULL,
      0.638481,
      0.357486,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      3.865433,
      NULL,
      NULL,
      1.162233,
      1,
      NULL,
      NULL,
      NULL,
      1.663450,
      NULL,
      NULL,
      NULL,
      0.232089,
      NULL,
      NULL,
      1.274011,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.831805,
      3.353691,
      NULL,
      NULL,
      NULL,
      3.299856,
      NULL,
      NULL,
      3.720096,
      NULL,
      NULL,
      NULL,
      0.276540,
      NULL,
      NULL,
      NULL,
      3,
      0.354979,
      7,
      3,
      2,
      1.480778,
      1,
      NULL,
      NULL,
      1.820019,
      NULL,
      NULL,
      0.367406,
      6,
      4.792723,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.900855,
      28.004935,
      2,
      0,
      3,
      NULL,
      0.085566,
      1.077933,
      0.098043,
      0,
      3.350492,
      1.943651,
      1.039238,
      0,
      2,
      1.807037,
      1.397289,
      0.084037,
      1,
      1.788261,
      2,
      NULL,
      NULL,
      NULL,
      0.764435,
      NULL,
      1.755629,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.164524,
      15.201345,
      6,
      1.479992,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.123826,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203527,
      0,
      1,
      1.130918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220812,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77.553968,
      NULL,
      1.639935,
      NULL,
      0.375088,
      NULL,
      0.576694,
      NULL,
      1,
      0,
      0.416774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      0,
      1.985524,
      7,
      NULL,
      1,
      0,
      NULL,
      1.399135,
      2,
      NULL,
      2,
      NULL,
      186,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.815617,
      NULL,
      1.540712,
      0.357837,
      16,
      NULL,
      1.576263,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.705124,
      0,
      1.252808,
      2,
      3,
      4.554394,
      0.522419,
      3,
      NULL,
      1.400025,
      0.959425,
      NULL,
      1.614295,
      0,
      0.985214,
      0,
      1,
      0.146491,
      0,
      3.645113,
      1,
      1.610649,
      0,
      1,
      NULL,
      0.583548,
      1,
      1,
      0,
      1,
      0,
      0.230546,
      1,
      1,
      1.005378,
      1.661719,
      1.697865,
      1,
      2,
      NULL,
      1.080916,
      3.293997,
      2.595469,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234777,
      1.905137,
      NULL,
      1.577149,
      0,
      NULL,
      3,
      2,
      4,
      0,
      NULL,
      NULL,
      87,
      29.764826,
      2,
      0,
      5.074991,
      NULL,
      '01414',
      '20002',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


