set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      NULL,
      44,
      9,
      NULL,
      NULL,
      1,
      6,
      NULL,
      '3324',
      5.733372,
      0.203055,
      NULL,
      NULL,
      ' 6-23-1984',
      3.021643,
      15.516929,
      NULL,
      2,
      1.549444,
      ' 5-15-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 7-1990',
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.789039,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      0.318360,
      1.037995,
      1.598359,
      3,
      5,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      3,
      3,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.614543,
      1.644414,
      NULL,
      1.092660,
      1,
      0.946234,
      NULL,
      0,
      1,
      0.908849,
      NULL,
      3.006325,
      1.239356,
      0,
      NULL,
      0.720979,
      NULL,
      1,
      0,
      7.065411,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1.453838,
      5,
      1,
      0,
      5,
      0,
      NULL,
      0,
      1,
      4,
      0,
      4,
      0,
      3,
      0,
      1,
      0,
      4,
      2,
      3,
      NULL,
      4,
      NULL,
      NULL,
      1,
      3,
      1,
      3.456583,
      '11-24-1997',
      88.165574,
      NULL,
      70,
      2.279287,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.638183,
      7,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.049849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858011,
      0.855202,
      NULL,
      NULL,
      1.935947,
      1,
      1.536684,
      0.057993,
      5.015220,
      0,
      1.852318,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      1,
      2,
      0,
      2,
      0,
      3,
      1,
      NULL,
      0,
      0.187273,
      6.150901,
      NULL,
      5,
      1.647454,
      0,
      0,
      1.896515,
      0,
      1.086904,
      0,
      0.942465,
      NULL,
      1.958287,
      0.103611,
      0,
      NULL,
      6.575850,
      NULL,
      NULL,
      0.652549,
      7.928089,
      9.544446,
      NULL,
      2.449151,
      5.032839,
      2.369706,
      3.669039,
      1,
      0.714627,
      2,
      1,
      NULL,
      2.252336,
      30,
      NULL,
      20,
      8,
      NULL,
      5,
      NULL,
      '32123',
      '',
      '',
      2,
      '210',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      6.988988,
      32.426074,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.430900,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.924785,
      NULL,
      NULL,
      1.923374,
      1,
      3,
      0,
      3.699067,
      2,
      1,
      0,
      3,
      0.396375,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0.067343,
      0.433865,
      3,
      0,
      0.442059,
      3.150978,
      NULL,
      1.980858,
      1,
      0,
      0,
      1,
      3,
      0.993127,
      1.208126,
      1.275498,
      3.471564,
      1,
      3.927686,
      0.046008,
      2.169116,
      NULL,
      2,
      3.129261,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.521324,
      1.046445,
      7,
      3,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.832164,
      NULL,
      NULL,
      0,
      NULL,
      0.377545,
      2.522331,
      1.592278,
      0,
      0,
      NULL,
      NULL,
      1.093197,
      5,
      2,
      0.594448,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.655755,
      NULL,
      NULL,
      0.345595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127002,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.904421,
      NULL,
      NULL,
      1,
      2.470840,
      1,
      0,
      NULL,
      NULL,
      0.177643,
      1.334533,
      1.057617,
      4.730362,
      2,
      4.353305,
      1,
      NULL,
      NULL,
      2,
      3,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287199,
      4.506707,
      NULL,
      1.235130,
      NULL,
      1.941118,
      NULL,
      NULL,
      NULL,
      1,
      0.038338,
      0.423036,
      3.741778,
      0.277985,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0,
      2,
      4,
      NULL,
      0,
      0,
      0,
      1,
      1.696029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.329747,
      0,
      1.129265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.687571,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.062020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808932,
      NULL,
      NULL,
      1.553000,
      NULL,
      0,
      92.313824,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.188594,
      NULL,
      1.999712,
      NULL,
      0.088353,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.475524,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.730156,
      3,
      6,
      3.301129,
      NULL,
      3.752213,
      1.638453,
      3.721901,
      0.491902,
      1,
      NULL,
      NULL,
      1.599567,
      0.222766,
      NULL,
      0.172024,
      3,
      NULL,
      0.409087,
      NULL,
      NULL,
      0.934119,
      1.838786,
      NULL,
      0,
      2,
      NULL,
      1.638621,
      1,
      NULL,
      0.142575,
      1,
      NULL,
      0,
      2.271095,
      NULL,
      1.143694,
      NULL,
      NULL,
      0.574927,
      2.679661,
      NULL,
      1,
      1.681276,
      1.381861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      0,
      5,
      3,
      NULL,
      1,
      8,
      39,
      5,
      3,
      NULL,
      '14432',
      '',
      '',
      NULL,
      '144',
      NULL,
      '',
      1.906870,
      '',
      '',
      '');
commit;
end;
/


