set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9334584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      '30',
      8.938388,
      NULL,
      '3032403',
      1,
      NULL,
      5,
      0,
      '1131',
      2.645193,
      1.082825,
      NULL,
      NULL,
      ' 4- 4-1996',
      1,
      3.059243,
      NULL,
      3.059478,
      0,
      '11-29-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-14-1986',
      ' 5- 8-1991',
      ' 9-26-2000',
      2.457212,
      2,
      1.503970,
      1,
      NULL,
      0.211704,
      NULL,
      1.329864,
      NULL,
      NULL,
      NULL,
      6,
      5.831799,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0.715882,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1.152654,
      0,
      2,
      0.221870,
      3,
      2,
      3,
      NULL,
      3,
      1,
      2,
      0,
      2,
      NULL,
      4,
      NULL,
      NULL,
      1,
      0,
      0,
      7,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.539364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      3,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0.363193,
      NULL,
      0.846844,
      0,
      4,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      3,
      1,
      0,
      3,
      0,
      2,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      1,
      1.718822,
      0.782306,
      ' 9-19-1981',
      40.012992,
      NULL,
      NULL,
      1.126751,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      14,
      2.678598,
      1,
      1,
      3.246778,
      0.102877,
      1.195957,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494148,
      1.836644,
      NULL,
      NULL,
      NULL,
      6.701957,
      9,
      1.935094,
      NULL,
      NULL,
      1,
      2,
      3,
      2,
      1,
      3,
      NULL,
      ' 0- 3-1999',
      10,
      ' 2-24-1985',
      0,
      1,
      NULL,
      1,
      2,
      1,
      0.497219,
      NULL,
      0.022973,
      NULL,
      0,
      3,
      19.654587,
      2.087821,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      0,
      3,
      2.414968,
      NULL,
      NULL,
      0,
      0,
      1.887967,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.617716,
      NULL,
      1.745748,
      1.918379,
      10.269123,
      2.482674,
      9,
      NULL,
      5,
      NULL,
      3,
      7,
      NULL,
      NULL,
      NULL,
      54.428725,
      1,
      NULL,
      18,
      NULL,
      39,
      46.212275,
      4,
      NULL,
      3.603345,
      '13321',
      '',
      '',
      1.849229,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      NULL,
      30.893733,
      12.533985,
      NULL,
      1,
      NULL,
      2,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.212872,
      NULL,
      NULL,
      1.230184,
      NULL,
      NULL,
      1.297924,
      NULL,
      NULL,
      1.592038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388482,
      NULL,
      NULL,
      0.719086,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.578675,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.729162,
      NULL,
      NULL,
      0.497515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825851,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.141718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.919795,
      3.076898,
      0,
      NULL,
      NULL,
      1.990358,
      NULL,
      NULL,
      1.097104,
      NULL,
      NULL,
      3,
      3,
      3.376878,
      1.505032,
      2,
      1,
      3.848872,
      1,
      0,
      2.083163,
      NULL,
      1,
      0.465879,
      NULL,
      NULL,
      1.349136,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517364,
      NULL,
      NULL,
      1.145648,
      NULL,
      NULL,
      2,
      1.573492,
      1.821101,
      0,
      NULL,
      NULL,
      4.704164,
      4,
      1,
      NULL,
      4,
      3.855731,
      3,
      1,
      1,
      0.808564,
      0,
      0.004372,
      0,
      1.980006,
      1.273002,
      3.670170,
      NULL,
      1.228194,
      1.888526,
      0.946705,
      0.316684,
      0,
      1,
      1.185665,
      1.575200,
      1.300094,
      0,
      3.613320,
      2,
      NULL,
      1,
      3,
      1,
      5,
      NULL,
      3,
      0.514145,
      NULL,
      NULL,
      1.507378,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.120420,
      1.100836,
      2,
      0,
      1,
      0,
      0.699585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811759,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.061268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827415,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.364199,
      NULL,
      NULL,
      NULL,
      3.157872,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.701765,
      NULL,
      0.574668,
      0.176252,
      9,
      2,
      1,
      1.180834,
      52,
      NULL,
      3,
      NULL,
      1.808611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.684927,
      NULL,
      NULL,
      0.028014,
      NULL,
      NULL,
      0.231215,
      NULL,
      0.994262,
      337.799429,
      3157,
      0,
      0.574932,
      NULL,
      0.578919,
      1.957000,
      0.491884,
      1.832629,
      0,
      0.024562,
      0,
      NULL,
      0.188790,
      1,
      1,
      1.378779,
      0,
      0,
      1.374484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.804434,
      0.252530,
      1.090977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.743749,
      NULL,
      0.251190,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.939747,
      1.051277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.332136,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707481,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.252494,
      3,
      0.508328,
      NULL,
      NULL,
      NULL,
      0.427411,
      0.257803,
      1.377710,
      NULL,
      NULL,
      0.708496,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      5,
      NULL,
      1,
      1,
      12.104793,
      1.124449,
      0,
      3.143409,
      NULL,
      0.063605,
      3.199385,
      NULL,
      3.573484,
      3,
      0.694190,
      3,
      2.011478,
      1,
      1,
      NULL,
      2.675821,
      3.135024,
      3.764981,
      1.622045,
      1.292882,
      3.208147,
      2.717031,
      0.847727,
      1.879948,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.570034,
      0,
      2,
      2,
      0.112873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.448458,
      NULL,
      0,
      0,
      1.419916,
      3,
      1,
      4,
      0.825871,
      NULL,
      NULL,
      NULL,
      75.914001,
      5,
      5,
      NULL,
      NULL,
      '10212',
      '',
      2.363050,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


