set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7603326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '0322004',
      0,
      1,
      4,
      3,
      '0434',
      0,
      0.008255,
      NULL,
      NULL,
      ' 0-20-2001',
      6.792153,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      ' 2- 9-1984',
      '10-11-1998',
      NULL,
      NULL,
      1,
      0.745017,
      2.194153,
      NULL,
      1,
      0,
      0.389943,
      NULL,
      NULL,
      NULL,
      2.080731,
      1,
      16,
      NULL,
      3,
      3.843498,
      1,
      0,
      4,
      1,
      NULL,
      0,
      1.156600,
      1,
      1.249816,
      NULL,
      2,
      1.511991,
      1.603735,
      0.732018,
      1,
      NULL,
      3,
      1,
      4,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      3,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.664124,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.869488,
      0.537773,
      2,
      0,
      0.805712,
      0.756617,
      0.482346,
      NULL,
      2,
      0.022015,
      NULL,
      1.675822,
      1.331467,
      1,
      0,
      0,
      4,
      1,
      4,
      7,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      2,
      4,
      NULL,
      1,
      2,
      NULL,
      2,
      NULL,
      1,
      4.553929,
      0,
      2,
      1,
      0,
      1.688545,
      NULL,
      0.759815,
      5,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      1,
      NULL,
      5,
      5,
      1,
      1,
      4,
      NULL,
      5,
      3,
      3,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      2,
      0,
      ' 8-20-1994',
      206.346310,
      NULL,
      3.747721,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      1.841126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      2,
      3.071767,
      1,
      1.517349,
      NULL,
      1.012840,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.646364,
      0.590347,
      1,
      1.468822,
      1,
      NULL,
      NULL,
      44.480219,
      0.896845,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      0,
      3,
      3,
      1,
      0,
      1,
      0,
      2,
      0,
      0.509919,
      0,
      1.254046,
      1.271119,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1.530508,
      0,
      NULL,
      0,
      0,
      5.835694,
      0,
      4,
      4,
      3.502531,
      9.301550,
      1.365139,
      4.409135,
      3,
      0.209469,
      NULL,
      2,
      0.777044,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      37,
      NULL,
      NULL,
      5,
      0.774460,
      3,
      '21144',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      32.685146,
      35,
      1.275559,
      0.148305,
      NULL,
      NULL,
      NULL,
      NULL,
      1.598994,
      2,
      0.763775,
      1,
      NULL,
      NULL,
      0.931404,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.545907,
      2.961064,
      0,
      NULL,
      NULL,
      NULL,
      3.536944,
      NULL,
      0.642901,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.514827,
      NULL,
      NULL,
      1.251758,
      NULL,
      NULL,
      2,
      2,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.757275,
      NULL,
      NULL,
      NULL,
      0.561382,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928025,
      NULL,
      NULL,
      1.018605,
      NULL,
      NULL,
      0.516165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.907661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.398044,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.715184,
      NULL,
      NULL,
      0.745465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.232889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.987327,
      1.338235,
      NULL,
      NULL,
      NULL,
      4,
      3.552852,
      5,
      1.427794,
      NULL,
      NULL,
      0.096347,
      NULL,
      2,
      0,
      1.834274,
      3,
      1.468337,
      0.480818,
      2,
      1.321984,
      1,
      1.327040,
      3.475973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.203611,
      1.858021,
      0.174620,
      0,
      0.645078,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819619,
      0,
      NULL,
      0.620313,
      NULL,
      1.416948,
      0.494616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.985434,
      1.543888,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.781312,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.517735,
      NULL,
      NULL,
      1.418073,
      NULL,
      1.306953,
      1.389919,
      1,
      1,
      1,
      1,
      1.710823,
      NULL,
      NULL,
      0.285582,
      0.091509,
      NULL,
      1,
      1.431150,
      1.478560,
      1,
      0,
      1.512533,
      1.934961,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5,
      NULL,
      0.753278,
      1,
      3,
      7.761796,
      0.064042,
      1.299045,
      0,
      0.838998,
      0.107160,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0.124782,
      0.991587,
      NULL,
      0.251817,
      1,
      NULL,
      1.956339,
      0.562580,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.120683,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254725,
      1.212410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080668,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      149,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


