set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '2023100',
      3.033804,
      0.685666,
      0,
      NULL,
      '3314',
      0,
      0,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      2,
      NULL,
      0.641847,
      ' 4-11-1982',
      12,
      1.578165,
      45.105833,
      104,
      3,
      '11-28-1987',
      ' 9-27-1978',
      '10-12-1982',
      NULL,
      0,
      2,
      1.551526,
      0,
      NULL,
      0,
      1.616361,
      0,
      17.523122,
      1,
      NULL,
      NULL,
      18,
      6,
      0,
      NULL,
      4,
      0,
      9,
      0,
      1,
      0,
      0.882808,
      NULL,
      0,
      1,
      3.965572,
      0,
      0.979935,
      1.044815,
      0,
      3,
      1,
      1.878173,
      0,
      1,
      0,
      NULL,
      NULL,
      4,
      2,
      0,
      2,
      2,
      2,
      1,
      4.202522,
      1,
      NULL,
      0,
      NULL,
      0.130788,
      NULL,
      NULL,
      1.395423,
      NULL,
      NULL,
      5,
      0,
      1.844371,
      2,
      0,
      NULL,
      2,
      3.683644,
      3,
      0.807937,
      0,
      0,
      2,
      0.768367,
      0,
      3,
      NULL,
      0,
      1.585262,
      2,
      1,
      3,
      4.167617,
      0,
      0,
      2.355404,
      1.790850,
      NULL,
      NULL,
      1.079853,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      2,
      1,
      1,
      1,
      3,
      3,
      0,
      1,
      6,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      3,
      NULL,
      0,
      4,
      2,
      2,
      NULL,
      5,
      1,
      2,
      1,
      0,
      3,
      7,
      1.174353,
      NULL,
      37.554773,
      ' 8- 0-1997',
      19.845904,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705348,
      0.685724,
      3.521663,
      3.646667,
      1.989626,
      0,
      0.060133,
      1.825166,
      1,
      0,
      4.022506,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.749409,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.637054,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.240749,
      29,
      3.953567,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055570,
      1,
      1,
      0,
      3,
      2,
      0,
      0,
      NULL,
      3,
      3,
      1,
      NULL,
      3.938444,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      1.215779,
      0.812463,
      0,
      0,
      1.101484,
      0,
      1.160266,
      NULL,
      0,
      7,
      0.576521,
      11,
      NULL,
      NULL,
      NULL,
      11,
      3.150322,
      NULL,
      0.734541,
      NULL,
      1,
      1,
      3,
      NULL,
      2,
      0.825609,
      NULL,
      41,
      NULL,
      83.980201,
      1,
      0,
      0.243305,
      '41023',
      NULL,
      '',
      1.368020,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      1,
      25,
      1.198491,
      1.784527,
      1.639281,
      0.808173,
      2.219183,
      3,
      1,
      NULL,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.122557,
      0.863633,
      1,
      2.938198,
      NULL,
      0.367007,
      0,
      0,
      1,
      3,
      3,
      1.801678,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146844,
      3,
      3.332238,
      NULL,
      0.664973,
      3.361271,
      3,
      1.361559,
      NULL,
      NULL,
      NULL,
      6.608796,
      0,
      7.462745,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.827863,
      NULL,
      NULL,
      1.159997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.063832,
      6.261018,
      3,
      1,
      0,
      1.336152,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.322996,
      NULL,
      NULL,
      2.913314,
      NULL,
      1.954577,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.431414,
      1.059942,
      2,
      0,
      3.376307,
      1.487831,
      NULL,
      NULL,
      4.173825,
      1.913167,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871022,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.655126,
      1.586352,
      3,
      3,
      0.804262,
      4,
      NULL,
      4.934971,
      1,
      6.100689,
      NULL,
      NULL,
      3,
      1.811036,
      3.005195,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      2.564680,
      7,
      0.506037,
      6.470657,
      NULL,
      3.814728,
      1.553347,
      0.057333,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.659814,
      0,
      2,
      7,
      1,
      NULL,
      0,
      2.535604,
      1,
      NULL,
      4,
      4,
      0,
      0,
      0,
      0,
      NULL,
      3.222413,
      NULL,
      NULL,
      1.230099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.995293,
      NULL,
      NULL,
      0.756043,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.205853,
      NULL,
      NULL,
      1.813853,
      1,
      NULL,
      NULL,
      1,
      2,
      1.611199,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      119,
      NULL,
      NULL,
      NULL,
      0.501116,
      NULL,
      NULL,
      NULL,
      0.332265,
      NULL,
      NULL,
      NULL,
      1.367573,
      NULL,
      NULL,
      NULL,
      1.936988,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.147847,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.675144,
      NULL,
      NULL,
      NULL,
      0.885109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.715146,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.426453,
      2.502688,
      4,
      0,
      1.226028,
      27,
      18,
      1,
      NULL,
      NULL,
      1.048936,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.421543,
      NULL,
      4,
      1.074060,
      NULL,
      NULL,
      1.815889,
      NULL,
      1.047676,
      0.431705,
      0.119664,
      1,
      0.362744,
      1.188757,
      1,
      0.505095,
      0.137607,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0.416377,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333280,
      NULL,
      1.860013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.881334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.215993,
      NULL,
      3.852370,
      NULL,
      0.197467,
      NULL,
      1.844515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.523827,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      0,
      1.539533,
      0,
      4,
      1,
      NULL,
      NULL,
      3.865820,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0.843861,
      NULL,
      0.921005,
      0,
      NULL,
      2.238431,
      0.313362,
      NULL,
      1,
      1.544929,
      NULL,
      1,
      1,
      NULL,
      1.393281,
      NULL,
      NULL,
      NULL,
      0.977249,
      NULL,
      0.452220,
      2.938577,
      NULL,
      0.307211,
      NULL,
      NULL,
      0,
      NULL,
      0.771475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036879,
      3,
      NULL,
      1,
      NULL,
      0.300383,
      NULL,
      1.599127,
      NULL,
      1.982200,
      NULL,
      1.855550,
      NULL,
      0.867054,
      NULL,
      NULL,
      NULL,
      1.186456,
      NULL,
      2,
      NULL,
      1.738345,
      NULL,
      1.697331,
      NULL,
      0.146543,
      NULL,
      NULL,
      0.183632,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.955815,
      NULL,
      0,
      4,
      7,
      0.820600,
      NULL,
      NULL,
      28,
      10,
      NULL,
      1,
      1,
      '30312',
      '14110',
      '',
      0.097427,
      '',
      NULL,
      '',
      0.731321,
      '',
      '',
      '');
commit;
end;
/


