set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '4114402',
      2.649161,
      0,
      NULL,
      0,
      '4422',
      1,
      0.202144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      2,
      ' 8-18-1974',
      NULL,
      3,
      NULL,
      54,
      2,
      NULL,
      ' 4- 2-1989',
      '10-17-2000',
      1.703485,
      0,
      3,
      1,
      NULL,
      0.662566,
      0,
      0,
      0.615695,
      5.898285,
      1,
      16.171828,
      NULL,
      15,
      5.659441,
      0,
      2.492641,
      0,
      2,
      2.966022,
      0.190771,
      0,
      1,
      1.237141,
      1.843016,
      1.937193,
      1.348165,
      2.582411,
      0.573660,
      0,
      1.629902,
      3,
      0,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      3,
      0,
      NULL,
      5.804934,
      2,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1.517459,
      0.368051,
      2,
      NULL,
      NULL,
      2,
      1.713646,
      0,
      0,
      2,
      1,
      0.105886,
      0,
      1.205281,
      1.794404,
      NULL,
      0,
      2,
      3,
      3,
      NULL,
      0,
      0.439224,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      5,
      4,
      NULL,
      NULL,
      2,
      4,
      NULL,
      0,
      3,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      4,
      1,
      0,
      5,
      4,
      0,
      3,
      1,
      NULL,
      NULL,
      5,
      NULL,
      2,
      3,
      NULL,
      1,
      3,
      2,
      0,
      3,
      4,
      0,
      2.740233,
      NULL,
      ' 0-25-1980',
      202.186507,
      ' 6-19-1986',
      147,
      2,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      5,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      1.823429,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114784,
      NULL,
      0,
      NULL,
      7,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.656017,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.875595,
      0.771003,
      0.387852,
      0,
      0.750959,
      0,
      1,
      3,
      24,
      3.452417,
      0.358426,
      NULL,
      NULL,
      NULL,
      2,
      1.650661,
      1,
      1,
      NULL,
      NULL,
      2,
      2,
      2,
      2,
      1,
      NULL,
      3,
      1,
      2,
      1.107124,
      3.131994,
      0,
      0.893416,
      1.942524,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.416769,
      NULL,
      1.345827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66,
      NULL,
      92.877087,
      4,
      0,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.063211,
      '',
      '',
      '',
      1.388307,
      18.271347,
      1.332344,
      33,
      2,
      20,
      6.120905,
      2.947671,
      5,
      NULL,
      1,
      NULL,
      1.675701,
      0.693447,
      3.208371,
      1.432912,
      NULL,
      NULL,
      3,
      3.196940,
      3,
      0.018652,
      NULL,
      NULL,
      2.454778,
      1.409403,
      0.004680,
      2,
      0,
      0.142120,
      1.866188,
      NULL,
      NULL,
      3,
      1,
      0.016095,
      2,
      3.351940,
      1,
      3,
      0.550127,
      NULL,
      0.149110,
      NULL,
      NULL,
      NULL,
      1,
      4.320603,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.709158,
      1,
      NULL,
      NULL,
      1.715510,
      NULL,
      NULL,
      2.348002,
      0,
      1,
      NULL,
      0,
      0.093657,
      3.661329,
      0,
      1.466178,
      3.239773,
      1,
      0.664786,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5,
      1,
      0,
      1.131981,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.498797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186191,
      0.740384,
      NULL,
      NULL,
      4,
      4.986635,
      1,
      2.271132,
      2.522062,
      0.503443,
      NULL,
      3.988069,
      NULL,
      3.895509,
      7,
      0.748261,
      0.078213,
      NULL,
      NULL,
      0.098313,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.645631,
      NULL,
      1,
      5.631871,
      NULL,
      1,
      6,
      5.248743,
      3.593445,
      2,
      1.009844,
      1,
      1.240885,
      3,
      NULL,
      1.506235,
      3.536339,
      2,
      2,
      1.498431,
      0.474893,
      6.501620,
      2,
      1.965852,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.931169,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.460131,
      2,
      4,
      3,
      3,
      0,
      4,
      3,
      1,
      1.137079,
      0,
      1.889081,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.806805,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.693253,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940228,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.549942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.761042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215312,
      NULL,
      NULL,
      NULL,
      1.411649,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.184498,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      3.232982,
      NULL,
      1,
      NULL,
      3,
      20,
      NULL,
      1.789180,
      NULL,
      NULL,
      0.836196,
      NULL,
      NULL,
      0.647248,
      NULL,
      NULL,
      NULL,
      16.986037,
      NULL,
      0,
      NULL,
      NULL,
      0.277537,
      NULL,
      1.380440,
      0,
      2,
      NULL,
      1.189273,
      1,
      1,
      1,
      1,
      1.819870,
      0.693206,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.494471,
      1,
      1,
      NULL,
      1.151050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.140352,
      NULL,
      0.728095,
      0.520221,
      NULL,
      NULL,
      NULL,
      1.877666,
      1.851859,
      1.029657,
      0.732327,
      NULL,
      0,
      1.194867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      7.098096,
      NULL,
      0,
      0.192457,
      1,
      0.330627,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.467620,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.022963,
      1.451743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.766909,
      1.330844,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201630,
      NULL,
      0.079531,
      NULL,
      4,
      3,
      0,
      1.312776,
      NULL,
      NULL,
      102,
      93.862878,
      3,
      NULL,
      3,
      '14202',
      '',
      '',
      1.292873,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL);
commit;
end;
/


