set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '2012204',
      2.014221,
      1,
      NULL,
      0,
      '1023',
      2,
      NULL,
      NULL,
      NULL,
      '11-29-2001',
      NULL,
      NULL,
      3,
      1.760260,
      NULL,
      ' 1-19-1979',
      12.222958,
      2,
      194,
      61,
      0,
      '10-12-1983',
      ' 9- 7-1985',
      '11-11-1983',
      2.689765,
      2,
      0.953400,
      3.364651,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2.535020,
      7,
      17,
      3.424947,
      10.212135,
      9.373032,
      0,
      6,
      0,
      3,
      4.311223,
      NULL,
      NULL,
      0,
      0,
      0,
      1.305249,
      0,
      1.386548,
      0.967628,
      NULL,
      1.660892,
      3,
      5,
      4,
      0,
      5,
      NULL,
      0,
      5,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      2,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.602294,
      3,
      0.088281,
      1.617443,
      2.487549,
      0.446283,
      3.578126,
      NULL,
      NULL,
      1.036447,
      3.856410,
      0,
      2.883661,
      1.550204,
      NULL,
      0,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      2,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0.783449,
      NULL,
      0,
      2,
      3,
      0,
      3,
      1,
      1,
      5,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      4,
      4,
      NULL,
      NULL,
      NULL,
      3,
      2,
      5,
      0,
      3,
      4,
      5,
      1,
      '10-14-1983',
      72.015440,
      ' 2-29-1977',
      95.024558,
      0,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      NULL,
      0,
      1,
      0,
      1.194132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      47.010125,
      2,
      NULL,
      4,
      1,
      0,
      1.735342,
      0,
      0.431170,
      0,
      0,
      2,
      2.847274,
      2.819414,
      1.100556,
      4,
      1,
      3.446985,
      1,
      1.515212,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.706548,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.123625,
      NULL,
      1.242500,
      1,
      0.027672,
      3,
      12,
      1.904859,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      3,
      NULL,
      2,
      3,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.623680,
      0,
      1.343057,
      1,
      1.269977,
      0.005009,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.934025,
      2,
      0,
      9,
      8,
      4.774059,
      10,
      NULL,
      4,
      NULL,
      2.679139,
      4.452636,
      3.821744,
      1,
      0,
      57,
      2,
      1,
      NULL,
      49,
      NULL,
      40.274234,
      NULL,
      1.174149,
      1,
      '01232',
      '',
      '',
      1.547446,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.027851,
      NULL,
      23,
      0,
      3.653681,
      18,
      6.879729,
      1.897162,
      0,
      0,
      NULL,
      1,
      0,
      1.758413,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.218292,
      0.489417,
      2.309065,
      1,
      NULL,
      1.233591,
      1,
      1,
      0,
      1,
      1.300702,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.674179,
      NULL,
      2,
      1,
      1,
      3,
      0.795420,
      0,
      NULL,
      NULL,
      2,
      3.376615,
      3,
      0,
      0.045154,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939978,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.237893,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.313144,
      0,
      3.911312,
      2.946398,
      1.094206,
      NULL,
      NULL,
      NULL,
      1.398601,
      NULL,
      NULL,
      NULL,
      1.555296,
      NULL,
      NULL,
      2.220292,
      NULL,
      1,
      2.133125,
      3,
      1,
      0,
      1.949568,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      1.344932,
      NULL,
      0,
      0,
      0.119552,
      NULL,
      NULL,
      1.474697,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.302945,
      1,
      4,
      3,
      5.889118,
      1.390702,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.718490,
      NULL,
      NULL,
      1.096472,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581152,
      NULL,
      2.275286,
      0.488778,
      NULL,
      NULL,
      1,
      2.606680,
      6,
      1.179461,
      3.247947,
      5.559905,
      4,
      NULL,
      0,
      3,
      NULL,
      1.366345,
      2.890710,
      3,
      1.210035,
      2.568415,
      1,
      0.032905,
      0.642792,
      NULL,
      0,
      0,
      3,
      0.614217,
      NULL,
      NULL,
      1.103106,
      0.026249,
      1.898354,
      0.250584,
      0,
      2,
      7.461168,
      0.191884,
      5.564053,
      4,
      5.640819,
      4,
      0.313257,
      NULL,
      2,
      0.460904,
      0.913600,
      0.483247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.655106,
      NULL,
      NULL,
      0.996769,
      NULL,
      NULL,
      3.770938,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      1.816068,
      NULL,
      NULL,
      1.222146,
      3,
      NULL,
      NULL,
      NULL,
      2.744677,
      NULL,
      NULL,
      NULL,
      52.177256,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.740839,
      NULL,
      NULL,
      NULL,
      1.535816,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.351469,
      NULL,
      NULL,
      NULL,
      0.318200,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.495551,
      NULL,
      NULL,
      NULL,
      2.885944,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.214262,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.024217,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      7.866093,
      9.781335,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945295,
      NULL,
      NULL,
      0,
      33.040916,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.431035,
      1.951235,
      1,
      0.886403,
      NULL,
      0,
      1.840852,
      0,
      0,
      0.154375,
      NULL,
      1.723518,
      1.512416,
      1.331964,
      0.094018,
      0.961716,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.580233,
      0.649333,
      0.026363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.978760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026406,
      1.120221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.844993,
      0.727851,
      1.990753,
      3,
      1.726170,
      0,
      NULL,
      7,
      0,
      0.100622,
      1,
      1.342574,
      1.268034,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.134960,
      0.923637,
      NULL,
      2,
      3,
      2.356983,
      1.019929,
      0.670538,
      1.110498,
      1,
      NULL,
      0,
      0.117417,
      NULL,
      1,
      NULL,
      NULL,
      1.928396,
      1.224078,
      NULL,
      0.875291,
      NULL,
      NULL,
      1,
      1.529647,
      NULL,
      0.055181,
      NULL,
      NULL,
      0.157687,
      2,
      NULL,
      1.551184,
      1,
      NULL,
      0.365688,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.198646,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367574,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.233181,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.761122,
      NULL,
      NULL,
      0.616911,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4,
      1,
      1,
      1.998664,
      NULL,
      NULL,
      NULL,
      13.560995,
      2,
      0,
      2,
      '21233',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


