set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '1313224',
      1.171857,
      0,
      3,
      NULL,
      '0014',
      NULL,
      NULL,
      5,
      14,
      ' 9- 7-1986',
      40,
      NULL,
      4,
      2.683946,
      NULL,
      ' 0-28-1989',
      45,
      NULL,
      178,
      83.525007,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      1.096446,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      16,
      5,
      8.509330,
      2,
      NULL,
      2,
      1.244969,
      2,
      NULL,
      0.751397,
      NULL,
      0,
      1.058971,
      NULL,
      0,
      1.398411,
      1.417977,
      0,
      4,
      5,
      1.226212,
      1,
      1,
      1,
      1,
      1,
      1,
      4,
      0,
      1,
      1,
      0,
      1,
      5,
      1,
      0,
      1,
      0,
      0.718281,
      NULL,
      NULL,
      1.335700,
      NULL,
      NULL,
      0,
      NULL,
      0.356546,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.455253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      0,
      2.784587,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      2,
      0,
      1,
      4,
      0,
      4,
      3,
      0,
      0,
      2,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      4,
      NULL,
      1,
      3,
      2,
      5,
      0.231767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.406461,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.580235,
      0.071670,
      1,
      1.282047,
      1,
      NULL,
      NULL,
      NULL,
      1.489002,
      1.688778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.161382,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      2,
      3,
      1,
      1,
      2,
      1,
      0,
      2.206024,
      1,
      1,
      NULL,
      0.156520,
      NULL,
      NULL,
      1.742488,
      0.445630,
      1.927045,
      0,
      1,
      0,
      0.911328,
      0.507273,
      NULL,
      1.139260,
      3,
      4.199489,
      NULL,
      5,
      7.395645,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      88,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      '',
      '',
      '',
      0,
      '04044',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2,
      20,
      18.715036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436581,
      NULL,
      NULL,
      1.687599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.202234,
      NULL,
      NULL,
      2,
      2.978923,
      NULL,
      0,
      NULL,
      NULL,
      1.399134,
      NULL,
      NULL,
      0.121259,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.755989,
      NULL,
      NULL,
      2.096501,
      5,
      2.210979,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.465439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.017439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642826,
      NULL,
      NULL,
      1.897739,
      NULL,
      NULL,
      1.828629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254567,
      NULL,
      NULL,
      NULL,
      8.027576,
      NULL,
      1,
      NULL,
      NULL,
      2.318378,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      0.578134,
      5.941999,
      1,
      1,
      NULL,
      NULL,
      1.752397,
      NULL,
      NULL,
      0.954116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.644721,
      1.277580,
      2.408647,
      1.537193,
      2.794671,
      3,
      0,
      NULL,
      3,
      4,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.971241,
      19.785461,
      3,
      2,
      NULL,
      NULL,
      1,
      8.440845,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.591272,
      NULL,
      2.655828,
      8,
      NULL,
      5.175432,
      3.200905,
      0.900698,
      0.298806,
      1.666457,
      NULL,
      NULL,
      1.776820,
      NULL,
      1.727300,
      1.641214,
      1.250673,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.696406,
      0,
      0.636668,
      0.495404,
      0,
      1.414295,
      0.674395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.090293,
      NULL,
      NULL,
      0.446450,
      NULL,
      NULL,
      0.524687,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      83,
      NULL,
      NULL,
      NULL,
      1.238432,
      0.880566,
      1,
      NULL,
      1.726968,
      NULL,
      0,
      0.223274,
      1.059492,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0.542211,
      NULL,
      1.104321,
      1,
      0,
      NULL,
      NULL,
      1.218224,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.099031,
      NULL,
      NULL,
      2.646815,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11.659817,
      NULL,
      NULL,
      0.217228,
      1.246116,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.355413,
      NULL,
      1,
      NULL,
      0,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      65,
      3,
      1,
      0.808456,
      NULL,
      '',
      '',
      NULL,
      '21432',
      '',
      '',
      0.648080,
      '',
      '',
      NULL);
commit;
end;
/


