set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '3020232',
      3.629768,
      0.121592,
      1,
      0,
      NULL,
      2,
      1.137628,
      NULL,
      NULL,
      ' 9-23-1984',
      36,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      10.716692,
      3.203680,
      NULL,
      29,
      2,
      ' 0- 3-1991',
      '10-15-1993',
      '10-18-1999',
      3,
      3,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0,
      2,
      13.413149,
      NULL,
      28,
      5,
      0,
      2,
      0,
      0,
      1,
      0,
      0.797176,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      4,
      3,
      0,
      2.265516,
      5,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      4,
      2,
      5,
      8.453340,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0.368124,
      NULL,
      NULL,
      2,
      1,
      0.271954,
      1.502795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.505289,
      1,
      0,
      0,
      0.631828,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      5,
      1,
      1,
      NULL,
      2,
      0,
      0,
      1,
      2,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      2,
      3,
      2,
      2,
      0,
      2,
      1,
      3,
      0,
      ' 4-17-2003',
      100.100583,
      ' 7-16-1974',
      55.289813,
      2,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0,
      NULL,
      5,
      NULL,
      1.400892,
      0.775257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513866,
      NULL,
      3,
      NULL,
      2.282215,
      1.673471,
      NULL,
      NULL,
      NULL,
      1,
      3.811411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626770,
      1.588354,
      1,
      1,
      0.986053,
      0.538251,
      NULL,
      1.485894,
      0.034168,
      NULL,
      NULL,
      NULL,
      1,
      0.720084,
      0.908322,
      0,
      2,
      3,
      NULL,
      3,
      1,
      1,
      NULL,
      2,
      2,
      1.266890,
      1.614391,
      0.693391,
      3,
      0,
      0.549944,
      0.116937,
      3.513786,
      1.044440,
      1.284199,
      1,
      0.901223,
      1,
      0.503478,
      0,
      NULL,
      0.121351,
      4,
      1,
      NULL,
      10.327893,
      0,
      NULL,
      NULL,
      6,
      4.315765,
      1.676937,
      NULL,
      3.740835,
      1,
      NULL,
      58,
      2,
      3.859284,
      NULL,
      32,
      47,
      21.595992,
      5,
      NULL,
      NULL,
      '30030',
      '33103',
      '',
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      NULL,
      9,
      NULL,
      31,
      NULL,
      8.351684,
      0.390929,
      3.088425,
      0,
      1.778537,
      0.675909,
      1,
      3.835734,
      0.333655,
      0.120114,
      0,
      NULL,
      NULL,
      0.596673,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.413470,
      3.833681,
      NULL,
      3,
      2,
      0.815831,
      NULL,
      NULL,
      0,
      0.416737,
      0.478397,
      2.321328,
      0,
      2,
      1,
      0,
      3,
      2.255524,
      1.427046,
      5.659346,
      0.748126,
      7,
      NULL,
      0.025886,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.117003,
      1.468005,
      0,
      NULL,
      0.168974,
      NULL,
      NULL,
      NULL,
      0,
      1.942138,
      1,
      2,
      0.938413,
      0,
      0.426996,
      NULL,
      0.461257,
      3,
      0.340148,
      0.085754,
      1,
      2,
      1.101637,
      1.740628,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.788196,
      2.924410,
      1.929942,
      2,
      1,
      0.574824,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.040051,
      NULL,
      NULL,
      NULL,
      0.115060,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.374036,
      2,
      1,
      0,
      NULL,
      NULL,
      3.610413,
      6.655458,
      NULL,
      0,
      1.132340,
      2.584382,
      0.440576,
      NULL,
      NULL,
      4,
      3.335051,
      3,
      1.211596,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.999934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512768,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.217930,
      NULL,
      NULL,
      3.274237,
      NULL,
      NULL,
      0.119469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.656673,
      NULL,
      0,
      1.392094,
      0.603343,
      NULL,
      2.284523,
      NULL,
      NULL,
      NULL,
      2.863177,
      1.858923,
      2.223859,
      1,
      0.780269,
      2,
      NULL,
      0.203296,
      3.699976,
      NULL,
      2,
      5,
      2.335346,
      0,
      NULL,
      1,
      3,
      0.744006,
      0,
      1.700001,
      1.453047,
      1.223803,
      3.868407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698587,
      NULL,
      NULL,
      0.057239,
      NULL,
      NULL,
      1.265006,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.936087,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873719,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.346256,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.689286,
      NULL,
      NULL,
      NULL,
      0.943025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525128,
      NULL,
      NULL,
      NULL,
      3.110730,
      NULL,
      NULL,
      NULL,
      1.094912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478070,
      NULL,
      NULL,
      NULL,
      0.157589,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.167492,
      1.139437,
      NULL,
      0.026328,
      NULL,
      NULL,
      1.142933,
      NULL,
      NULL,
      0.520471,
      NULL,
      NULL,
      1.890049,
      NULL,
      NULL,
      0.770754,
      NULL,
      NULL,
      1.635900,
      NULL,
      0.592734,
      208.810306,
      1.582728,
      0,
      0.983911,
      0,
      0,
      0,
      0.259559,
      1.452952,
      1,
      0,
      1,
      1.722640,
      1,
      0,
      0,
      0.944356,
      NULL,
      1.473923,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357033,
      1.882920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437453,
      1.990719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.054813,
      1.903364,
      NULL,
      2.984231,
      NULL,
      93.847660,
      NULL,
      3,
      NULL,
      3,
      NULL,
      2.755393,
      NULL,
      0.414489,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366825,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834024,
      1.086829,
      3.453516,
      NULL,
      0.473133,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.974289,
      NULL,
      NULL,
      NULL,
      19.248073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      0,
      1,
      0.088869,
      0,
      0,
      3.267140,
      NULL,
      0,
      0.588823,
      0.247034,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.618346,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1.698066,
      1,
      NULL,
      1.051740,
      1,
      NULL,
      NULL,
      1.473466,
      NULL,
      0,
      1.709079,
      NULL,
      NULL,
      0.857576,
      NULL,
      1.944971,
      0.390223,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578672,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      36,
      77,
      0,
      1,
      0,
      '43222',
      '22140',
      '',
      0,
      '',
      NULL,
      NULL,
      1.481547,
      '',
      NULL,
      '');
commit;
end;
/


