set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '2000410',
      2.995141,
      1,
      4,
      NULL,
      '0302',
      0.751654,
      1.393540,
      NULL,
      NULL,
      '10-21-1998',
      35.104024,
      NULL,
      0,
      2,
      2,
      ' 3-26-1985',
      NULL,
      3.147617,
      203.629227,
      97,
      2,
      NULL,
      '11- 6-2001',
      NULL,
      0,
      0.474326,
      3.938195,
      0.681659,
      3,
      NULL,
      3,
      1.826830,
      NULL,
      NULL,
      NULL,
      3.844198,
      5,
      10,
      NULL,
      4,
      21.648859,
      3,
      3,
      2.963934,
      NULL,
      NULL,
      NULL,
      0.870960,
      1,
      1.912371,
      1.138723,
      0,
      1,
      1,
      1.528437,
      0,
      1,
      1,
      3.648631,
      NULL,
      0,
      1,
      2,
      1,
      0,
      2,
      1,
      0,
      1,
      1,
      1,
      8.696063,
      1,
      1,
      1,
      0,
      0.213986,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.967244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      1,
      5,
      1,
      2,
      0,
      3,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      5,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      3,
      1,
      1,
      2,
      NULL,
      1.754493,
      ' 4-12-1996',
      84.865255,
      ' 5- 0-1988',
      95,
      3.049971,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.239692,
      NULL,
      0.436784,
      NULL,
      2,
      3.681432,
      NULL,
      0,
      1,
      0.043272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386309,
      3.866933,
      2.448258,
      3,
      1,
      0,
      1.669976,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.732919,
      0.002834,
      1,
      1,
      1,
      0,
      11,
      0,
      0.568172,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      3,
      2,
      NULL,
      2,
      1,
      2,
      NULL,
      1,
      NULL,
      2.442854,
      1,
      2,
      0,
      1.705104,
      2.252078,
      1.202298,
      0.621048,
      1.451859,
      NULL,
      0,
      0.558369,
      0,
      0.907241,
      1,
      1.004733,
      3,
      1.544026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      60,
      28,
      59,
      2,
      1.637649,
      3.613149,
      '10112',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.927205,
      NULL,
      '',
      '',
      2,
      30.172463,
      NULL,
      10,
      NULL,
      9,
      3,
      1.547172,
      3,
      1.590517,
      1.358393,
      1,
      1.146885,
      NULL,
      NULL,
      1.836315,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.380926,
      NULL,
      NULL,
      1.174139,
      3.287468,
      1.144961,
      0,
      2.471555,
      0.049206,
      1.022038,
      NULL,
      NULL,
      0.352174,
      NULL,
      NULL,
      3,
      NULL,
      0.209093,
      NULL,
      0.757086,
      0.272249,
      NULL,
      NULL,
      NULL,
      NULL,
      3.217995,
      NULL,
      1,
      0.882957,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.438439,
      1,
      0.122100,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.993400,
      0.184632,
      1,
      1,
      1.044812,
      1.021095,
      0.906476,
      1.098000,
      0,
      NULL,
      1,
      1,
      1,
      1.339021,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.767689,
      NULL,
      1.959870,
      NULL,
      0,
      0.153235,
      0.639171,
      NULL,
      NULL,
      7.200082,
      0.423162,
      0,
      2.346670,
      3.925155,
      0,
      0.648337,
      NULL,
      NULL,
      5,
      2,
      0,
      0.814329,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039033,
      NULL,
      NULL,
      0.976990,
      NULL,
      NULL,
      0.560639,
      NULL,
      NULL,
      1,
      NULL,
      2.061894,
      3,
      2.009647,
      1.215237,
      5,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0.317896,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.116252,
      2.330036,
      0,
      NULL,
      2,
      1.921954,
      5.408105,
      4.371727,
      1,
      1.910942,
      3.646633,
      0,
      3,
      2,
      1.099204,
      3.794145,
      3,
      1.381415,
      3.725460,
      0,
      1.305360,
      3,
      6.178976,
      5,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      0.912417,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.522863,
      NULL,
      NULL,
      0.162531,
      NULL,
      NULL,
      0.205421,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      0.067411,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.541674,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442219,
      4,
      0.695230,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.197774,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.651999,
      NULL,
      NULL,
      NULL,
      1.080104,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0.924413,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1.572194,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.618721,
      0.732602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      47.103284,
      NULL,
      2,
      NULL,
      0.564162,
      NULL,
      1,
      NULL,
      0.843774,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987999,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917019,
      0.123486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.476119,
      0.565912,
      NULL,
      0.321760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.073739,
      1.369477,
      NULL,
      28,
      42,
      1.183598,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.499867,
      1,
      2.625015,
      0,
      2,
      3,
      3,
      0,
      1.111781,
      0.774163,
      NULL,
      NULL,
      1,
      NULL,
      1.304223,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.415504,
      1.745867,
      NULL,
      0.581511,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0.634097,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.132036,
      NULL,
      NULL,
      0.389477,
      2.037748,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.232509,
      NULL,
      3.934405,
      NULL,
      1.971155,
      NULL,
      0.838703,
      NULL,
      1.497701,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      14,
      0.857449,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.221539,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.652609,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.632010,
      NULL,
      3,
      NULL,
      12,
      1,
      1437,
      0.249015,
      NULL,
      0.977532,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      0.647121,
      NULL,
      NULL,
      69,
      97.170693,
      3,
      0,
      NULL,
      '44211',
      '43133',
      '',
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '');
commit;
end;
/


