set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '3303443',
      3,
      0,
      2,
      NULL,
      '2034',
      3.374921,
      1.713405,
      NULL,
      NULL,
      ' 7-27-2000',
      31.466500,
      NULL,
      NULL,
      0,
      4.763225,
      ' 5-19-1974',
      21.075898,
      NULL,
      83.169807,
      NULL,
      1,
      ' 8- 6-1987',
      ' 4-18-1989',
      ' 6-20-1998',
      NULL,
      2,
      3.012442,
      NULL,
      NULL,
      1,
      3,
      1.724830,
      NULL,
      NULL,
      NULL,
      0,
      7,
      19,
      NULL,
      1,
      NULL,
      0,
      NULL,
      5.665275,
      0.260583,
      1,
      1,
      1,
      0,
      1,
      0,
      0.170110,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0,
      0,
      5,
      1,
      1,
      0,
      NULL,
      3,
      6.854877,
      1,
      0,
      1,
      NULL,
      0.845225,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1.791405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      4,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      1,
      7,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1.630673,
      2,
      5,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      3,
      2,
      0,
      4,
      0,
      1,
      1,
      NULL,
      0,
      ' 5-18-2001',
      184.196611,
      ' 6-22-2002',
      180,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.728856,
      NULL,
      1,
      3.183247,
      2,
      2.802760,
      3.753198,
      1,
      0.137794,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.022617,
      NULL,
      2,
      2,
      3,
      2.161246,
      2.126043,
      0.854005,
      NULL,
      NULL,
      0.877067,
      3,
      0.001948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.687923,
      0,
      NULL,
      1,
      0,
      NULL,
      2,
      14,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.317274,
      2,
      0,
      NULL,
      NULL,
      2,
      3,
      2,
      0,
      0,
      NULL,
      0,
      3,
      0,
      2.141617,
      3,
      1.228636,
      1.651709,
      1,
      0.309640,
      1,
      0,
      1.705900,
      1.592686,
      0.196516,
      1.454156,
      0,
      NULL,
      1,
      NULL,
      1.636148,
      NULL,
      6.323125,
      3,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.907520,
      38,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      15.358465,
      0,
      0,
      2.592835,
      '34123',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0.148423,
      NULL,
      11.244902,
      NULL,
      1.069197,
      23,
      0,
      1.549789,
      NULL,
      0,
      2,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602237,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1.692581,
      0.137359,
      NULL,
      1.396373,
      NULL,
      NULL,
      3,
      1.464882,
      NULL,
      NULL,
      1.594860,
      1,
      NULL,
      0,
      0.624473,
      3,
      1,
      NULL,
      10,
      7,
      1.133409,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.755391,
      NULL,
      NULL,
      NULL,
      1.475398,
      0,
      0,
      2.072408,
      0,
      NULL,
      0,
      1.319186,
      1.219302,
      3,
      1.390252,
      1,
      2,
      2.255376,
      1.493772,
      NULL,
      NULL,
      1.784255,
      NULL,
      NULL,
      0.994783,
      0,
      2.977872,
      0.610805,
      1.974255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.716486,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      2.581020,
      0.712494,
      0,
      NULL,
      NULL,
      8.638466,
      4.960145,
      NULL,
      NULL,
      NULL,
      2,
      0.919306,
      NULL,
      NULL,
      3,
      2.650943,
      2,
      1,
      NULL,
      NULL,
      0.048302,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.931712,
      NULL,
      NULL,
      1.461162,
      NULL,
      NULL,
      1,
      2,
      3.996528,
      0,
      1.597655,
      3,
      6,
      3.944472,
      0,
      1.671764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.097325,
      NULL,
      NULL,
      2,
      1.495390,
      1.267603,
      2,
      2,
      0,
      1,
      NULL,
      0.200748,
      NULL,
      1.120304,
      3,
      NULL,
      2,
      0.311046,
      0,
      NULL,
      1,
      1.819856,
      3.774594,
      0.583033,
      7,
      5.706579,
      NULL,
      4,
      3,
      3.031011,
      2,
      3,
      0,
      NULL,
      1,
      0,
      0.390498,
      1,
      NULL,
      NULL,
      NULL,
      0.170549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253881,
      NULL,
      NULL,
      1.023106,
      NULL,
      NULL,
      0.413159,
      NULL,
      NULL,
      0.397237,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.497772,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284472,
      1,
      1.313444,
      NULL,
      1.141330,
      NULL,
      NULL,
      3.012673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249848,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.922042,
      NULL,
      NULL,
      NULL,
      1.515648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.882386,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.772064,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.307021,
      NULL,
      NULL,
      NULL,
      0.594669,
      NULL,
      NULL,
      NULL,
      1.466402,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.023096,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876425,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527178,
      408,
      NULL,
      NULL,
      0.769165,
      0,
      0.867959,
      1,
      1,
      1.352194,
      1.340164,
      1.823792,
      NULL,
      0,
      1.296689,
      NULL,
      1.072877,
      NULL,
      0.864759,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.040368,
      NULL,
      1.164612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.619008,
      0.190581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795700,
      1,
      NULL,
      NULL,
      NULL,
      1.500340,
      NULL,
      13.134082,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.754933,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286583,
      1.512514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.306642,
      NULL,
      3.405936,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.905499,
      NULL,
      0,
      NULL,
      0.481097,
      1.894158,
      2.711699,
      1,
      8.178920,
      1.504437,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      2,
      0,
      0,
      1,
      4.169125,
      0.631218,
      NULL,
      NULL,
      1,
      0.430108,
      NULL,
      0,
      NULL,
      NULL,
      0.565356,
      0.338616,
      NULL,
      0.973302,
      NULL,
      NULL,
      3.783565,
      3.687362,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.357062,
      NULL,
      1.935365,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.841568,
      0,
      NULL,
      NULL,
      1.959231,
      NULL,
      1,
      0.186026,
      2.824356,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.115759,
      NULL,
      0.806476,
      NULL,
      3,
      NULL,
      0.014243,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.395981,
      NULL,
      0.671640,
      NULL,
      0.853035,
      NULL,
      1.570406,
      NULL,
      18,
      0.572268,
      NULL,
      2.154914,
      3.046869,
      NULL,
      1,
      NULL,
      1.233216,
      NULL,
      0,
      NULL,
      0.980367,
      NULL,
      3.837035,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3.691677,
      NULL,
      3,
      NULL,
      14,
      1.401682,
      NULL,
      1.555562,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      69,
      142,
      3,
      1.010093,
      0.274776,
      '34140',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


