set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      4.745030,
      NULL,
      1,
      1,
      '3021',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      37.331367,
      NULL,
      5,
      1,
      NULL,
      NULL,
      55.225034,
      0.168837,
      131.111229,
      NULL,
      3,
      ' 6-20-2000',
      ' 6-28-1996',
      ' 6-27-1997',
      1,
      3.465159,
      1,
      0.503617,
      1,
      0,
      NULL,
      0.162681,
      NULL,
      3.778527,
      6,
      17.186470,
      7.265012,
      23.148409,
      20.572587,
      0,
      0,
      5,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      2.493095,
      5,
      1,
      1,
      1,
      1,
      NULL,
      4,
      1,
      3,
      2,
      1,
      5,
      10.771966,
      1,
      2,
      1,
      1,
      1.867023,
      NULL,
      NULL,
      1.910960,
      NULL,
      NULL,
      2,
      1,
      7,
      1,
      1.753542,
      NULL,
      0.069830,
      1.508800,
      0.261575,
      3.891098,
      1.644102,
      1.293559,
      3.085619,
      2.219897,
      0.016382,
      2,
      0,
      0.661167,
      NULL,
      0,
      2,
      0,
      8,
      0,
      0,
      5,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.024576,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      0,
      0,
      5,
      1,
      1,
      0,
      2,
      NULL,
      2,
      1,
      0,
      1,
      2,
      1,
      1,
      1,
      1.105910,
      0.522413,
      ' 0-14-1997',
      284,
      ' 4- 2-1997',
      149,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.523000,
      0.432111,
      0.257408,
      NULL,
      4.062711,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.800508,
      1.235323,
      NULL,
      0.256073,
      NULL,
      NULL,
      NULL,
      0,
      0.109150,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935005,
      0,
      0.108247,
      NULL,
      0.607874,
      1.939467,
      1.499984,
      NULL,
      NULL,
      1,
      1.961329,
      NULL,
      NULL,
      NULL,
      0,
      0.898158,
      2,
      1,
      1,
      NULL,
      3,
      1,
      3,
      2,
      0,
      3,
      0,
      NULL,
      3,
      NULL,
      1.262084,
      NULL,
      0,
      0,
      3.151838,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      4.026995,
      1,
      NULL,
      4,
      0.308518,
      10.580314,
      1.383224,
      NULL,
      NULL,
      NULL,
      6.155823,
      0,
      2,
      2.614473,
      17,
      3,
      2.375550,
      NULL,
      NULL,
      13,
      NULL,
      3,
      1,
      0,
      '00031',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.778484,
      NULL,
      '',
      '',
      1,
      42,
      28.301599,
      5.472015,
      0.075409,
      24.632201,
      2,
      3.810987,
      1,
      1,
      1.459320,
      1,
      NULL,
      1.643735,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.238637,
      2.739640,
      1.113271,
      0,
      3,
      NULL,
      0.482086,
      NULL,
      NULL,
      1,
      0,
      0,
      0.302171,
      NULL,
      0,
      0.097070,
      1,
      1,
      0.228512,
      0,
      NULL,
      8.428093,
      1,
      4,
      1,
      0.827160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      3.027880,
      0,
      3.875555,
      0.277231,
      0,
      1.491469,
      0.219742,
      0,
      0.635378,
      NULL,
      0,
      NULL,
      0,
      0.033407,
      2,
      3,
      0,
      0,
      1,
      1,
      1,
      0.678682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415544,
      1.330188,
      0.077113,
      6,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.694450,
      NULL,
      NULL,
      NULL,
      0.971461,
      NULL,
      NULL,
      2.341195,
      3.226214,
      0.305612,
      2,
      NULL,
      0.755558,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0.046278,
      NULL,
      NULL,
      0.666909,
      3,
      2.171811,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.406974,
      NULL,
      NULL,
      0.120389,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0.580089,
      3.657890,
      1,
      0.570845,
      3,
      0,
      NULL,
      NULL,
      1.455685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789862,
      0,
      1,
      0.536866,
      2.234062,
      NULL,
      NULL,
      0,
      4.746634,
      0,
      1,
      1,
      2.433542,
      2.697143,
      1.222004,
      0,
      0.529806,
      0,
      1,
      2.450465,
      0,
      2.873086,
      4.733911,
      3.137686,
      4,
      NULL,
      2,
      NULL,
      3,
      0,
      1.346640,
      1.459888,
      1.640247,
      0.405440,
      0.393247,
      1.921108,
      NULL,
      NULL,
      1.134218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.910732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193622,
      0,
      1,
      0,
      NULL,
      2.677517,
      0.854026,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.258152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019080,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105573,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.855858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      7,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.143728,
      NULL,
      0,
      300,
      1,
      0.456445,
      0,
      0.978522,
      0,
      0.343214,
      1.590462,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      0.335005,
      1,
      1.446682,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.448733,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564880,
      0.355633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.929554,
      NULL,
      3,
      NULL,
      2.417302,
      NULL,
      46,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.225114,
      NULL,
      3,
      1,
      0.776442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028524,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678360,
      NULL,
      NULL,
      0.576918,
      NULL,
      1.292693,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.202410,
      NULL,
      1,
      0.388392,
      0,
      NULL,
      49.648011,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.581029,
      2.134759,
      0.865854,
      NULL,
      0,
      3.588973,
      1,
      2,
      1,
      0,
      0.352759,
      NULL,
      0,
      1,
      NULL,
      0,
      1.268113,
      NULL,
      1.664309,
      1.136264,
      NULL,
      NULL,
      3.526808,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651106,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.015504,
      0.711289,
      NULL,
      NULL,
      NULL,
      0.478458,
      NULL,
      1.610150,
      NULL,
      0,
      NULL,
      1.558544,
      NULL,
      0,
      NULL,
      1.592059,
      NULL,
      0.596838,
      NULL,
      0,
      NULL,
      1.373509,
      NULL,
      0,
      NULL,
      3.907076,
      NULL,
      15.720448,
      1.794110,
      1493.015831,
      3.927201,
      3,
      NULL,
      0.177686,
      NULL,
      1.128630,
      NULL,
      0,
      NULL,
      0.679050,
      NULL,
      0.541334,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.221357,
      NULL,
      NULL,
      NULL,
      3.333711,
      NULL,
      1.520741,
      NULL,
      25,
      0,
      216.896110,
      0,
      NULL,
      1.230123,
      NULL,
      0.237924,
      NULL,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      72.683766,
      65,
      4,
      1,
      5,
      NULL,
      '02102',
      '',
      1.055645,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


