set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8428962';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '1012020',
      0.822999,
      1.141959,
      3,
      0,
      '4323',
      2.051334,
      0.360553,
      NULL,
      NULL,
      '11-29-1998',
      73.456144,
      NULL,
      0,
      3.483375,
      1.445619,
      NULL,
      13,
      0,
      NULL,
      55.536744,
      2,
      '11-22-1985',
      ' 0- 6-1978',
      ' 4-20-1998',
      2,
      3,
      NULL,
      0,
      1.346039,
      0.531458,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      15.542743,
      NULL,
      NULL,
      5,
      2,
      3.118591,
      1,
      0,
      1,
      1.108092,
      0,
      NULL,
      1,
      1.951507,
      1,
      0,
      1.898683,
      5,
      NULL,
      NULL,
      3.117833,
      3,
      1,
      0,
      NULL,
      0,
      0,
      4,
      1,
      4,
      1,
      1,
      NULL,
      1.850855,
      0,
      NULL,
      2,
      NULL,
      1.205697,
      NULL,
      NULL,
      0.601990,
      NULL,
      NULL,
      2,
      0,
      0.532107,
      1.001710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      4,
      3,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      3,
      0,
      2,
      NULL,
      0,
      NULL,
      3,
      5,
      0,
      5,
      3,
      0,
      5,
      1,
      3,
      4,
      NULL,
      4,
      3,
      NULL,
      0,
      NULL,
      2.510299,
      NULL,
      ' 2-16-2002',
      937.806713,
      ' 2-24-1979',
      681.171606,
      2.609503,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      8.704907,
      6,
      1.003736,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.842038,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.101973,
      0.673934,
      0,
      3,
      1,
      0,
      1,
      1.481923,
      60,
      1.064844,
      0.999982,
      138,
      505.344215,
      64.133011,
      2,
      1.207525,
      1,
      3,
      1,
      2,
      0,
      3,
      0,
      0,
      3,
      0,
      0,
      4,
      2,
      NULL,
      NULL,
      1.951237,
      0,
      NULL,
      3.581631,
      NULL,
      NULL,
      NULL,
      0.596564,
      1,
      0,
      1,
      1,
      0.922610,
      5,
      NULL,
      NULL,
      7.089815,
      NULL,
      0,
      1.054934,
      0,
      3,
      0.166828,
      NULL,
      NULL,
      0,
      2.902312,
      65.709266,
      3,
      2,
      NULL,
      NULL,
      17,
      5.037995,
      2,
      1.936728,
      4.167683,
      '21301',
      '11410',
      '',
      NULL,
      '',
      '',
      NULL,
      1.145530,
      '34221',
      '',
      '',
      1.362882,
      29.945730,
      88,
      NULL,
      3.002425,
      14,
      4,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.966947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.781860,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      1.941397,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647488,
      1.350952,
      NULL,
      1.932736,
      NULL,
      NULL,
      0.563840,
      NULL,
      NULL,
      1.425368,
      NULL,
      NULL,
      5.093553,
      3,
      3,
      1,
      1.008556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.661382,
      0.386121,
      1.700704,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0.120717,
      3,
      1.921567,
      0,
      0,
      0,
      0.158017,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.147253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862631,
      1,
      0.123915,
      1,
      NULL,
      NULL,
      6.092279,
      2,
      1.544858,
      2.754758,
      0.655221,
      0,
      0,
      NULL,
      NULL,
      2.999585,
      NULL,
      5.403546,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      0,
      8,
      2.101463,
      NULL,
      NULL,
      6,
      3,
      NULL,
      3,
      2,
      1,
      0.374600,
      3,
      NULL,
      NULL,
      2,
      NULL,
      3.273364,
      0,
      9,
      2,
      3,
      0.459597,
      NULL,
      3,
      3,
      2.369621,
      1.172966,
      0.295872,
      2.798346,
      3.173544,
      2,
      0.999345,
      2,
      NULL,
      NULL,
      9.374009,
      6,
      3.788981,
      1.932878,
      1,
      1,
      3,
      1,
      1.441157,
      1.420183,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.605209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698117,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.652294,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.606083,
      1.468280,
      0.947406,
      0,
      1,
      1,
      NULL,
      NULL,
      2.608904,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.570215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494281,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637832,
      NULL,
      NULL,
      NULL,
      1.696798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.753338,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.094433,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      0,
      87.981082,
      103,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421744,
      NULL,
      0,
      7.822595,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064929,
      50,
      5,
      1.319135,
      1.772866,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.916868,
      0,
      0,
      1,
      0,
      NULL,
      0.462716,
      0,
      0.714623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.159136,
      1.315761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892439,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.061694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.194721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.011878,
      NULL,
      0,
      NULL,
      954.395598,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.639908,
      0.298332,
      5.805360,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.798386,
      0.467610,
      0.517999,
      3.322289,
      NULL,
      12.115947,
      NULL,
      0.607425,
      1.498163,
      1.622889,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.510167,
      NULL,
      1.805371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446632,
      0,
      NULL,
      2.807612,
      1,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      1.557672,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.525671,
      NULL,
      1,
      5,
      NULL,
      0.422854,
      1,
      NULL,
      32,
      72.269451,
      2,
      1,
      3,
      '04210',
      '02024',
      '',
      0,
      '',
      NULL,
      '',
      0.081470,
      NULL,
      '',
      '');
commit;
end;
/


