set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6414991';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      '44',
      24,
      NULL,
      '3224130',
      2.654279,
      NULL,
      1,
      3,
      '0142',
      1,
      1,
      NULL,
      NULL,
      NULL,
      15.338015,
      48.353697,
      NULL,
      1,
      NULL,
      '11- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410320,
      3,
      1.729256,
      NULL,
      1,
      3,
      2.948554,
      NULL,
      NULL,
      NULL,
      7.938393,
      6.599531,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.331211,
      1.253246,
      1,
      1,
      3,
      1,
      1,
      NULL,
      0,
      0,
      1,
      3,
      2,
      0.558057,
      2,
      0,
      1.870176,
      1,
      1,
      NULL,
      0,
      1,
      0.596311,
      0.216300,
      1.104903,
      1,
      1,
      1,
      1.269762,
      2.493576,
      1.882957,
      6,
      6,
      0,
      1.709336,
      3.896263,
      1,
      5.943769,
      3.032696,
      5.656533,
      NULL,
      NULL,
      3.187701,
      52,
      2,
      NULL,
      31,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      '',
      '',
      '',
      NULL,
      '01411',
      '2121',
      '',
      0,
      '20002',
      '',
      '',
      NULL,
      41,
      1.250392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304437,
      NULL,
      NULL,
      0.503926,
      NULL,
      NULL,
      1.636303,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.622054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0.719343,
      1,
      1.445719,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0.870344,
      2,
      0,
      1.213089,
      1.286189,
      1.344685,
      0,
      2.863902,
      NULL,
      2,
      NULL,
      3.666102,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.726323,
      NULL,
      2,
      5,
      9,
      1.786605,
      0.258939,
      NULL,
      NULL,
      0,
      NULL,
      1.579403,
      NULL,
      0.644536,
      NULL,
      0,
      NULL,
      0.113570,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166005,
      NULL,
      1.885529,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      8,
      2.780176,
      1.430301,
      2.116157,
      0,
      12,
      2.826737,
      1.799673,
      1.898090,
      NULL,
      NULL,
      NULL,
      0.471172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.410778,
      NULL,
      NULL,
      3.455826,
      1.181714,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079995,
      NULL,
      1,
      5,
      3,
      0,
      NULL,
      0,
      15.134423,
      68,
      5,
      4.613360,
      3.933440,
      NULL,
      '',
      '',
      0.417089,
      NULL,
      NULL,
      NULL,
      6.956729,
      '31330',
      '02121',
      '04222');
commit;
end;
/


