set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9639067';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42',
      25,
      NULL,
      NULL,
      3.512757,
      1.862060,
      0,
      0,
      '2432',
      4.286422,
      1,
      NULL,
      NULL,
      ' 7-15-1985',
      0.472860,
      3.064659,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 5- 7-1982',
      3.274813,
      0,
      0,
      3.805094,
      1,
      3,
      5,
      3,
      NULL,
      NULL,
      NULL,
      3.075838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.783193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      1,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      4,
      5,
      0,
      NULL,
      1,
      4.880633,
      0,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      1.410615,
      NULL,
      NULL,
      3,
      3,
      1.954065,
      1,
      2,
      1,
      2,
      1,
      NULL,
      1,
      3,
      1.328456,
      3.890757,
      NULL,
      NULL,
      2.982203,
      3.029788,
      NULL,
      1,
      NULL,
      0,
      3,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0,
      1,
      2,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      5,
      0,
      2,
      2,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3,
      ' 7-13-1994',
      9.704145,
      ' 9- 3-1986',
      6,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.795089,
      NULL,
      2,
      2.897514,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.773808,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      0.755802,
      NULL,
      0.067882,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      1.366747,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045882,
      1.931695,
      NULL,
      1,
      0,
      0.130885,
      0,
      NULL,
      8.288415,
      0.900369,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      2,
      NULL,
      NULL,
      3,
      1,
      2,
      3,
      3,
      2.958641,
      3.527865,
      3,
      0,
      0,
      1.985950,
      2,
      0.516909,
      1,
      1.055665,
      1.574244,
      1.375574,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.490196,
      3.762021,
      NULL,
      2.359143,
      7,
      2.744771,
      0.540061,
      3,
      0.239954,
      1,
      3,
      0,
      NULL,
      37.761426,
      1,
      1.928972,
      38,
      NULL,
      39,
      82,
      0,
      1,
      NULL,
      '44343',
      '41340',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.977422,
      29.709530,
      199.664249,
      26.655982,
      0.038350,
      25.135951,
      3,
      NULL,
      NULL,
      2,
      2,
      0,
      1.878097,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.474415,
      NULL,
      NULL,
      0,
      NULL,
      0.494403,
      1.688145,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.533459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756992,
      NULL,
      NULL,
      5,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695602,
      1,
      3.911361,
      0,
      0,
      0.049587,
      NULL,
      NULL,
      0.422570,
      0.708771,
      NULL,
      3.086845,
      1.379406,
      0,
      2.290194,
      3.921021,
      1.663327,
      2.314368,
      3.902251,
      NULL,
      1,
      1.545517,
      0,
      1,
      0,
      NULL,
      NULL,
      0.539791,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.565223,
      0.760920,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.598875,
      NULL,
      NULL,
      NULL,
      0.053437,
      NULL,
      NULL,
      2.143454,
      2,
      1,
      1.398190,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155109,
      3.653898,
      1.366407,
      1,
      NULL,
      NULL,
      4,
      NULL,
      0.020370,
      0.240661,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.865558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883593,
      NULL,
      NULL,
      0.414060,
      1.898210,
      0.190203,
      0,
      NULL,
      NULL,
      6.132739,
      4,
      NULL,
      5,
      4,
      0.936486,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.150576,
      3.757614,
      0,
      NULL,
      NULL,
      7,
      5,
      NULL,
      1.545886,
      NULL,
      NULL,
      0.683102,
      NULL,
      NULL,
      3.531771,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      5,
      0,
      0,
      NULL,
      1,
      NULL,
      1.279465,
      0,
      1,
      0.517992,
      1.229403,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.777709,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.574953,
      NULL,
      NULL,
      0.075285,
      NULL,
      NULL,
      3.825533,
      NULL,
      NULL,
      0.089436,
      0,
      1.229147,
      0,
      1.453432,
      3,
      0,
      NULL,
      NULL,
      2.064014,
      3.302791,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.879692,
      1.400505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990231,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.930438,
      1.547351,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      1.837526,
      NULL,
      NULL,
      3.113732,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0.288597,
      NULL,
      NULL,
      NULL,
      2,
      23,
      1507.758187,
      0.496468,
      21.184853,
      667,
      1,
      NULL,
      NULL,
      3.305987,
      4.003866,
      NULL,
      1.103549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.344689,
      0,
      1,
      0,
      0.556067,
      NULL,
      NULL,
      1,
      1.996975,
      NULL,
      2.196046,
      1.316485,
      NULL,
      NULL,
      0,
      NULL,
      0.130303,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      92.151827,
      NULL,
      3,
      37,
      43.785286,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.732933,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.818580,
      NULL,
      3.373512,
      NULL,
      NULL,
      NULL,
      1.597438,
      NULL,
      1.618821,
      NULL,
      1,
      NULL,
      1.095471,
      NULL,
      0.294203,
      NULL,
      1,
      0.041785,
      0.927208,
      3.772407,
      NULL,
      0.530770,
      NULL,
      1.562659,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.955092,
      NULL,
      0.856045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.171727,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.106078,
      NULL,
      0.043662,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.973494,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298747,
      0.793815,
      0.625466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.032193,
      NULL,
      0.851788,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.658575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      11,
      3.727538,
      1.323165,
      0,
      NULL,
      9.727151,
      2.308861,
      0.554675,
      1,
      0,
      0.338469,
      0,
      0.768979,
      1.271286,
      2,
      0,
      0.477529,
      1,
      1.835722,
      1.122772,
      1.336237,
      0.737199,
      2.284347,
      3.846752,
      1.449752,
      NULL,
      1.722256,
      1.543462,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.823392,
      0.038158,
      1,
      NULL,
      0,
      0.584762,
      0,
      NULL,
      0,
      1.222984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223987,
      0,
      0,
      NULL,
      NULL,
      1,
      2,
      3,
      6,
      0,
      NULL,
      NULL,
      43,
      64,
      0,
      2.103023,
      0,
      '21043',
      '32114',
      '',
      0,
      '',
      '',
      NULL,
      0.822061,
      '',
      NULL,
      '');
commit;
end;
/


