set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1102223',
      NULL,
      0,
      1,
      3,
      '1001',
      2,
      0,
      NULL,
      NULL,
      ' 5- 6-1996',
      5,
      NULL,
      3,
      3.980544,
      0,
      ' 6-24-1986',
      21.301441,
      NULL,
      72,
      82.715958,
      3,
      ' 6-14-1993',
      ' 4-25-1974',
      ' 6-20-1992',
      NULL,
      0,
      2.336615,
      0,
      1,
      NULL,
      NULL,
      0.076351,
      0.262177,
      135,
      5,
      NULL,
      0.115713,
      NULL,
      26.306600,
      1,
      1.691474,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      1,
      NULL,
      2,
      1,
      4,
      2,
      1,
      4,
      NULL,
      4,
      0,
      NULL,
      1,
      0,
      2,
      1,
      1.948932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.053251,
      2,
      1,
      1,
      3.813088,
      2.802027,
      2.687957,
      2,
      1.680505,
      1.290108,
      3.450084,
      3,
      NULL,
      1.040922,
      3,
      NULL,
      1.543770,
      5,
      0,
      5,
      NULL,
      0,
      1,
      4.246070,
      NULL,
      NULL,
      NULL,
      1.133303,
      NULL,
      NULL,
      NULL,
      4,
      5,
      4,
      4,
      4,
      4,
      0,
      5,
      5,
      1,
      5,
      0,
      8.464118,
      1,
      NULL,
      1,
      NULL,
      3.824809,
      1,
      NULL,
      0,
      0,
      1,
      3,
      0,
      4,
      2,
      5,
      1,
      2,
      5,
      1,
      5,
      1,
      NULL,
      0,
      3,
      0,
      4,
      1,
      5,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      ' 3-20-1982',
      271.229701,
      '10-11-1978',
      NULL,
      0.277350,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      3,
      1,
      1,
      0,
      1.334430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.567474,
      6.741424,
      7.117245,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.227859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.468761,
      0.651822,
      0.466778,
      0.982471,
      NULL,
      11.499018,
      0.826798,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.687688,
      3,
      2,
      NULL,
      1,
      2,
      0,
      NULL,
      1,
      3,
      0,
      3,
      0,
      0,
      3.700788,
      5,
      0,
      0.779181,
      0.942529,
      1,
      0,
      0.227628,
      1,
      NULL,
      0.816591,
      1.200040,
      0.564608,
      1,
      NULL,
      3.681369,
      0.996499,
      8,
      11.589191,
      7.783857,
      0.558030,
      5,
      3.907465,
      5,
      3.212309,
      4,
      NULL,
      1.938581,
      NULL,
      30,
      0,
      3,
      NULL,
      14,
      NULL,
      22.874174,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.448973,
      '',
      '',
      '',
      0.868756,
      '',
      '',
      '',
      3,
      51,
      174,
      16,
      3.819246,
      29.452913,
      3,
      1,
      2,
      2,
      NULL,
      2,
      NULL,
      3.970123,
      1,
      0.506423,
      2.554071,
      1.093899,
      1,
      1.438572,
      1,
      NULL,
      NULL,
      2,
      2,
      3.393572,
      NULL,
      2.511237,
      NULL,
      0.268621,
      NULL,
      NULL,
      NULL,
      3.532631,
      3.071818,
      1,
      3.391046,
      NULL,
      0,
      NULL,
      3.651740,
      0,
      3,
      NULL,
      0,
      9.793241,
      5,
      1,
      NULL,
      0.496117,
      NULL,
      NULL,
      NULL,
      0.809512,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.049877,
      1.880154,
      1,
      NULL,
      1.432047,
      0.457400,
      NULL,
      NULL,
      2.024834,
      3.299984,
      1.097216,
      2.818813,
      0,
      NULL,
      1,
      1.337040,
      0.948606,
      3,
      0.554158,
      1.127000,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      3.720645,
      0,
      1,
      8.442979,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.089284,
      0.346234,
      0,
      1,
      1.831561,
      3.447382,
      3.505450,
      NULL,
      NULL,
      0.235510,
      0.169702,
      0.417440,
      1,
      NULL,
      3.596082,
      1.699260,
      3,
      NULL,
      NULL,
      NULL,
      8.557382,
      5.148621,
      0.240267,
      NULL,
      NULL,
      1.600408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773799,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.940872,
      1.407242,
      2,
      NULL,
      NULL,
      NULL,
      4.257316,
      1,
      2.107011,
      7,
      3.184270,
      NULL,
      NULL,
      NULL,
      NULL,
      3.850825,
      3.534666,
      2.427365,
      0.862655,
      NULL,
      NULL,
      1.714544,
      NULL,
      NULL,
      3.798443,
      NULL,
      NULL,
      1.157356,
      NULL,
      NULL,
      1.102440,
      NULL,
      NULL,
      0,
      NULL,
      1.288246,
      NULL,
      1,
      0,
      0,
      1.328900,
      4,
      2.412641,
      5.368268,
      0.498566,
      2,
      3,
      0,
      0.277255,
      1,
      1,
      0,
      1,
      2,
      NULL,
      NULL,
      1.936104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780048,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.939862,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.479535,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.820200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.320931,
      0.168577,
      NULL,
      NULL,
      1.384347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.779286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.124742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690693,
      2.285807,
      1.500538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.344089,
      NULL,
      NULL,
      0.898052,
      NULL,
      NULL,
      0.066963,
      NULL,
      1.734162,
      979.849308,
      0,
      1,
      1.484352,
      0.334136,
      NULL,
      1,
      1.442840,
      1.624967,
      2.365153,
      NULL,
      0,
      0,
      0.785408,
      0,
      1.401159,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.780498,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315157,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853165,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990588,
      1.777535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.941215,
      NULL,
      NULL,
      NULL,
      1.383509,
      NULL,
      0,
      NULL,
      1,
      0.706015,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      2,
      0,
      2.932970,
      1,
      15,
      0.597909,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.880134,
      NULL,
      NULL,
      1.399107,
      2,
      NULL,
      2.804769,
      2.087952,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2,
      NULL,
      2.804808,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2.313587,
      2.435728,
      NULL,
      0.129776,
      0,
      NULL,
      NULL,
      1.314687,
      NULL,
      0.517561,
      NULL,
      0.421811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.595629,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      2,
      3,
      0.462578,
      22,
      NULL,
      4,
      0,
      3,
      '04443',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


