set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.434410,
      3,
      1,
      3.475528,
      3,
      0.733829,
      3,
      '013',
      NULL,
      16,
      NULL,
      '1344104',
      1.936253,
      1.487863,
      1,
      2,
      NULL,
      NULL,
      0.265737,
      NULL,
      NULL,
      ' 7-10-2001',
      31.824499,
      26,
      NULL,
      NULL,
      1.144907,
      ' 7- 1-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-23-1977',
      NULL,
      '11-25-1990',
      NULL,
      NULL,
      1.614759,
      0,
      0,
      2.063926,
      0,
      0,
      1.638782,
      232,
      3,
      12,
      3.571691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.660128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      3.929590,
      3,
      NULL,
      0,
      NULL,
      5,
      2,
      0,
      0,
      0,
      2,
      NULL,
      1,
      7,
      1,
      NULL,
      2,
      0,
      1.867584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.356385,
      0.262523,
      1,
      2.000709,
      1,
      1.563394,
      3,
      1,
      1.816598,
      1,
      NULL,
      1.394112,
      2.720527,
      NULL,
      NULL,
      3.203003,
      0,
      0,
      4,
      9,
      1,
      NULL,
      1.966896,
      0.130748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      7,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1.442014,
      3,
      0,
      5,
      3,
      0,
      3,
      2,
      NULL,
      NULL,
      0,
      1,
      1,
      5,
      0,
      1,
      4,
      2,
      4,
      4,
      2,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      ' 3-27-1989',
      324.948626,
      NULL,
      853,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      1.163607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768477,
      0,
      0.971877,
      NULL,
      0.167028,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.805697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994733,
      0,
      0,
      1.462927,
      0,
      1.548941,
      0.637845,
      3,
      11,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.305302,
      1,
      NULL,
      NULL,
      0,
      1.807868,
      8,
      1.455780,
      1,
      0,
      1,
      0.714819,
      1,
      NULL,
      1,
      0,
      0,
      2,
      NULL,
      0.185318,
      8.875781,
      6.028390,
      9,
      11.426657,
      1,
      NULL,
      2,
      5.558211,
      2.726331,
      0,
      0,
      56,
      NULL,
      2.134819,
      52,
      NULL,
      21,
      37,
      3,
      3.870263,
      2.779519,
      '00412',
      '',
      '',
      0.321763,
      NULL,
      NULL,
      '',
      1.552156,
      NULL,
      '',
      '',
      3,
      50.627002,
      189,
      NULL,
      0.395617,
      12,
      3,
      4.999468,
      1,
      0.124368,
      1,
      3.326817,
      NULL,
      2,
      NULL,
      3.349859,
      0,
      0,
      2.317564,
      0,
      0.718448,
      0.878310,
      3.618141,
      2,
      1.471976,
      3.305388,
      3.740887,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.633237,
      2,
      NULL,
      0.329452,
      3.016693,
      3.253533,
      3,
      2.880500,
      2.594971,
      0,
      3,
      3.992992,
      NULL,
      1.379838,
      NULL,
      NULL,
      NULL,
      1.352693,
      NULL,
      NULL,
      NULL,
      1,
      3.271672,
      0.232190,
      2,
      1,
      0,
      1,
      NULL,
      1,
      3.600791,
      0,
      NULL,
      0,
      NULL,
      0.157516,
      2,
      1,
      1,
      1,
      NULL,
      0.394164,
      3,
      2.128053,
      2,
      0,
      3,
      3.892766,
      2.708476,
      0.616348,
      1,
      0.931995,
      NULL,
      0,
      3,
      7,
      NULL,
      6,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.892544,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      2,
      1.968584,
      3,
      2,
      0,
      NULL,
      5.606981,
      0,
      1,
      2.354312,
      2,
      0.051097,
      NULL,
      1.502031,
      1,
      4.378506,
      6.105534,
      1.501378,
      NULL,
      NULL,
      0.135016,
      NULL,
      NULL,
      1.433948,
      NULL,
      NULL,
      0.166898,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.317732,
      0,
      0.337844,
      0.504167,
      NULL,
      NULL,
      2.131965,
      0.115118,
      5,
      1.553503,
      1.571899,
      NULL,
      0.758984,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.938266,
      1,
      NULL,
      1.618598,
      NULL,
      NULL,
      NULL,
      0,
      1.152451,
      2,
      0,
      0,
      NULL,
      0.529894,
      1,
      1.315186,
      NULL,
      0,
      2,
      NULL,
      1.655729,
      7.055723,
      6.211889,
      6.099222,
      1.207101,
      NULL,
      3,
      2,
      2,
      4,
      0.401539,
      1.197955,
      0,
      0.955122,
      NULL,
      3.965612,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.121581,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.558017,
      1.287942,
      NULL,
      1.542420,
      0,
      1.089101,
      1.578648,
      NULL,
      NULL,
      1.106167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.899043,
      NULL,
      NULL,
      NULL,
      0.498537,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.641599,
      NULL,
      NULL,
      NULL,
      3,
      110,
      114,
      0.178769,
      NULL,
      NULL,
      0.472294,
      NULL,
      NULL,
      1.430338,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.250635,
      NULL,
      NULL,
      1.151925,
      NULL,
      1,
      NULL,
      1,
      1.248183,
      3,
      1.677306,
      0,
      1.990821,
      1.733702,
      1,
      2.257382,
      NULL,
      1,
      NULL,
      0,
      0.949689,
      0.972836,
      1.367964,
      0.064439,
      0.529761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895728,
      1,
      1.234282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394885,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246322,
      0.384020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.070578,
      NULL,
      0.274813,
      NULL,
      1.438423,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.569997,
      1.028161,
      1.045650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.787277,
      1.258638,
      1,
      1,
      NULL,
      9.849981,
      3,
      0,
      1,
      3.259265,
      2.806906,
      NULL,
      1.141887,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      3.222557,
      NULL,
      0.428189,
      1.679237,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.776921,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.472348,
      0,
      0.120561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      1,
      37,
      30.818978,
      1,
      4,
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


