set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027986';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '0102214',
      2,
      1,
      NULL,
      2,
      '1044',
      2,
      0,
      NULL,
      NULL,
      ' 9-12-1981',
      67,
      NULL,
      3,
      1.010181,
      0,
      '11-26-2002',
      59.650231,
      3.574189,
      147.091544,
      50,
      1,
      ' 3- 0-1976',
      ' 0-19-1996',
      ' 7-25-1997',
      NULL,
      3.610871,
      NULL,
      3.837306,
      1.675722,
      1.371203,
      2,
      0.115700,
      0.789220,
      304.872465,
      2,
      NULL,
      1.892775,
      35,
      155,
      0,
      4.626730,
      NULL,
      1,
      1.286496,
      NULL,
      2,
      0,
      1,
      0,
      1,
      1,
      0.471831,
      0,
      1.669522,
      1.607033,
      2,
      1,
      2,
      NULL,
      2,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      8.018259,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.360468,
      NULL,
      NULL,
      0,
      0,
      1,
      1.008715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1.850061,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0.554447,
      2,
      NULL,
      1,
      NULL,
      0,
      3,
      2,
      0,
      NULL,
      1,
      4,
      3,
      NULL,
      1,
      4,
      NULL,
      4,
      4,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      3.076533,
      3.872870,
      ' 7- 5-1988',
      1622,
      NULL,
      7.166238,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.773036,
      3,
      NULL,
      11,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429930,
      NULL,
      0,
      0.012776,
      1,
      0,
      0.356606,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.191989,
      0.959300,
      0,
      NULL,
      NULL,
      1,
      47.275027,
      3.576145,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.383610,
      NULL,
      1,
      0,
      1,
      0,
      1,
      2,
      2,
      NULL,
      0,
      2,
      2.559232,
      NULL,
      0.590379,
      0,
      1.107217,
      2.109681,
      1,
      0,
      1.325861,
      0.573925,
      1,
      0,
      0.570603,
      0,
      1,
      0,
      2,
      0.708462,
      NULL,
      NULL,
      5,
      NULL,
      6,
      0.569339,
      NULL,
      0.173159,
      2,
      1.202161,
      3,
      NULL,
      47.222262,
      NULL,
      0.774592,
      NULL,
      86,
      2,
      82,
      2,
      0,
      1,
      '22221',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.619025,
      '',
      NULL,
      '',
      2.319649,
      11.340277,
      44.230409,
      34,
      0.464422,
      24,
      5,
      11,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.437034,
      3,
      1,
      1,
      NULL,
      NULL,
      0.780362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      4.380512,
      1,
      1.573992,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.484938,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.617367,
      NULL,
      NULL,
      1.467497,
      NULL,
      NULL,
      0.285370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      3.529147,
      0.543133,
      0.160087,
      1.538760,
      0.902541,
      NULL,
      NULL,
      2.689744,
      8,
      2.443392,
      0,
      NULL,
      0,
      0.693229,
      NULL,
      NULL,
      2.888148,
      3.355341,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      5,
      0.953594,
      2.496197,
      1,
      3,
      0,
      NULL,
      NULL,
      3.500454,
      1,
      NULL,
      4,
      8.405176,
      4.002706,
      0.444423,
      NULL,
      NULL,
      NULL,
      1,
      1.285072,
      3,
      0,
      0.463006,
      2.732661,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      1.025407,
      NULL,
      NULL,
      0,
      0,
      NULL,
      6,
      5.843554,
      0.269076,
      1.876427,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.471264,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.127157,
      NULL,
      NULL,
      1.139390,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.765858,
      NULL,
      NULL,
      0.760357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893525,
      NULL,
      NULL,
      1.748130,
      1,
      NULL,
      NULL,
      0.267391,
      0,
      3,
      NULL,
      NULL,
      0.812803,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833750,
      0.172306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268290,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.661201,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.689895,
      1.813806,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.830535,
      NULL,
      NULL,
      NULL,
      0,
      336,
      61,
      0.594931,
      2.371650,
      1,
      1.295243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.769459,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0.652211,
      0.218587,
      1.319170,
      NULL,
      0.872658,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137176,
      1.886604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746865,
      0.807271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.546539,
      NULL,
      NULL,
      0.188082,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      6,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.422409,
      NULL,
      2,
      NULL,
      1,
      0.051238,
      1.762093,
      1.535871,
      NULL,
      NULL,
      1.690617,
      2,
      0.375721,
      1,
      0.205651,
      0.235717,
      0.925985,
      0,
      1.367855,
      0.262590,
      1.400306,
      1.128505,
      NULL,
      NULL,
      3,
      1.120106,
      1,
      1,
      1,
      1.639227,
      0.619395,
      1,
      1,
      1.719496,
      NULL,
      0,
      1.218403,
      3,
      1.073418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423976,
      1,
      0.162268,
      0,
      NULL,
      1,
      1,
      2,
      7,
      0,
      0.606491,
      2.373289,
      NULL,
      94,
      3,
      0,
      1.144893,
      '24240',
      '10401',
      '',
      1.849939,
      '',
      '',
      '',
      1.037070,
      '',
      '',
      '');
commit;
end;
/


