set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7624278';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '4244022',
      1.824394,
      1,
      3,
      0,
      NULL,
      NULL,
      3.888264,
      1,
      NULL,
      ' 4-19-1988',
      26.413725,
      NULL,
      NULL,
      0,
      0.688549,
      ' 0-20-1983',
      43.380352,
      1.262977,
      231.471964,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-19-1976',
      2.503829,
      1.759983,
      1,
      NULL,
      1,
      0.673965,
      1,
      0.044800,
      0,
      10.582180,
      7,
      13,
      0,
      18,
      19.437878,
      4,
      5.824166,
      2,
      3,
      7,
      1.068422,
      2,
      NULL,
      0.970414,
      0.511975,
      NULL,
      1,
      0.008208,
      3,
      1,
      0.940936,
      1,
      0,
      4,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      4,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      9.323759,
      0,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      0.569837,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.206392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      0,
      1,
      NULL,
      0,
      5,
      3,
      0,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      1,
      1,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      2,
      3,
      3,
      3,
      3,
      ' 0- 8-1993',
      74.386706,
      NULL,
      103.238075,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.397476,
      3,
      5.561338,
      7.071663,
      2,
      NULL,
      NULL,
      NULL,
      0.708917,
      2,
      0.072696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.116045,
      1,
      0,
      0.395869,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      2,
      1,
      NULL,
      1.431985,
      0,
      1,
      1,
      0,
      0.380090,
      1.409624,
      NULL,
      NULL,
      1.124634,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264080,
      18,
      NULL,
      NULL,
      NULL,
      4,
      1.721803,
      NULL,
      '43421',
      '43300',
      '',
      0,
      '',
      '',
      NULL,
      0.472482,
      '',
      '',
      '',
      3.940120,
      32.404780,
      3,
      4.107704,
      1.849310,
      2,
      3.355429,
      0,
      5,
      NULL,
      NULL,
      3.386481,
      1.873324,
      1,
      1,
      2.161072,
      2,
      0,
      2,
      0,
      0.953330,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.901567,
      NULL,
      NULL,
      2.608192,
      NULL,
      2.367103,
      2.925353,
      3,
      1,
      0.010140,
      1.037842,
      1,
      NULL,
      NULL,
      3.316579,
      0,
      NULL,
      NULL,
      2.467840,
      6.651640,
      1.849696,
      0,
      1.936473,
      NULL,
      NULL,
      NULL,
      1.113282,
      1,
      3.540542,
      2.577499,
      0,
      1.819491,
      1,
      3,
      3.263114,
      NULL,
      2.901890,
      1.616024,
      1.995676,
      1.897708,
      0.326467,
      NULL,
      3,
      2.386871,
      NULL,
      1.666670,
      2,
      0.102627,
      3.558613,
      0,
      3.938852,
      0.744820,
      NULL,
      1.159358,
      1.333283,
      1,
      1.972765,
      1.904104,
      1.331316,
      NULL,
      1.629703,
      0.128322,
      1,
      0,
      6.987219,
      1.782721,
      0.035174,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.983404,
      1,
      2,
      NULL,
      1,
      3.150600,
      0.479638,
      3.311746,
      2,
      1.912218,
      NULL,
      1,
      0.530711,
      0.519111,
      NULL,
      NULL,
      0,
      5.843927,
      0,
      0.814046,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.804600,
      NULL,
      NULL,
      1.675176,
      NULL,
      NULL,
      0.317173,
      NULL,
      NULL,
      0.575534,
      NULL,
      NULL,
      1.363527,
      NULL,
      NULL,
      0.275113,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      0,
      3,
      2.585930,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1.292086,
      0.385006,
      3.177951,
      8,
      NULL,
      2,
      2.747595,
      1,
      1,
      0,
      1.355451,
      1.708902,
      1.621597,
      NULL,
      NULL,
      0,
      0.691832,
      NULL,
      3.107522,
      5,
      9.789668,
      1.794955,
      0.357010,
      0,
      NULL,
      2,
      3,
      0.583496,
      0.086653,
      1,
      NULL,
      NULL,
      3.602102,
      NULL,
      NULL,
      0.444797,
      NULL,
      NULL,
      0.049455,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.508999,
      NULL,
      NULL,
      0.492673,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.558610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004043,
      NULL,
      NULL,
      5.068268,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.394148,
      2,
      3,
      NULL,
      NULL,
      0,
      0.972822,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475584,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.784098,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.842076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.259341,
      0,
      NULL,
      NULL,
      0.107752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.107212,
      0.291937,
      NULL,
      NULL,
      0.647572,
      1,
      NULL,
      NULL,
      NULL,
      0.922401,
      NULL,
      NULL,
      4.226376,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.374116,
      NULL,
      4.440679,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.433421,
      24.347768,
      NULL,
      0.293071,
      10.299253,
      NULL,
      0.782882,
      NULL,
      NULL,
      0,
      NULL,
      1.760769,
      6498,
      NULL,
      1,
      3.946309,
      0,
      2.349411,
      1,
      0,
      1.131933,
      3,
      1,
      3.160020,
      1,
      NULL,
      1.440887,
      1,
      1.436432,
      0,
      1.412489,
      0,
      NULL,
      1.252934,
      NULL,
      1.376414,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      176.286698,
      NULL,
      2,
      NULL,
      6.605504,
      3,
      1.143858,
      7.335455,
      NULL,
      2.957166,
      NULL,
      3.005919,
      NULL,
      0.890375,
      NULL,
      3,
      NULL,
      1.320551,
      NULL,
      0,
      NULL,
      0.179269,
      NULL,
      NULL,
      NULL,
      0.396830,
      NULL,
      0.167425,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1.851879,
      0.503406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.011891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420675,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823540,
      2.490477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      473,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.247173,
      NULL,
      1.322358,
      6.929709,
      NULL,
      2.889984,
      NULL,
      1.239880,
      NULL,
      1,
      2,
      0,
      NULL,
      2,
      3.525191,
      2,
      2,
      4,
      0,
      2.381745,
      1.155156,
      1,
      0.271833,
      0,
      NULL,
      2,
      0,
      0,
      1.761739,
      2.360602,
      3.557055,
      0.825929,
      0.740989,
      0,
      0.279897,
      1,
      0.319244,
      0.304914,
      1,
      1,
      1.249967,
      1,
      1,
      0.182487,
      NULL,
      1.226605,
      12,
      16,
      NULL,
      2,
      1,
      NULL,
      1.206316,
      1.168902,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572818,
      2,
      NULL,
      NULL,
      NULL,
      0.970071,
      NULL,
      1.166699,
      NULL,
      1.856081,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      90.998400,
      0.376104,
      NULL,
      0,
      1,
      0.141804,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0.827125,
      3.881789,
      15,
      81,
      4,
      0.653348,
      7,
      '21442',
      '13304',
      NULL,
      0.558496,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


