set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      1,
      2,
      4.058001,
      NULL,
      0.722876,
      1,
      3,
      '100',
      NULL,
      29.798210,
      NULL,
      NULL,
      NULL,
      1.359626,
      1,
      NULL,
      '3443',
      3,
      0.244446,
      NULL,
      NULL,
      ' 2-16-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      0.923694,
      ' 9- 1-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11-12-1978',
      ' 2-16-2001',
      ' 5- 4-1997',
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1.506631,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.983832,
      NULL,
      NULL,
      1.319466,
      0,
      0,
      1.978057,
      3.402080,
      NULL,
      1.134264,
      0.299850,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0.743842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.022376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1.239188,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      5,
      4,
      1,
      2,
      1,
      2,
      5,
      NULL,
      4,
      2,
      1,
      3,
      5,
      1,
      1,
      1,
      NULL,
      3,
      NULL,
      1,
      3,
      5,
      NULL,
      5,
      1,
      3,
      0.069085,
      ' 3-13-2000',
      NULL,
      ' 4-29-1979',
      1.484109,
      0,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      0.255783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      19,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      7,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.685154,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.875397,
      2.011041,
      1.685708,
      NULL,
      1.158159,
      1,
      0.860720,
      2.411091,
      35.838186,
      2.592003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202281,
      2,
      3,
      0,
      NULL,
      3,
      NULL,
      1,
      3,
      0,
      2,
      NULL,
      0.131041,
      NULL,
      3.455633,
      5,
      1,
      1.118932,
      2.453673,
      NULL,
      0,
      0,
      0.474343,
      1,
      1,
      0.639239,
      0.448561,
      1,
      0,
      1,
      0,
      NULL,
      9.179484,
      6,
      8,
      0.978062,
      4.719995,
      5.042800,
      NULL,
      NULL,
      0.479540,
      1.392436,
      3.895531,
      6,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      '04401',
      '',
      '',
      0.257013,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      11.468867,
      68.089549,
      30,
      1,
      NULL,
      NULL,
      2.924023,
      5,
      3.220900,
      3,
      1.890925,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.176424,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730417,
      3,
      3,
      NULL,
      2.583135,
      1,
      NULL,
      2,
      3,
      1.181535,
      1,
      NULL,
      NULL,
      0.171503,
      NULL,
      1.365305,
      3,
      NULL,
      0,
      8.423750,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940463,
      NULL,
      1.981725,
      0,
      2,
      3.182827,
      1,
      0.045607,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.183236,
      1,
      NULL,
      1.283688,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.136570,
      1.520049,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      2,
      2,
      1.960269,
      NULL,
      NULL,
      NULL,
      2,
      7.829102,
      0,
      0.563699,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.579228,
      NULL,
      NULL,
      0.040497,
      NULL,
      NULL,
      1.575070,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      1.380761,
      1.912025,
      5,
      5.266700,
      2,
      8,
      0.264447,
      NULL,
      NULL,
      2.488187,
      NULL,
      2.273086,
      NULL,
      NULL,
      1.397720,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.069897,
      1.737531,
      3.930852,
      NULL,
      3,
      1,
      1.234482,
      0.600362,
      0.140697,
      NULL,
      2.226474,
      NULL,
      0.200783,
      10.828702,
      3,
      3.905643,
      4.354432,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0,
      1.169173,
      1,
      1.943627,
      0,
      0,
      NULL,
      NULL,
      0.033629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.442002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249123,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.528143,
      0.409556,
      0.962518,
      1.470689,
      NULL,
      3.295031,
      NULL,
      0,
      NULL,
      2,
      NULL,
      79.145307,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.891814,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.403610,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.036904,
      NULL,
      3,
      NULL,
      1.680192,
      NULL,
      1.798347,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.710723,
      NULL,
      0,
      NULL,
      3.408973,
      NULL,
      0,
      NULL,
      0.730868,
      NULL,
      1.475406,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3.134407,
      NULL,
      3.572575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2.215496,
      NULL,
      1.322344,
      NULL,
      1.214881,
      NULL,
      4.566968,
      NULL,
      NULL,
      NULL,
      0.888926,
      1,
      NULL,
      NULL,
      NULL,
      2.129401,
      34,
      1.114753,
      3,
      8,
      4.132921,
      NULL,
      NULL,
      NULL,
      3.346428,
      1.372576,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      99,
      1.291461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.495615,
      NULL,
      2,
      NULL,
      1.890981,
      NULL,
      0.413328,
      NULL,
      0,
      NULL,
      NULL,
      1.215274,
      0,
      NULL,
      0.285346,
      NULL,
      0,
      NULL,
      0.250347,
      NULL,
      1.685418,
      NULL,
      1.665889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.529116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.895745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488050,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      96.857205,
      NULL,
      3.017201,
      1,
      NULL,
      1.624281,
      3,
      0,
      NULL,
      NULL,
      153,
      NULL,
      NULL,
      0,
      1.711765,
      0.256631,
      NULL,
      NULL,
      3,
      26,
      9.362451,
      1.009608,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3.934336,
      NULL,
      NULL,
      1.122651,
      3,
      3,
      2,
      2.752148,
      0.712334,
      1.348354,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      0.282452,
      1,
      NULL,
      0.818615,
      2.819908,
      NULL,
      1.122229,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.299736,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.574414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484215,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5,
      0,
      NULL,
      NULL,
      100,
      89,
      1,
      NULL,
      NULL,
      '41040',
      '20343',
      '00134',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


