set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7127190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      3,
      3,
      0.533464,
      1.126829,
      2,
      2.626476,
      '200',
      '14410343',
      0,
      NULL,
      '1324423',
      0.254357,
      1,
      NULL,
      2,
      '4022',
      NULL,
      0.889600,
      NULL,
      NULL,
      ' 2-25-1979',
      27,
      22.434006,
      NULL,
      NULL,
      5.346175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 7-22-1975',
      NULL,
      0.151821,
      NULL,
      3.475642,
      0.124036,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      4.491030,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      3,
      3.645945,
      0,
      0,
      NULL,
      0,
      1,
      0,
      3,
      0,
      1,
      1,
      5,
      NULL,
      8.814010,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.691813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0,
      1,
      0.815792,
      0.601620,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0,
      5,
      1,
      0,
      1,
      5,
      NULL,
      1,
      1,
      5,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      4,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      3,
      1,
      5,
      1,
      NULL,
      3,
      0,
      5,
      5,
      2,
      NULL,
      5,
      0,
      0,
      NULL,
      1.095435,
      3.380942,
      ' 4-18-1979',
      212,
      '11-16-1987',
      90.119044,
      1.328530,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      0,
      0,
      NULL,
      3.637558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      3,
      0.423198,
      NULL,
      3.292606,
      2.887826,
      3.339065,
      3,
      1.631753,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.403624,
      6.368877,
      8.897664,
      1.771988,
      NULL,
      1.231580,
      NULL,
      NULL,
      NULL,
      1.621949,
      10,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.610776,
      NULL,
      1.429698,
      1,
      0,
      0,
      0.752360,
      2.787952,
      17,
      2.997277,
      0.984906,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      3,
      3,
      2,
      1,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      5,
      3,
      4,
      0.517051,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      2,
      1.678608,
      1.065186,
      0.765603,
      5.081834,
      NULL,
      0,
      0.121066,
      10,
      7,
      1.100135,
      0,
      6,
      NULL,
      0,
      3,
      58,
      2,
      1.323857,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      5.911472,
      NULL,
      NULL,
      '',
      '',
      0.829401,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      0,
      54,
      27,
      NULL,
      0.927480,
      32.987994,
      3,
      1,
      1,
      NULL,
      3,
      NULL,
      2.280310,
      0,
      NULL,
      3,
      0,
      3.829479,
      1.522286,
      NULL,
      NULL,
      1.869146,
      NULL,
      NULL,
      1,
      NULL,
      1.046652,
      1,
      3,
      1,
      2,
      2,
      0.469078,
      3.602982,
      2,
      0.441199,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      8.168685,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869684,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.892802,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361165,
      NULL,
      NULL,
      2.787314,
      1.907834,
      0.285062,
      1.963744,
      NULL,
      NULL,
      0.935926,
      3,
      NULL,
      6.153929,
      6,
      4.581247,
      0,
      3.102956,
      1.762787,
      0,
      2.591385,
      3,
      1.254717,
      6.105026,
      8.486043,
      1.648229,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.347260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      2,
      3.436293,
      3.851761,
      0,
      NULL,
      5,
      7,
      3.824131,
      7,
      1.292166,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.150280,
      NULL,
      0,
      NULL,
      1,
      0.406515,
      8,
      5,
      NULL,
      0.496841,
      NULL,
      NULL,
      3.768888,
      3.312154,
      1,
      3.480809,
      3.653910,
      0.824847,
      1.996202,
      NULL,
      2.132323,
      7,
      8.326842,
      5,
      1.629246,
      NULL,
      NULL,
      3,
      2,
      4,
      0,
      1,
      0.561152,
      0,
      1.930772,
      1,
      NULL,
      NULL,
      4.390951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.454298,
      NULL,
      NULL,
      0.352615,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.539544,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.544175,
      NULL,
      NULL,
      0.771143,
      1.781159,
      0.086818,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.835533,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.790767,
      NULL,
      NULL,
      NULL,
      0.914192,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566822,
      NULL,
      NULL,
      NULL,
      3.865575,
      NULL,
      NULL,
      NULL,
      0.641427,
      NULL,
      NULL,
      NULL,
      0.930641,
      NULL,
      NULL,
      NULL,
      1.411300,
      NULL,
      NULL,
      NULL,
      0.637140,
      NULL,
      NULL,
      NULL,
      0.921319,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      13.292308,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      135,
      9,
      1,
      114,
      29.942534,
      NULL,
      NULL,
      NULL,
      0.722283,
      6.762101,
      0,
      2,
      1.540739,
      1,
      1.448527,
      NULL,
      NULL,
      0,
      26.771120,
      NULL,
      91,
      1.243099,
      1,
      1.349029,
      0.188634,
      0.208758,
      1.772426,
      0.820925,
      0,
      NULL,
      1.584547,
      1,
      1.612219,
      1,
      0.659248,
      NULL,
      1,
      0,
      0.245217,
      1.367361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      0.166633,
      0.167667,
      2.587935,
      1,
      3,
      2.012416,
      NULL,
      2.748455,
      0,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2,
      0.129314,
      NULL,
      0.822554,
      NULL,
      NULL,
      0,
      2.836508,
      NULL,
      3.825262,
      1.037579,
      NULL,
      2,
      0,
      NULL,
      2.794039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218441,
      1,
      1.652823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.558358,
      NULL,
      0,
      NULL,
      2,
      3,
      0,
      NULL,
      68,
      46.133119,
      NULL,
      5.868793,
      0.244895,
      NULL,
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0.055445,
      '',
      '',
      '');
commit;
end;
/


