set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9311844';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.519752,
      NULL,
      1,
      3,
      1,
      NULL,
      0.303000,
      NULL,
      '322',
      '04123433',
      30,
      0.998822,
      '3441343',
      0.906378,
      1,
      NULL,
      3,
      '3022',
      4,
      1,
      NULL,
      NULL,
      '11- 8-1975',
      122.905852,
      4,
      NULL,
      1.770569,
      2.007768,
      ' 9-16-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 2-14-1999',
      NULL,
      1,
      1.158265,
      0,
      1.691556,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      0,
      0,
      0,
      0.470953,
      1,
      NULL,
      0.238355,
      0,
      1,
      0.472201,
      5,
      2,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      5,
      0,
      0,
      3,
      NULL,
      3,
      2,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.627091,
      NULL,
      NULL,
      5,
      3,
      NULL,
      NULL,
      1,
      1,
      3.562576,
      1,
      1.355729,
      1,
      0.449723,
      2.267120,
      0,
      0,
      1.076347,
      3.757595,
      3,
      0.519560,
      NULL,
      NULL,
      NULL,
      0,
      7,
      0,
      1,
      2.421104,
      0,
      NULL,
      NULL,
      1.182017,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      5,
      1,
      3.119785,
      0,
      NULL,
      0,
      0,
      0.552748,
      NULL,
      0.447104,
      NULL,
      0,
      5,
      3,
      1,
      1,
      3,
      NULL,
      NULL,
      5,
      0,
      1,
      NULL,
      1,
      4,
      1,
      NULL,
      3,
      5,
      NULL,
      0,
      0,
      1,
      1,
      3,
      5.846138,
      2,
      '11- 2-1989',
      1442,
      ' 5- 4-2000',
      NULL,
      1.323295,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.812958,
      NULL,
      NULL,
      NULL,
      0.985808,
      0,
      0.818668,
      NULL,
      1,
      3.130206,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.492918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.919801,
      1.962786,
      0.956581,
      0,
      0,
      0,
      1.641984,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.084420,
      1,
      3,
      3,
      3,
      2,
      0,
      0,
      3,
      2,
      2,
      0.113334,
      3.174311,
      1,
      2,
      1,
      0.969999,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2.813001,
      NULL,
      0,
      3,
      0,
      1.055289,
      1,
      3.512202,
      10.692355,
      0,
      3,
      NULL,
      2,
      1.737324,
      NULL,
      5,
      NULL,
      1,
      1,
      21,
      2,
      1,
      55,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '30342',
      NULL,
      NULL,
      0.968635,
      '',
      NULL,
      NULL,
      NULL,
      '0013',
      '',
      '',
      3.872228,
      7,
      129.864222,
      8,
      0.070855,
      13.610022,
      7,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.395104,
      1,
      3.843761,
      NULL,
      0.395448,
      1,
      0,
      0,
      1,
      1.677437,
      0.288842,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      0.506561,
      3.803605,
      NULL,
      4,
      0,
      0.568133,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.074655,
      2.496879,
      0,
      2,
      0,
      1.179555,
      3,
      NULL,
      1,
      3,
      1.442125,
      0.294107,
      1,
      1.807679,
      3,
      1,
      1,
      0,
      2.980341,
      0.814762,
      1.486277,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      3.981658,
      NULL,
      1.636355,
      1.174974,
      0.246628,
      0.683953,
      3.647865,
      NULL,
      1,
      4.743649,
      2.359135,
      7,
      1,
      1.893951,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.647463,
      3,
      0.656102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.802634,
      NULL,
      NULL,
      NULL,
      0.866077,
      0,
      0,
      3,
      1.990706,
      0,
      1,
      NULL,
      NULL,
      0.132595,
      1.951280,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.520596,
      NULL,
      NULL,
      2,
      0.630499,
      2,
      1.399541,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.348975,
      0,
      7,
      0.531982,
      NULL,
      NULL,
      NULL,
      NULL,
      2.765214,
      0,
      0,
      3,
      3.743726,
      NULL,
      0.328483,
      6.141658,
      0,
      NULL,
      3.898739,
      NULL,
      3.821094,
      1,
      NULL,
      2.736063,
      NULL,
      NULL,
      NULL,
      2.184812,
      NULL,
      3,
      9,
      NULL,
      4.946772,
      NULL,
      1,
      4.887760,
      3.260940,
      0,
      NULL,
      0.729106,
      0.476745,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.862925,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.687962,
      NULL,
      NULL,
      0.172527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      0,
      0.547136,
      1,
      2.325484,
      0,
      NULL,
      NULL,
      1.427314,
      3,
      NULL,
      NULL,
      NULL,
      5.349604,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.748347,
      NULL,
      NULL,
      1,
      1.539952,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.607783,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      1.330377,
      NULL,
      NULL,
      2.084971,
      1.619453,
      NULL,
      NULL,
      NULL,
      1.156680,
      NULL,
      NULL,
      1.529272,
      0.731527,
      NULL,
      NULL,
      3,
      1.355049,
      NULL,
      NULL,
      NULL,
      3.125161,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.109521,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.767981,
      1.753802,
      NULL,
      NULL,
      4.759292,
      8.200071,
      NULL,
      NULL,
      0,
      2.554855,
      NULL,
      4,
      1,
      2,
      138.147763,
      NULL,
      3.704788,
      217.418543,
      4.080702,
      0.508058,
      NULL,
      NULL,
      0,
      2.373033,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      16.630001,
      0,
      3.146957,
      0.625975,
      2.717920,
      1,
      1.424514,
      0,
      3.758590,
      0.190983,
      NULL,
      NULL,
      1,
      1,
      3.056095,
      1,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      3.386013,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      140.290632,
      NULL,
      1.062230,
      1.738917,
      27.327233,
      1,
      2,
      2.288992,
      NULL,
      1.919287,
      NULL,
      1,
      NULL,
      1.926711,
      NULL,
      0.761573,
      NULL,
      0.553635,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.521594,
      NULL,
      1.552705,
      NULL,
      0,
      NULL,
      0.913916,
      NULL,
      1.752681,
      NULL,
      1,
      3,
      1.638154,
      1.268355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.650134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.824092,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.915293,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536084,
      1,
      0.310554,
      NULL,
      2,
      NULL,
      0.064497,
      NULL,
      75,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.121097,
      1,
      2,
      14.156932,
      39,
      0.382405,
      1.308546,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      5,
      3.337951,
      0,
      NULL,
      1.027804,
      2,
      3,
      NULL,
      1,
      1,
      0,
      0.245785,
      0,
      1.978917,
      1.996968,
      3.801385,
      3.083196,
      2.813736,
      2,
      0.328733,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.191723,
      3,
      NULL,
      1,
      1.611783,
      NULL,
      1.128105,
      1.975786,
      0,
      0.224259,
      2,
      3,
      1.144880,
      1.328891,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.141420,
      0.305819,
      0.384458,
      0,
      5,
      0,
      NULL,
      1.689519,
      3,
      67,
      72,
      3,
      NULL,
      4.108465,
      '12414',
      '43014',
      '14104',
      0.086243,
      '',
      '',
      '',
      0.660602,
      '3212',
      '',
      '');
commit;
end;
/


