set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000093';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      0.228940,
      0,
      NULL,
      0,
      '4114',
      2,
      1,
      1,
      29,
      ' 0-23-1984',
      5.768735,
      NULL,
      NULL,
      0,
      NULL,
      '11- 1-1998',
      77.484657,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 0-14-1989',
      0,
      1,
      0,
      1,
      1,
      3.425331,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      23,
      0,
      NULL,
      3,
      3,
      8,
      0.890060,
      0,
      1,
      1,
      0,
      0.872852,
      0.162542,
      1,
      0.087104,
      NULL,
      7,
      5,
      3,
      NULL,
      2.434554,
      3,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      3.010953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.422013,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.199575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      2,
      1,
      1,
      1,
      0,
      0,
      2,
      0,
      0,
      0.961151,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      0,
      2,
      NULL,
      0,
      2,
      0,
      0,
      2,
      0,
      1,
      0,
      1,
      0,
      5,
      0,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564852,
      NULL,
      NULL,
      2,
      1.183440,
      2.936813,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968809,
      1.598185,
      1,
      1,
      2.292997,
      0,
      1.815318,
      1.083656,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.001694,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      5.104834,
      NULL,
      1.637093,
      0.604295,
      1.944631,
      0,
      0,
      1.477826,
      1.318643,
      1.680238,
      0,
      0.234451,
      4.306108,
      1,
      1,
      0,
      1,
      NULL,
      1.107963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      0.662357,
      0.865199,
      '11024',
      NULL,
      '',
      0.827422,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.460940,
      26.390750,
      564,
      37,
      0.791102,
      5,
      30,
      15,
      2,
      3.724692,
      0.781231,
      1.609063,
      2,
      0.824033,
      0,
      0.490565,
      NULL,
      NULL,
      1,
      NULL,
      1.683066,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      2.043213,
      2.899542,
      12.574529,
      8,
      NULL,
      NULL,
      5.628101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.929978,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      1,
      NULL,
      12.841468,
      11,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.635264,
      2.892310,
      13.350049,
      NULL,
      NULL,
      NULL,
      1,
      0.748304,
      NULL,
      2.341357,
      2.055414,
      3,
      1,
      NULL,
      0,
      1,
      0,
      0.618961,
      NULL,
      0.261551,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969860,
      NULL,
      NULL,
      3.951220,
      NULL,
      3.071434,
      7.137907,
      0.578205,
      1.541641,
      NULL,
      NULL,
      3.712061,
      NULL,
      1.864100,
      1.991518,
      NULL,
      NULL,
      NULL,
      0.888001,
      NULL,
      NULL,
      NULL,
      0.577615,
      0,
      1.776623,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      2.013614,
      3,
      2,
      5.400021,
      4,
      6.884348,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254341,
      NULL,
      NULL,
      1.845104,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.962953,
      1,
      2,
      1,
      4,
      0,
      3,
      0,
      2.566129,
      0,
      NULL,
      NULL,
      1.489911,
      3.337977,
      1,
      0,
      0,
      NULL,
      0.730463,
      NULL,
      NULL,
      5,
      NULL,
      3.974300,
      NULL,
      2,
      4,
      1.750035,
      2,
      1,
      NULL,
      NULL,
      1.987900,
      0,
      NULL,
      NULL,
      NULL,
      7.827493,
      4.770208,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      3.044478,
      1.530786,
      1.464883,
      2.451031,
      0,
      2,
      6.614151,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      2.073343,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.782203,
      NULL,
      1.589648,
      NULL,
      NULL,
      3,
      18.983027,
      NULL,
      NULL,
      10,
      NULL,
      0,
      1.108369,
      NULL,
      5.166734,
      12.421214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      175.335783,
      NULL,
      3,
      NULL,
      1.577146,
      1,
      NULL,
      2.533180,
      NULL,
      NULL,
      NULL,
      2,
      5.481924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.498196,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.014005,
      NULL,
      NULL,
      2.368829,
      NULL,
      NULL,
      NULL,
      1,
      3.377198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.474662,
      13,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.855134,
      0.698840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531502,
      1.012345,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.775433,
      NULL,
      3,
      2,
      149,
      48.588326,
      0.786487,
      1576,
      1541,
      1.452468,
      NULL,
      NULL,
      0.156035,
      NULL,
      NULL,
      3,
      NULL,
      16,
      0.108391,
      NULL,
      NULL,
      1.922622,
      NULL,
      0,
      223,
      1.948550,
      1.792059,
      2,
      1.995772,
      0.024017,
      0,
      0.641366,
      0,
      NULL,
      1,
      NULL,
      1.034429,
      1.225901,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.836099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770129,
      NULL,
      2.667084,
      1,
      1.679298,
      1.266860,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.490122,
      0.889476,
      2.459181,
      0.967136,
      NULL,
      NULL,
      NULL,
      NULL,
      0.583992,
      0,
      0,
      0.816378,
      0.909834,
      NULL,
      1,
      1.138854,
      1.532709,
      3,
      0.156663,
      1.880417,
      NULL,
      2,
      0,
      NULL,
      1.569255,
      1.542432,
      2.662935,
      0.426915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4,
      3,
      NULL,
      NULL,
      NULL,
      81,
      9,
      0,
      1.710017,
      0.666903,
      '10103',
      '',
      '',
      0.586876,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


