set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503544';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0302211',
      2.895045,
      1,
      3,
      0,
      NULL,
      1,
      0.143066,
      NULL,
      NULL,
      ' 0-17-2001',
      NULL,
      NULL,
      0,
      2.819287,
      0.811192,
      ' 9-16-1987',
      9.377748,
      NULL,
      165,
      120.183930,
      1,
      NULL,
      ' 8- 2-1991',
      '10-20-1979',
      2.941218,
      3.298249,
      2,
      0.494578,
      0.208044,
      0.218554,
      NULL,
      1,
      1,
      6.958322,
      5,
      5.234307,
      5,
      5,
      16.877985,
      NULL,
      0.927579,
      NULL,
      1,
      1.656193,
      0.598407,
      0,
      3,
      NULL,
      1.914582,
      1.553787,
      0,
      NULL,
      1.660828,
      1,
      0,
      2,
      3,
      3,
      2,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0,
      7.199588,
      1,
      NULL,
      1,
      1,
      1.028497,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      0,
      NULL,
      0.870962,
      0,
      1.115179,
      0.380868,
      0,
      0.525297,
      1.396286,
      0,
      3.660461,
      1,
      3.554281,
      1,
      0.618917,
      0.281019,
      0.076484,
      0.613559,
      1,
      1,
      1,
      NULL,
      1,
      2,
      1.223287,
      1,
      NULL,
      NULL,
      1.502288,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      2,
      0,
      0,
      1,
      5,
      1,
      1,
      0,
      1,
      0.487311,
      NULL,
      0.531572,
      0,
      0,
      0,
      0,
      1,
      1,
      2,
      0,
      5,
      1,
      1,
      NULL,
      2,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      5,
      1,
      0,
      5,
      1,
      1,
      NULL,
      625.895376,
      ' 5- 1-1978',
      NULL,
      2.197859,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.786255,
      0.223890,
      NULL,
      NULL,
      NULL,
      0.956066,
      0.238726,
      3.495967,
      4,
      1.375820,
      1.401490,
      0.435298,
      NULL,
      NULL,
      NULL,
      2,
      9,
      1.520988,
      NULL,
      2,
      3,
      5.986300,
      ' 4-22-1998',
      35,
      ' 9-28-1983',
      4,
      0.840214,
      NULL,
      1.714044,
      0.711253,
      0.819465,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      60.808182,
      1.311662,
      1.555928,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.510811,
      NULL,
      3,
      1,
      2,
      3,
      0,
      NULL,
      NULL,
      1,
      0,
      2.663928,
      3.493436,
      13.067912,
      4.929125,
      NULL,
      0,
      1.703217,
      0.667016,
      1.804613,
      2.451700,
      NULL,
      NULL,
      0,
      1.799748,
      0.499959,
      3,
      1.434259,
      2,
      1,
      5,
      1.577031,
      3.473037,
      3.493011,
      0.313063,
      1,
      0,
      1,
      2.975572,
      2,
      NULL,
      2,
      NULL,
      3,
      0.182936,
      NULL,
      55,
      18,
      42,
      4,
      1,
      1.595606,
      '42404',
      '',
      '',
      0.849520,
      '',
      NULL,
      '',
      7.723590,
      '42434',
      '30003',
      '14010',
      2.779327,
      27.770182,
      140,
      24.886510,
      3,
      43.076042,
      NULL,
      NULL,
      3,
      1.191959,
      2.637891,
      1,
      0,
      2.111930,
      0,
      1,
      1,
      1.941227,
      0.534113,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.405614,
      0,
      1,
      0,
      1.680393,
      2.871538,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.901635,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.714118,
      NULL,
      NULL,
      4.070446,
      8,
      6,
      0,
      0,
      1.211166,
      NULL,
      0,
      0.038849,
      3.384279,
      NULL,
      0.558156,
      1,
      0,
      2.510172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      2,
      3,
      1.056790,
      NULL,
      1,
      NULL,
      2,
      0,
      1.708779,
      1.620852,
      1,
      1,
      1,
      NULL,
      NULL,
      0.303055,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      1,
      0,
      1.581848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.847767,
      NULL,
      NULL,
      1,
      2.225690,
      1.911273,
      1.744586,
      NULL,
      NULL,
      4.879844,
      5.270556,
      0.728712,
      0.003366,
      1.207174,
      3,
      3.849798,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.621349,
      NULL,
      NULL,
      1.587069,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.842717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948600,
      NULL,
      NULL,
      NULL,
      0.181493,
      NULL,
      2,
      NULL,
      0,
      3,
      NULL,
      1.242392,
      4.610620,
      NULL,
      4.592143,
      4,
      0,
      0.045606,
      0.523370,
      NULL,
      NULL,
      3,
      1,
      1,
      3,
      2.267906,
      3,
      NULL,
      NULL,
      5.410334,
      2,
      NULL,
      3.673518,
      NULL,
      0,
      NULL,
      3,
      3.758388,
      2.765895,
      3.598776,
      0.975784,
      NULL,
      7,
      0,
      1,
      9.417330,
      1.707482,
      0,
      1.603997,
      2,
      NULL,
      3,
      2.724738,
      3.901785,
      1.270176,
      2.412030,
      1,
      NULL,
      2,
      4,
      NULL,
      28.106923,
      45.079773,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      0.507410,
      0.473583,
      NULL,
      0,
      1,
      NULL,
      2,
      2.925344,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.854552,
      NULL,
      3,
      2.462846,
      NULL,
      2,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      1,
      3.937356,
      1.643355,
      NULL,
      2,
      2,
      2,
      NULL,
      7.060463,
      NULL,
      1.001546,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.277512,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.431608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.060394,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.130119,
      1.434411,
      0.266026,
      NULL,
      1.547068,
      0,
      1.348255,
      NULL,
      1,
      0,
      1.196191,
      NULL,
      9,
      1,
      4.858026,
      NULL,
      4.911296,
      NULL,
      NULL,
      NULL,
      NULL,
      3.866996,
      NULL,
      10,
      2.626146,
      4.344559,
      0.994770,
      1.192396,
      NULL,
      NULL,
      2.866218,
      28,
      6.028893,
      3.960604,
      126.361187,
      25.980396,
      0,
      NULL,
      NULL,
      0.590645,
      2,
      0,
      36,
      0,
      0,
      1,
      NULL,
      0,
      0.016703,
      1.825075,
      1.583811,
      NULL,
      1,
      1.380018,
      0.719337,
      1.154063,
      NULL,
      1.703699,
      1,
      0,
      0.891328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1.791502,
      3,
      3,
      2,
      0.214995,
      1.081149,
      NULL,
      3.178102,
      NULL,
      NULL,
      3,
      0,
      0.680653,
      0.379402,
      0.033182,
      0,
      1.081815,
      0.973770,
      1,
      2,
      NULL,
      3,
      1.662966,
      1.139198,
      1.207152,
      1.776815,
      3.967586,
      1,
      1,
      NULL,
      NULL,
      1.463048,
      1,
      1.872139,
      1.069559,
      NULL,
      0,
      1.794367,
      NULL,
      0,
      NULL,
      NULL,
      1.570596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.224558,
      2.176848,
      0.390042,
      1.493816,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.792783,
      NULL,
      NULL,
      NULL,
      1.271798,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.901529,
      NULL,
      39,
      NULL,
      4.699046,
      1,
      1,
      0.847300,
      1.782192,
      NULL,
      0.406533,
      4,
      NULL,
      2,
      0.535434,
      NULL,
      NULL,
      NULL,
      108.503856,
      2,
      1,
      1.166816,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '4221',
      '34244');
commit;
end;
/


