set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518951';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '1434413',
      2.920267,
      NULL,
      5,
      3,
      '0301',
      3,
      0.060519,
      NULL,
      NULL,
      '11-19-2002',
      43.370923,
      NULL,
      NULL,
      0.933015,
      NULL,
      ' 1-22-1981',
      NULL,
      2.978980,
      40.489636,
      24.170243,
      0,
      NULL,
      NULL,
      ' 4-18-1983',
      3.966382,
      0,
      NULL,
      2.212526,
      0,
      3.902353,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      5,
      1,
      3,
      11,
      0,
      2,
      2.020076,
      0.393525,
      NULL,
      0,
      1.696097,
      0,
      0.522421,
      NULL,
      1.753600,
      1.909995,
      0.632417,
      1,
      9,
      3,
      0,
      2.877551,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      2,
      5,
      5,
      1,
      3,
      2,
      2.844441,
      1,
      2,
      0,
      0,
      1.711692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      1.774812,
      NULL,
      1,
      2.532227,
      NULL,
      NULL,
      1.472581,
      3.978243,
      1,
      NULL,
      NULL,
      1.585401,
      NULL,
      2.883188,
      3,
      NULL,
      2,
      1,
      1,
      7.112815,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1.642321,
      NULL,
      NULL,
      0,
      3,
      5,
      1,
      4,
      4,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      3.379196,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      5,
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      5,
      NULL,
      0,
      3,
      NULL,
      0,
      3,
      2,
      1,
      2,
      3,
      2,
      1,
      4,
      2,
      0,
      NULL,
      0.135785,
      NULL,
      285,
      '10-24-1990',
      5.775744,
      2,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      1.740675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.609194,
      3.281950,
      0.275329,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.149013,
      NULL,
      0,
      0,
      3,
      2.076686,
      0.704750,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      NULL,
      2,
      0,
      3,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      3.616881,
      NULL,
      2.893348,
      0.835816,
      1,
      3.687937,
      4.874721,
      NULL,
      0,
      NULL,
      0.908108,
      1.739537,
      NULL,
      0,
      1,
      1,
      2,
      1.322396,
      6.328896,
      6,
      1.985876,
      5,
      NULL,
      2,
      4,
      0,
      3,
      0,
      2,
      0,
      NULL,
      0,
      1,
      33,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      '23140',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      3,
      16,
      58.860490,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.393133,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.324399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.422405,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.232795,
      1.080609,
      NULL,
      2.546180,
      3.792329,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.205022,
      NULL,
      0,
      NULL,
      NULL,
      3.718227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.058143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.037440,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794853,
      NULL,
      NULL,
      3.484865,
      NULL,
      1.660437,
      1.659069,
      1,
      NULL,
      1.509434,
      1,
      1,
      2,
      NULL,
      NULL,
      2.558376,
      1,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.506652,
      NULL,
      NULL,
      1.478040,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.541792,
      0,
      2,
      0,
      2,
      0,
      3.863292,
      3,
      5.518065,
      5.990073,
      3.561107,
      3,
      1.899553,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3.902728,
      3.491775,
      1,
      1,
      3.161019,
      NULL,
      4,
      7.296464,
      NULL,
      NULL,
      1,
      3.875689,
      2.786389,
      1.830910,
      0,
      NULL,
      1.171575,
      2,
      2,
      3,
      1,
      2,
      0.020464,
      0.354902,
      4,
      3,
      0,
      NULL,
      NULL,
      0.267881,
      1,
      0.433222,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.305670,
      3.375913,
      0.439376,
      1,
      0.834846,
      1.565733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564706,
      NULL,
      NULL,
      NULL,
      0.724749,
      NULL,
      NULL,
      3.779717,
      NULL,
      NULL,
      0.755430,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.396166,
      NULL,
      NULL,
      0.384329,
      NULL,
      NULL,
      0.161544,
      NULL,
      0.461996,
      NULL,
      1,
      1,
      NULL,
      0.708401,
      1,
      0.510892,
      0,
      0,
      NULL,
      0.434630,
      NULL,
      NULL,
      1,
      0.784456,
      1,
      NULL,
      0.259829,
      1.665877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.356646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.177692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362600,
      2.338532,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.224835,
      1,
      3.322959,
      0.306425,
      1.600390,
      NULL,
      NULL,
      0.720461,
      1,
      0,
      0.919691,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      2.104072,
      5.264338,
      2.646193,
      3,
      9,
      NULL,
      0.666835,
      1.748573,
      NULL,
      2.802164,
      NULL,
      3,
      0.676626,
      NULL,
      0,
      0,
      NULL,
      0.180444,
      0.029942,
      NULL,
      3,
      0.579951,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.862490,
      2.048946,
      NULL,
      0.638368,
      0,
      NULL,
      NULL,
      1.053408,
      1.457982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.758134,
      NULL,
      0.668471,
      NULL,
      0,
      2,
      NULL,
      0.581745,
      NULL,
      NULL,
      10.000089,
      18,
      2,
      3.287231,
      2,
      '13031',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.597363,
      '',
      '',
      NULL);
commit;
end;
/


