set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9675729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      '41',
      25,
      19,
      NULL,
      3,
      0.780988,
      1,
      1,
      '2302',
      1,
      1.623109,
      NULL,
      NULL,
      ' 9- 6-1981',
      26,
      41.404597,
      NULL,
      3.185672,
      NULL,
      ' 2-28-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 3-24-1982',
      ' 2- 3-1985',
      NULL,
      0,
      1.688123,
      0,
      1.777097,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      11.553102,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0.929446,
      0,
      1,
      0,
      1,
      1.759248,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      5,
      3,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      2,
      1,
      0,
      1,
      1,
      NULL,
      0,
      3.545075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.421211,
      NULL,
      1.329865,
      1,
      2,
      0.953148,
      0,
      1,
      NULL,
      1.537425,
      0.319075,
      0.498528,
      NULL,
      2.449712,
      0.629475,
      0,
      NULL,
      NULL,
      1,
      1,
      1.911763,
      0,
      2,
      0.087821,
      1.386913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      1.976261,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      4,
      1,
      0,
      NULL,
      5,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      5,
      4,
      NULL,
      5,
      5,
      0,
      5,
      0,
      NULL,
      3.033109,
      2.316925,
      '10-11-1993',
      14.337643,
      ' 2-26-1982',
      0.592426,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1.445409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.771379,
      1.786243,
      NULL,
      0,
      5,
      3.608654,
      NULL,
      NULL,
      NULL,
      0.563681,
      3.270763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.986325,
      0.694201,
      NULL,
      0,
      1.095362,
      0,
      1,
      NULL,
      5.845749,
      2.438509,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.793733,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      3,
      1,
      NULL,
      3,
      NULL,
      1,
      0.899062,
      1,
      0,
      0.187537,
      NULL,
      1,
      0,
      1,
      1.869134,
      0,
      NULL,
      NULL,
      NULL,
      1,
      10,
      NULL,
      5.525089,
      NULL,
      8.550554,
      7.815577,
      NULL,
      0.622336,
      0,
      0.007088,
      2.600125,
      1.145530,
      67,
      2,
      2.432262,
      51,
      NULL,
      NULL,
      30,
      0,
      3,
      3.295416,
      '40444',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      17.030587,
      11,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      0.185753,
      1.904615,
      NULL,
      NULL,
      0,
      3.810857,
      1,
      0.109740,
      3.565962,
      NULL,
      2,
      NULL,
      0,
      3.612282,
      2,
      0,
      0.222878,
      NULL,
      NULL,
      1.428217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503232,
      NULL,
      NULL,
      7,
      4,
      NULL,
      1,
      1.062559,
      NULL,
      NULL,
      NULL,
      3.753761,
      1,
      NULL,
      2.962500,
      NULL,
      1.813531,
      0.501794,
      1.507349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.900684,
      0,
      3.105510,
      1.027403,
      1,
      NULL,
      0.841531,
      0.082804,
      0.146136,
      2.571037,
      NULL,
      NULL,
      0.431456,
      NULL,
      1.172481,
      1.972145,
      NULL,
      NULL,
      0.573840,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.890137,
      2,
      0.497689,
      NULL,
      0,
      NULL,
      NULL,
      0.736652,
      NULL,
      NULL,
      3,
      2,
      2.300972,
      0.010890,
      2.285051,
      1.772819,
      4.552168,
      NULL,
      4,
      0.238982,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.467563,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.219193,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.541575,
      2,
      1.481551,
      NULL,
      NULL,
      5.492721,
      7,
      3,
      2.404437,
      6,
      3,
      1,
      NULL,
      NULL,
      0,
      1.961409,
      NULL,
      3,
      2.016871,
      NULL,
      2,
      3.701564,
      2,
      NULL,
      NULL,
      0.257232,
      1.506259,
      2.192989,
      NULL,
      2.471141,
      2,
      3.988310,
      3,
      2,
      3.014085,
      2,
      3.461231,
      NULL,
      0,
      6,
      3,
      3,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.159357,
      1.499185,
      1.013148,
      1,
      NULL,
      3.453082,
      NULL,
      NULL,
      1.564754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.690513,
      NULL,
      NULL,
      1.757246,
      NULL,
      NULL,
      1.587414,
      NULL,
      NULL,
      2,
      3,
      2.189081,
      1,
      3.182982,
      0,
      0.067236,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.731624,
      NULL,
      NULL,
      NULL,
      1.640613,
      NULL,
      NULL,
      NULL,
      3.031243,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.433626,
      NULL,
      1.060569,
      NULL,
      0.307074,
      NULL,
      1,
      NULL,
      1.742111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.752363,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.118680,
      NULL,
      2.514404,
      NULL,
      1.305020,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.553498,
      NULL,
      0.337053,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      9,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.230611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.827576,
      1,
      0.564555,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0.597815,
      1,
      0,
      0,
      NULL,
      0.330191,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      1,
      4,
      0,
      0,
      0.473700,
      1,
      0,
      0.044564,
      0.441775,
      1.792837,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.328523,
      0.751994,
      2.370717,
      1.461974,
      0,
      1.752164,
      1,
      1.722747,
      2.567372,
      1,
      NULL,
      3.792345,
      0,
      0,
      1.286964,
      NULL,
      0.513196,
      3,
      1.703224,
      3.157364,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691355,
      NULL,
      1,
      0.473704,
      1,
      4,
      4,
      2,
      1,
      NULL,
      NULL,
      95,
      107.114367,
      5,
      3,
      3.041278,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


