set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023762';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '2240021',
      2.993222,
      0.138529,
      2,
      NULL,
      '3303',
      0,
      0,
      NULL,
      NULL,
      ' 0-11-1976',
      79,
      NULL,
      3,
      2.661677,
      0.206277,
      ' 8- 3-2002',
      35.491948,
      3,
      137,
      153.300249,
      2,
      NULL,
      ' 0-19-1976',
      ' 6-15-2002',
      0,
      0.662935,
      1.759074,
      2.805716,
      NULL,
      2,
      3,
      1.117859,
      0,
      171.858321,
      NULL,
      7,
      3,
      44,
      104,
      0,
      6.608931,
      4,
      3,
      5.163207,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      0,
      3,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      3,
      0.115749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2.531817,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.580644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      3,
      0,
      1.278425,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1.617966,
      3,
      0,
      1,
      0,
      1,
      4,
      3,
      NULL,
      2,
      2,
      0,
      NULL,
      1,
      4,
      1,
      1,
      1,
      1,
      5,
      1,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      2.074538,
      ' 7-12-1985',
      1715.570736,
      NULL,
      1252,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      2.407594,
      1,
      0,
      1.258206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706175,
      1.800201,
      1.605147,
      0,
      0,
      1.032707,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      1,
      1.915826,
      1.374282,
      0.172364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      0,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      2,
      3,
      0,
      1.187342,
      1,
      0.355811,
      1.119645,
      NULL,
      0.799069,
      1,
      1.771154,
      NULL,
      0.661114,
      2,
      NULL,
      7.111502,
      9,
      11,
      4,
      4,
      3.326481,
      NULL,
      1,
      2.047190,
      1.248878,
      NULL,
      0,
      0.114365,
      NULL,
      NULL,
      21,
      NULL,
      1,
      0.790070,
      4.686372,
      '22224',
      '41142',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '3423',
      '4331',
      NULL,
      NULL,
      20.923886,
      152,
      NULL,
      NULL,
      1.837428,
      NULL,
      297.251939,
      3,
      0,
      NULL,
      NULL,
      0.733813,
      NULL,
      NULL,
      0.879631,
      NULL,
      NULL,
      1,
      0,
      0.195135,
      1.278936,
      NULL,
      NULL,
      1.842800,
      0.488105,
      NULL,
      0.508253,
      NULL,
      NULL,
      0.185080,
      NULL,
      NULL,
      NULL,
      0.950468,
      0,
      NULL,
      NULL,
      NULL,
      0.849555,
      2.349361,
      0.928519,
      0,
      0,
      0,
      NULL,
      2.224878,
      1,
      0,
      1.130254,
      NULL,
      NULL,
      NULL,
      1.909901,
      NULL,
      NULL,
      NULL,
      1.985499,
      2.441218,
      NULL,
      1.368954,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.328284,
      1.542457,
      3,
      0,
      0,
      NULL,
      1,
      0,
      0.620560,
      3,
      1,
      NULL,
      0.029311,
      NULL,
      0,
      NULL,
      NULL,
      1.938949,
      1,
      NULL,
      NULL,
      0.409910,
      NULL,
      NULL,
      2,
      4,
      5,
      1,
      1.694655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406119,
      NULL,
      NULL,
      1.798817,
      NULL,
      NULL,
      3.105710,
      0.442637,
      1.954735,
      1.847481,
      NULL,
      NULL,
      2,
      4,
      3.119387,
      0.172380,
      0,
      1.959124,
      3,
      NULL,
      1,
      4,
      4.901357,
      4.533360,
      0,
      NULL,
      NULL,
      0.171752,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.448833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.869899,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.886235,
      5.674410,
      5.272349,
      NULL,
      6.072271,
      0,
      4.427243,
      7.654125,
      NULL,
      NULL,
      NULL,
      3,
      3.818862,
      NULL,
      1,
      NULL,
      NULL,
      7,
      3,
      6,
      0,
      NULL,
      0,
      1.220045,
      0,
      2.951757,
      NULL,
      0.168405,
      2,
      3.912620,
      1,
      3,
      7,
      7.490788,
      1.923466,
      5.279115,
      NULL,
      5.497281,
      2.371130,
      0,
      3,
      0.109071,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.874248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496664,
      NULL,
      NULL,
      3.899567,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      5.927256,
      NULL,
      NULL,
      0.209397,
      0.616770,
      NULL,
      0,
      0.566297,
      0.948786,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.816095,
      NULL,
      NULL,
      NULL,
      0.596622,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.549612,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.682477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      418.359246,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363997,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.109288,
      NULL,
      2,
      NULL,
      1128,
      0.711019,
      1,
      1.107104,
      1,
      1.510300,
      0,
      0,
      1.930948,
      1.527369,
      0,
      1.546737,
      1,
      0,
      1,
      1.355464,
      1,
      1.797738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      7.098217,
      7.409479,
      NULL,
      5.612846,
      1,
      19,
      2.911845,
      3.126114,
      0.986602,
      1.563787,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.582666,
      0.541660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.005308,
      NULL,
      1.530801,
      2.189183,
      NULL,
      3.009619,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.305193,
      NULL,
      1,
      2.490519,
      NULL,
      0,
      0.984600,
      NULL,
      NULL,
      0.444323,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.353375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4,
      3,
      4,
      0.392696,
      NULL,
      0,
      28,
      75.831840,
      NULL,
      1,
      6,
      '24322',
      '42411',
      '20420',
      0,
      NULL,
      '',
      '',
      5,
      NULL,
      '1130',
      NULL);
commit;
end;
/


