set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9505528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      NULL,
      10,
      15,
      NULL,
      1,
      1.095935,
      5,
      NULL,
      '4110',
      5,
      0,
      NULL,
      NULL,
      '11-15-1994',
      NULL,
      NULL,
      NULL,
      3.928133,
      0,
      ' 3-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 2-13-1980',
      ' 8-24-1991',
      ' 2-15-1995',
      2.268444,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.391476,
      NULL,
      4,
      8.022074,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.171213,
      0,
      0,
      0,
      0.415415,
      0.926864,
      NULL,
      NULL,
      1.378411,
      NULL,
      1,
      3,
      2,
      5,
      2,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      6.110743,
      2,
      1,
      1,
      1,
      1.966946,
      NULL,
      NULL,
      1.683655,
      NULL,
      NULL,
      4,
      4,
      2.810001,
      2,
      1.581654,
      0.575060,
      2,
      2,
      1,
      NULL,
      1.847928,
      1.030642,
      2,
      NULL,
      2,
      0.569035,
      1,
      0.327937,
      0.893708,
      1,
      0,
      0,
      NULL,
      0,
      0,
      3.617022,
      1.770267,
      NULL,
      NULL,
      0.118410,
      NULL,
      NULL,
      1,
      5,
      4,
      1,
      1,
      4,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1.173800,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      3,
      5,
      1,
      1,
      2,
      0,
      3,
      4,
      5,
      4,
      2,
      1.511318,
      NULL,
      99,
      ' 3-24-1983',
      127,
      3.319371,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      3,
      2,
      0.531388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.209096,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.664481,
      7.213991,
      1.920962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.409048,
      0,
      NULL,
      1,
      1.972868,
      0.856810,
      1,
      NULL,
      NULL,
      NULL,
      0.113767,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.488154,
      0,
      0,
      1,
      3,
      3,
      3,
      3,
      NULL,
      3,
      3,
      3,
      3.078256,
      NULL,
      NULL,
      0.273115,
      0,
      0.762632,
      0.350893,
      1.129092,
      0.114236,
      0,
      0,
      1.735634,
      1.172148,
      1.339998,
      0,
      NULL,
      3.681134,
      NULL,
      5,
      NULL,
      0,
      1.124419,
      NULL,
      1,
      4,
      3,
      1.886792,
      2.980938,
      NULL,
      3.540918,
      12,
      NULL,
      0.157729,
      NULL,
      NULL,
      NULL,
      16.983407,
      3,
      5.900860,
      NULL,
      '42422',
      NULL,
      '10113',
      1,
      '',
      NULL,
      '',
      3.767675,
      '3423',
      '',
      '',
      NULL,
      36.127814,
      NULL,
      NULL,
      1.055854,
      15,
      NULL,
      NULL,
      0,
      2,
      3.076038,
      NULL,
      1,
      NULL,
      NULL,
      0.608772,
      NULL,
      NULL,
      1.771518,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.010592,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.957069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.866387,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.382486,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226217,
      1.229193,
      1.648617,
      3,
      1,
      2,
      3,
      0.444090,
      2.008816,
      NULL,
      1,
      NULL,
      3.696560,
      0.318025,
      2.563704,
      0.234480,
      0.755126,
      NULL,
      0.805075,
      1.340251,
      NULL,
      0.406908,
      0.561294,
      1.793866,
      1.493176,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.440823,
      NULL,
      0,
      0,
      NULL,
      2.428270,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.692840,
      2.074358,
      0.858111,
      0,
      0,
      1,
      NULL,
      NULL,
      11.365774,
      6.679466,
      2.935109,
      3,
      3,
      1,
      0,
      NULL,
      NULL,
      5,
      4.570610,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.996199,
      NULL,
      NULL,
      1,
      3.153527,
      0,
      0.542379,
      3.923578,
      1.416786,
      NULL,
      1,
      3,
      4.609744,
      0.098204,
      3,
      NULL,
      4.493348,
      3,
      NULL,
      1,
      1.532878,
      2,
      1,
      1.825509,
      2.358738,
      1.837332,
      3,
      NULL,
      6,
      NULL,
      1.200053,
      1,
      NULL,
      0.076235,
      1.917788,
      NULL,
      1.512508,
      0.177118,
      0,
      2,
      1.440051,
      0,
      NULL,
      8,
      1,
      7.454422,
      NULL,
      0,
      3.684299,
      NULL,
      2,
      0,
      1,
      1.740395,
      1,
      NULL,
      1.705237,
      NULL,
      NULL,
      1.772671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.128209,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687000,
      1.686906,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.473004,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497420,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.259977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.624779,
      0,
      0.569464,
      2.982032,
      44.360188,
      0.039419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685003,
      NULL,
      NULL,
      NULL,
      6552.745039,
      NULL,
      0.271504,
      NULL,
      1,
      1.573169,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.410492,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.951909,
      NULL,
      0.197193,
      NULL,
      131,
      NULL,
      0.056219,
      NULL,
      NULL,
      NULL,
      1,
      0.684000,
      NULL,
      1,
      NULL,
      0.083332,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.379927,
      NULL,
      NULL,
      NULL,
      1.995719,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.866374,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.942351,
      1.759951,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114036,
      1.723541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.513840,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.205013,
      NULL,
      NULL,
      NULL,
      1.410705,
      NULL,
      1.719784,
      NULL,
      0.258612,
      2,
      NULL,
      3.240979,
      NULL,
      400.149385,
      NULL,
      NULL,
      NULL,
      0.843613,
      NULL,
      0.730304,
      NULL,
      1.923629,
      NULL,
      0.497670,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.886078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.318893,
      1.539925,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.672111,
      1.507339,
      1.522777,
      NULL,
      1.006879,
      1,
      3,
      1.455701,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      3,
      3,
      2,
      11.110767,
      1,
      NULL,
      5.153950,
      1,
      1,
      0,
      NULL,
      1.422334,
      1.929152,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.033250,
      NULL,
      1,
      1,
      NULL,
      1.146639,
      0.778169,
      NULL,
      0.013546,
      NULL,
      NULL,
      NULL,
      1.371610,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874380,
      1,
      NULL,
      1.228075,
      3.894499,
      NULL,
      1.981782,
      0,
      NULL,
      1,
      0,
      0.697838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615364,
      NULL,
      0.922593,
      NULL,
      1.882979,
      NULL,
      NULL,
      3,
      6,
      2.572399,
      1,
      NULL,
      29,
      32,
      NULL,
      0.659849,
      5.511466,
      NULL,
      '12321',
      '01022',
      0,
      '',
      '',
      '',
      0.287802,
      '3221',
      NULL,
      '');
commit;
end;
/


