set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8234168';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      6,
      NULL,
      4.259531,
      5,
      0,
      NULL,
      NULL,
      1,
      '302',
      '23300122',
      28.945745,
      49,
      NULL,
      1.104569,
      1,
      NULL,
      2,
      '0113',
      0,
      0.462931,
      NULL,
      NULL,
      ' 2-15-1992',
      100,
      139.886787,
      NULL,
      1.303261,
      0.988753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 6-24-1986',
      2.460096,
      1,
      3.102955,
      3.485854,
      1,
      1.151702,
      5,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      1,
      1.928595,
      1,
      1,
      0,
      1.077057,
      0.353456,
      NULL,
      1,
      NULL,
      4,
      2,
      2.800341,
      4,
      0,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      0,
      8.042482,
      1,
      0,
      1,
      NULL,
      0.189562,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      2,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1.675787,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      4,
      1,
      5,
      1,
      0,
      4,
      NULL,
      NULL,
      1,
      NULL,
      1.653143,
      0,
      ' 7-23-1995',
      1881.118505,
      ' 9-15-1981',
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.170363,
      NULL,
      3,
      1.630433,
      0,
      0,
      NULL,
      1,
      NULL,
      0.597518,
      NULL,
      1.801958,
      NULL,
      NULL,
      NULL,
      0.733720,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.507259,
      0.188402,
      0,
      0.638424,
      1,
      0.689024,
      NULL,
      1.623830,
      NULL,
      3.277587,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.225317,
      0.204850,
      1,
      3,
      NULL,
      0,
      1,
      0,
      3,
      NULL,
      2,
      1,
      3.922480,
      2.829117,
      0,
      NULL,
      NULL,
      NULL,
      2.248100,
      0.832303,
      0,
      1,
      NULL,
      1,
      NULL,
      0.602752,
      0,
      NULL,
      3.008374,
      5.675631,
      NULL,
      2.226882,
      9.682572,
      2.694261,
      5.518695,
      0.597361,
      NULL,
      0,
      NULL,
      5.323308,
      NULL,
      3,
      1.002020,
      67.471668,
      2,
      NULL,
      41,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3.252500,
      '43310',
      '',
      '',
      1.397330,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      5,
      118.642218,
      20.752130,
      3,
      27.373164,
      4,
      18.334350,
      3,
      2.971271,
      0,
      NULL,
      1.854539,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.179356,
      0,
      0.269943,
      NULL,
      NULL,
      NULL,
      2.983824,
      1,
      3.361240,
      1,
      NULL,
      0.116638,
      2.137654,
      NULL,
      1,
      3,
      3.350105,
      0,
      3,
      3,
      NULL,
      0.794638,
      1,
      1,
      1,
      NULL,
      NULL,
      4,
      2,
      2,
      0,
      0.515707,
      NULL,
      NULL,
      NULL,
      0.580862,
      0.491330,
      1.347500,
      NULL,
      0,
      NULL,
      NULL,
      0.990717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037373,
      NULL,
      NULL,
      0.954613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.813335,
      3.031368,
      NULL,
      2.766835,
      NULL,
      1.246844,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      3.586004,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697321,
      NULL,
      NULL,
      1.938161,
      NULL,
      NULL,
      0.971795,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.895014,
      NULL,
      NULL,
      0.230685,
      NULL,
      NULL,
      0.588656,
      NULL,
      NULL,
      0.563336,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.875098,
      1.903744,
      3.167745,
      1,
      2,
      0.501203,
      0,
      0,
      3.801577,
      NULL,
      6.545085,
      1.893712,
      2.857945,
      3,
      NULL,
      1,
      1,
      3.357517,
      1.206020,
      1.968187,
      1,
      3.364492,
      0.136017,
      2.964588,
      5,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      0.697240,
      0,
      0,
      0.326635,
      NULL,
      NULL,
      1.476606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070238,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.968670,
      3.667674,
      0,
      NULL,
      3.256675,
      1,
      NULL,
      NULL,
      81.415284,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.621478,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.622767,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.501107,
      0.896376,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.929524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808386,
      NULL,
      NULL,
      NULL,
      1.783959,
      0,
      NULL,
      NULL,
      1.741947,
      1,
      NULL,
      NULL,
      1,
      3.614539,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.972603,
      0,
      NULL,
      NULL,
      1.602593,
      1.237101,
      NULL,
      NULL,
      1.619948,
      5.232829,
      NULL,
      NULL,
      3,
      0.612808,
      NULL,
      NULL,
      NULL,
      0,
      8,
      4,
      1,
      2.216363,
      2.164631,
      0,
      5,
      1.100107,
      1,
      NULL,
      0,
      0.898162,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.102531,
      NULL,
      NULL,
      167.360661,
      32,
      0.852097,
      3,
      0,
      2,
      1,
      2.369058,
      0,
      3.987741,
      NULL,
      3.637860,
      0.560607,
      0,
      0,
      NULL,
      1,
      1.014144,
      NULL,
      1,
      NULL,
      0.172900,
      NULL,
      0.207211,
      NULL,
      3,
      NULL,
      3.255670,
      NULL,
      2,
      NULL,
      178.081647,
      NULL,
      5,
      22.915804,
      64.460030,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.193669,
      NULL,
      2,
      NULL,
      1.021693,
      NULL,
      2.238130,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0.309587,
      NULL,
      NULL,
      1.316700,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.732744,
      1,
      1.422348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277181,
      1,
      NULL,
      1.202386,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.114765,
      NULL,
      0.121900,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.648061,
      NULL,
      NULL,
      NULL,
      13.264970,
      NULL,
      1.195996,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      NULL,
      3,
      NULL,
      1.425396,
      NULL,
      67,
      NULL,
      0.750004,
      1.258681,
      0,
      NULL,
      0,
      NULL,
      1.564817,
      NULL,
      NULL,
      NULL,
      12.440208,
      1.948275,
      2.621613,
      NULL,
      1.954271,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.615608,
      NULL,
      NULL,
      NULL,
      0.006841,
      1.670793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      2,
      2,
      1,
      1.945984,
      3,
      NULL,
      1.431128,
      1.305526,
      NULL,
      NULL,
      1.280855,
      0.221163,
      NULL,
      1.935600,
      2.308679,
      NULL,
      1.623737,
      0,
      NULL,
      3.199413,
      NULL,
      NULL,
      1,
      0.922638,
      NULL,
      1,
      3,
      NULL,
      0.829632,
      1,
      NULL,
      NULL,
      3.891323,
      NULL,
      0.220548,
      0,
      NULL,
      0,
      1.694313,
      NULL,
      1.465822,
      0,
      1.371092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      6,
      1,
      1.578028,
      NULL,
      NULL,
      29.284172,
      45.584665,
      NULL,
      3.948361,
      4,
      '10240',
      '40431',
      '',
      1,
      '',
      '',
      '',
      0.495498,
      '',
      '',
      NULL);
commit;
end;
/


