set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0322312',
      3,
      NULL,
      NULL,
      NULL,
      '3031',
      NULL,
      3,
      1.700891,
      2.705427,
      ' 2-14-2000',
      13,
      NULL,
      NULL,
      1,
      1.584013,
      ' 4-11-2003',
      30.200617,
      NULL,
      NULL,
      29.615657,
      5,
      NULL,
      NULL,
      ' 6-24-1981',
      2,
      1,
      NULL,
      NULL,
      0.987108,
      0.412755,
      2,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      20.342090,
      NULL,
      0,
      0.910419,
      3,
      1,
      2.887910,
      1,
      2,
      1,
      0.683331,
      NULL,
      1.258747,
      0.056993,
      0.517887,
      NULL,
      1.728354,
      0.200104,
      NULL,
      1,
      3,
      1.624229,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.698141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1.871056,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      2,
      1,
      0,
      3,
      0,
      0,
      1,
      5,
      1,
      1,
      1,
      0,
      NULL,
      1.460027,
      1.247794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.883758,
      0,
      0,
      1.641213,
      NULL,
      NULL,
      NULL,
      1.751833,
      0,
      0.183921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299290,
      1,
      NULL,
      0,
      1.066002,
      0.366415,
      NULL,
      NULL,
      1.525603,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.534602,
      3,
      NULL,
      1,
      1,
      1,
      2,
      1,
      1,
      1,
      NULL,
      0.738141,
      2.396213,
      1,
      3,
      NULL,
      1.723994,
      1.097226,
      1,
      1,
      0.566751,
      0,
      1,
      0.220504,
      NULL,
      0,
      0,
      NULL,
      3.132936,
      1.809986,
      NULL,
      5,
      2,
      2.907807,
      2.861204,
      5.498673,
      4,
      1.699863,
      0.287211,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.542492,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.554479,
      1.555640,
      '22140',
      NULL,
      '',
      0.640170,
      NULL,
      NULL,
      '',
      0.821314,
      '',
      '',
      '',
      3,
      NULL,
      55,
      17.412506,
      1,
      30.889498,
      2.009903,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.937962,
      1.205237,
      1,
      1.519476,
      1,
      2.151815,
      1,
      NULL,
      NULL,
      0.940532,
      0.470582,
      2,
      0,
      NULL,
      NULL,
      1,
      2.894789,
      2,
      0.388915,
      NULL,
      1,
      0.971149,
      NULL,
      NULL,
      0.098447,
      NULL,
      NULL,
      0.033266,
      1,
      2.282660,
      NULL,
      NULL,
      NULL,
      5.866406,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.091715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.068549,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.969771,
      0.880685,
      1.813205,
      NULL,
      NULL,
      NULL,
      0.624014,
      NULL,
      NULL,
      0,
      1.801137,
      0.955362,
      1,
      0.998989,
      NULL,
      NULL,
      NULL,
      0.265088,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.183606,
      3.557003,
      0.860689,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.412554,
      5,
      NULL,
      1.246970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.032963,
      0.103298,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.545467,
      3.899420,
      NULL,
      2,
      6,
      0.560232,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.638775,
      1.864701,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093863,
      1.465912,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.780937,
      NULL,
      NULL,
      NULL,
      0,
      1.748083,
      5,
      NULL,
      3.454278,
      0.234122,
      0,
      NULL,
      1.746403,
      1,
      3.807580,
      0,
      1.670929,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.112834,
      NULL,
      NULL,
      1.793190,
      NULL,
      NULL,
      1.907330,
      NULL,
      NULL,
      0.137089,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.821575,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.326741,
      NULL,
      NULL,
      7.990557,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053072,
      0.393824,
      0.723781,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      5.438638,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.016576,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.325666,
      NULL,
      NULL,
      NULL,
      1.423849,
      NULL,
      NULL,
      NULL,
      2.447559,
      NULL,
      NULL,
      NULL,
      1.338487,
      1,
      NULL,
      NULL,
      1.817016,
      1,
      NULL,
      NULL,
      1,
      0.104145,
      NULL,
      NULL,
      3,
      1.908970,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685006,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.499974,
      0.247056,
      0.576568,
      0,
      NULL,
      NULL,
      0.313693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.073769,
      5114,
      928.135152,
      NULL,
      1,
      0,
      1.997361,
      0,
      1,
      1.810084,
      NULL,
      NULL,
      0,
      0.576160,
      0,
      0,
      NULL,
      NULL,
      0,
      1.306565,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.610160,
      1.004812,
      NULL,
      1,
      1,
      3.156796,
      3.643663,
      2,
      NULL,
      0.084525,
      1.066376,
      1,
      1,
      NULL,
      1.679407,
      0.091132,
      1,
      0,
      2.762544,
      0,
      1,
      1.777115,
      0,
      0.786591,
      1,
      0,
      1.723975,
      1,
      NULL,
      NULL,
      1,
      0,
      0.076620,
      1,
      1.159929,
      1.401814,
      0.915010,
      1,
      1,
      0,
      1.678955,
      0,
      NULL,
      2,
      0.054079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.006520,
      NULL,
      0.160010,
      1.078827,
      1,
      5,
      0,
      0.344666,
      NULL,
      NULL,
      30.905450,
      89.513019,
      NULL,
      1,
      1.091174,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0.930922,
      '',
      NULL,
      NULL);
commit;
end;
/


