set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '0300012',
      2,
      0,
      5,
      NULL,
      '1032',
      NULL,
      3,
      3,
      1.538418,
      ' 9-18-1978',
      NULL,
      NULL,
      0,
      0,
      2.001244,
      NULL,
      0,
      NULL,
      297,
      31.945142,
      3,
      NULL,
      NULL,
      ' 9-27-1978',
      0,
      0,
      1.941393,
      2,
      1,
      NULL,
      2,
      1,
      NULL,
      18,
      3,
      8,
      0,
      6.221632,
      3,
      NULL,
      8.386144,
      2,
      2,
      2.197663,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      6,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.125802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.705690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.268935,
      NULL,
      0,
      3,
      1,
      0,
      4,
      0,
      NULL,
      1,
      1,
      0,
      0,
      5,
      1,
      NULL,
      1,
      4,
      NULL,
      2,
      2,
      0,
      NULL,
      0,
      5,
      2,
      0.884375,
      0.444924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459346,
      1.884711,
      1.745723,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.547727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.990542,
      0,
      0.406494,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      1.474002,
      3.842336,
      NULL,
      2.475704,
      1,
      NULL,
      3.482268,
      0,
      0.412149,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      0.488035,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      55,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      '23110',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      4.857854,
      NULL,
      31,
      1,
      30,
      7,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.816700,
      0.130639,
      1,
      0.490467,
      1.802801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.510001,
      1.495618,
      1.266774,
      NULL,
      NULL,
      0.289258,
      NULL,
      NULL,
      0,
      2.231188,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.738538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940025,
      NULL,
      NULL,
      0.219150,
      NULL,
      NULL,
      0.637332,
      NULL,
      NULL,
      1.057619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.220838,
      1.378370,
      0.458765,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      3.467725,
      NULL,
      1,
      NULL,
      0.168658,
      1,
      2,
      1.113039,
      1.924362,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753435,
      NULL,
      NULL,
      NULL,
      1.024575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.003595,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.686836,
      0,
      NULL,
      2.867323,
      2,
      1,
      5.085046,
      7.931415,
      2.489903,
      2,
      NULL,
      NULL,
      7.394695,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      0.273679,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      1.074789,
      1.494170,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      7.715221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197279,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.519995,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.433031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145100,
      1.094274,
      NULL,
      1,
      1.115201,
      2,
      3,
      NULL,
      NULL,
      0.168111,
      1.046999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.908073,
      NULL,
      NULL,
      0.615165,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.134761,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0.952243,
      NULL,
      NULL,
      1.899475,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.267759,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      1,
      6.807494,
      NULL,
      1.836004,
      NULL,
      NULL,
      NULL,
      3.138188,
      NULL,
      3,
      35,
      NULL,
      1.708145,
      NULL,
      NULL,
      0.176836,
      NULL,
      0,
      NULL,
      4.662737,
      1.899994,
      NULL,
      1,
      0.811027,
      1,
      1,
      1.024663,
      1,
      1.766256,
      NULL,
      1,
      0,
      0,
      NULL,
      0.543849,
      1.437929,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.553165,
      NULL,
      0.051793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737589,
      0.540373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038669,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398866,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037373,
      0,
      NULL,
      1.971538,
      NULL,
      1.259995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335378,
      NULL,
      0,
      1.204059,
      1.162748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      11,
      2,
      NULL,
      0.463728,
      2,
      3,
      2,
      1,
      3,
      1.567439,
      1.963896,
      1,
      NULL,
      1,
      0,
      1.210562,
      1.952981,
      0.746465,
      1.843848,
      1,
      NULL,
      1.991783,
      0,
      1.051020,
      1.770589,
      1.683873,
      0,
      1,
      0.269218,
      1,
      1,
      1,
      NULL,
      2.033945,
      3,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      0.159197,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.894369,
      1.137099,
      NULL,
      0,
      3,
      0,
      NULL,
      1.527637,
      NULL,
      NULL,
      73.466986,
      9,
      NULL,
      1.952027,
      1.607135,
      '02102',
      NULL,
      '',
      0.980328,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '');
commit;
end;
/


