set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '1441130',
      2,
      NULL,
      3,
      0,
      '3200',
      1.372012,
      3,
      0,
      2.794721,
      ' 6-20-2002',
      30,
      NULL,
      NULL,
      0.824193,
      0,
      ' 6-23-1980',
      NULL,
      1,
      296,
      95.656836,
      5,
      NULL,
      NULL,
      NULL,
      2.985380,
      NULL,
      0.881594,
      0.929288,
      0.598468,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      12.478891,
      3,
      37,
      21,
      1,
      NULL,
      3,
      1,
      5.366372,
      0.124437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.684009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.058107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1.371043,
      NULL,
      0,
      2,
      1,
      0,
      2,
      0,
      2,
      0,
      0,
      4,
      0,
      1,
      0,
      5,
      0,
      1,
      2,
      2,
      NULL,
      2,
      5,
      1,
      4,
      5,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0.933194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9,
      0.083115,
      NULL,
      2,
      0.347576,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0.756564,
      NULL,
      NULL,
      NULL,
      NULL,
      0.872844,
      1.966950,
      5,
      1.958768,
      5.805065,
      1,
      NULL,
      NULL,
      NULL,
      0.295030,
      3.688842,
      1.109478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.293105,
      0.720995,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      1,
      3,
      0,
      1,
      1,
      3,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.338973,
      1,
      0,
      3.457288,
      0.305627,
      1,
      1.879439,
      1,
      0.473002,
      0.233429,
      0.671002,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.497080,
      8.427341,
      NULL,
      3,
      1,
      4.854073,
      3.824628,
      0.022357,
      NULL,
      52,
      3,
      0,
      58,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      '14223',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      2.509195,
      36.833364,
      5.520993,
      23.243490,
      2,
      46.410171,
      13.179980,
      10,
      4,
      2,
      1,
      1,
      0.800338,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.165500,
      3.870961,
      1.127104,
      NULL,
      1.096309,
      NULL,
      0,
      NULL,
      NULL,
      1.314164,
      0.245571,
      17.079974,
      0,
      NULL,
      NULL,
      0.800991,
      NULL,
      NULL,
      0.388134,
      NULL,
      NULL,
      0,
      1,
      1.644104,
      0.141066,
      NULL,
      NULL,
      8.540790,
      5,
      1.682423,
      0,
      2,
      0,
      0,
      1.811689,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.221937,
      NULL,
      NULL,
      0.623895,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.535688,
      1.298123,
      NULL,
      NULL,
      1.809473,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      3.660673,
      2,
      2.263476,
      1,
      0.201717,
      1.634489,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.253619,
      1,
      0.717590,
      1,
      0.748118,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.606917,
      1.862189,
      NULL,
      NULL,
      1,
      1,
      0.696106,
      6.648722,
      2,
      0,
      NULL,
      1.450303,
      1.455759,
      0,
      NULL,
      NULL,
      0.034346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.191437,
      NULL,
      NULL,
      5,
      2.924386,
      1,
      0.905529,
      NULL,
      NULL,
      0,
      1.525214,
      0.108563,
      0.955766,
      NULL,
      1.390350,
      0.108576,
      0.152568,
      1.536767,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.560845,
      NULL,
      NULL,
      NULL,
      0.749084,
      0,
      14.209677,
      11,
      5,
      1,
      1,
      1,
      5.984805,
      3.311218,
      3.088623,
      1,
      0,
      0.402261,
      0.872937,
      3.571710,
      3.161459,
      0.523374,
      NULL,
      4.596886,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.636845,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335224,
      3,
      NULL,
      NULL,
      3,
      NULL,
      1.748086,
      3,
      NULL,
      0,
      2.787069,
      NULL,
      0,
      1.092395,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      24,
      NULL,
      2.678236,
      3,
      1,
      1,
      1.717569,
      0,
      3.284528,
      5.692204,
      NULL,
      NULL,
      1,
      54,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.945149,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.801364,
      0.851888,
      NULL,
      NULL,
      NULL,
      1.588170,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.390045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.292181,
      NULL,
      NULL,
      0.421435,
      1.021503,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.163875,
      9.841740,
      NULL,
      NULL,
      NULL,
      123,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      75.229030,
      NULL,
      NULL,
      2,
      NULL,
      0.263259,
      NULL,
      NULL,
      1.675739,
      3.476600,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154971,
      NULL,
      NULL,
      1.370579,
      NULL,
      0.397243,
      NULL,
      419,
      0.839795,
      1,
      1.101924,
      0.927550,
      0.183975,
      1.569644,
      1,
      NULL,
      0.031907,
      0.814301,
      0,
      1.696651,
      1.859648,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492085,
      0,
      0.718602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386853,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139968,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945717,
      1.017424,
      NULL,
      1.673314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121857,
      NULL,
      0,
      NULL,
      0,
      1.433425,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.536895,
      NULL,
      1,
      0,
      3,
      NULL,
      3.216571,
      0.483737,
      2,
      NULL,
      1,
      0,
      1.371574,
      NULL,
      0,
      0.024309,
      1,
      0.455524,
      1,
      1.606718,
      NULL,
      NULL,
      0,
      0.551790,
      0.152629,
      0,
      0,
      1.995620,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0.580064,
      NULL,
      0,
      2.877096,
      0.817649,
      0.114641,
      1,
      3.976976,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.198593,
      1.995449,
      1,
      1,
      1,
      4,
      NULL,
      5,
      1,
      NULL,
      NULL,
      76,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0.367977,
      NULL,
      '',
      '');
commit;
end;
/


