set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '2110203',
      5,
      NULL,
      5,
      3,
      '4220',
      1,
      3,
      0.618675,
      NULL,
      ' 7-11-1990',
      1,
      NULL,
      0,
      1,
      NULL,
      '11- 1-1987',
      NULL,
      0,
      325,
      52.966440,
      NULL,
      NULL,
      NULL,
      ' 0- 3-2001',
      0.451299,
      0.942206,
      NULL,
      1.701161,
      0,
      NULL,
      1,
      NULL,
      0.289271,
      1,
      0,
      10.910644,
      0.338314,
      15,
      NULL,
      NULL,
      NULL,
      3,
      0,
      4.040954,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0.686744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.752178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.039230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0.117658,
      0,
      0,
      1,
      NULL,
      0.209384,
      NULL,
      NULL,
      3,
      0,
      1,
      3,
      0,
      3,
      NULL,
      0,
      NULL,
      1,
      1,
      3,
      4,
      0,
      1,
      1,
      3,
      NULL,
      2,
      NULL,
      3,
      0,
      4,
      NULL,
      NULL,
      2,
      0.229140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.336062,
      3.825481,
      0.203503,
      1,
      0,
      0.335433,
      1.015026,
      1.834745,
      3.248781,
      3,
      0,
      1.109281,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.211045,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515231,
      0.600851,
      1,
      0.819967,
      2,
      1.927199,
      0.539414,
      1,
      NULL,
      1,
      1.389340,
      NULL,
      NULL,
      NULL,
      3,
      0.774175,
      0.371884,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3.372682,
      0.233315,
      NULL,
      1.545754,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0.986501,
      1.394795,
      1.333881,
      0.906593,
      1,
      3.282760,
      1.744955,
      1.379308,
      4.126539,
      7.113423,
      4.911349,
      NULL,
      0.472350,
      NULL,
      NULL,
      1.496717,
      6.020705,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      29,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.935861,
      '03222',
      '',
      '',
      0.933132,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      192.091574,
      38.469268,
      1.439161,
      3.480163,
      12,
      NULL,
      1,
      3,
      2.056319,
      0.697087,
      1.055271,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.757454,
      1,
      NULL,
      NULL,
      0,
      1.703883,
      NULL,
      NULL,
      0.963558,
      18,
      8,
      1.592414,
      2.559474,
      NULL,
      1.242879,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1.863498,
      NULL,
      NULL,
      7,
      2.751032,
      0.346922,
      1,
      0.761855,
      NULL,
      NULL,
      NULL,
      0.821595,
      NULL,
      NULL,
      NULL,
      1.098653,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.129617,
      NULL,
      1.055823,
      1,
      NULL,
      NULL,
      0.387013,
      NULL,
      NULL,
      1.926724,
      1,
      1.497015,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.991440,
      0,
      NULL,
      1.574657,
      0,
      1.050158,
      3,
      NULL,
      NULL,
      0.518831,
      5,
      1,
      NULL,
      0,
      0,
      3,
      3.128360,
      1,
      NULL,
      4.147761,
      NULL,
      0,
      0,
      0.112572,
      2.712737,
      NULL,
      1,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      2,
      0.082247,
      0.697564,
      0.019827,
      NULL,
      NULL,
      1.356470,
      NULL,
      NULL,
      1.728582,
      3.359406,
      1,
      3.456801,
      NULL,
      4,
      0,
      NULL,
      NULL,
      3,
      1.987758,
      1.794749,
      1,
      2.324760,
      2,
      NULL,
      1.128762,
      0.583453,
      NULL,
      NULL,
      6.205291,
      0,
      1.936931,
      0.474273,
      1.709469,
      NULL,
      1.795942,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      6,
      6,
      5.614696,
      3,
      2.776601,
      3.339523,
      0.736059,
      3,
      4,
      0.412902,
      1,
      NULL,
      0.635387,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      88,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.891144,
      NULL,
      NULL,
      1.085292,
      NULL,
      NULL,
      1.131125,
      NULL,
      NULL,
      0.770682,
      NULL,
      NULL,
      3.906825,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.457450,
      NULL,
      NULL,
      3.995768,
      NULL,
      NULL,
      1.235069,
      NULL,
      NULL,
      3.047272,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.367244,
      0,
      0.746881,
      0.033884,
      1.183839,
      3.855884,
      1,
      NULL,
      NULL,
      3.465613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122840,
      1,
      NULL,
      NULL,
      0.843485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795265,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.365842,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.036692,
      0.924462,
      NULL,
      NULL,
      3,
      0.916368,
      NULL,
      NULL,
      0.725616,
      NULL,
      NULL,
      NULL,
      1.579285,
      0,
      NULL,
      NULL,
      0.960941,
      NULL,
      NULL,
      NULL,
      8.405815,
      1.910975,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      95,
      0.326290,
      3.237485,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      2.212672,
      NULL,
      1.881137,
      0,
      NULL,
      17,
      0.840177,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761910,
      351,
      731.510758,
      1.450141,
      1,
      1.205623,
      0,
      1,
      0.625089,
      0.610826,
      0,
      0,
      1,
      0.710284,
      0,
      0.941923,
      0,
      0.050329,
      NULL,
      1.930181,
      0.769078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.011517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168503,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526716,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.231183,
      3,
      NULL,
      NULL,
      NULL,
      2.319532,
      2.967025,
      1.992143,
      0,
      0.983582,
      0.571381,
      NULL,
      2.502753,
      0,
      0,
      NULL,
      1,
      0.464028,
      1,
      1.363652,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0.573436,
      0,
      0.614266,
      NULL,
      0,
      NULL,
      1.781663,
      0.550122,
      0.346392,
      0,
      NULL,
      1,
      0.293086,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.031326,
      1,
      NULL,
      0.358219,
      1,
      6,
      2,
      0.265015,
      NULL,
      NULL,
      86,
      94,
      1,
      1.656814,
      3,
      '31011',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


