set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648302';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12',
      '20',
      15,
      13.725954,
      '2332111',
      3.730172,
      1.367011,
      3,
      0,
      '0111',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      197.526601,
      7,
      NULL,
      1.919586,
      0,
      ' 7-29-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 5-1981',
      0.735587,
      1,
      3,
      0.511584,
      1.104874,
      NULL,
      3,
      1,
      0.499115,
      38.989594,
      5,
      13.299545,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1.460036,
      NULL,
      1,
      1.470669,
      0.705221,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      0,
      4,
      2,
      1,
      0,
      0,
      3.876948,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1.344974,
      NULL,
      0.686165,
      1,
      1,
      3,
      1,
      NULL,
      1,
      4,
      1,
      0,
      0,
      1,
      NULL,
      5,
      0,
      1,
      4,
      NULL,
      NULL,
      1,
      0,
      NULL,
      5,
      5,
      NULL,
      0,
      0,
      1,
      '11- 4-2001',
      NULL,
      ' 1-17-1990',
      209.958061,
      0.809335,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      1,
      0,
      0,
      5,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4,
      0,
      NULL,
      0,
      0,
      NULL,
      0.595197,
      0,
      4.677581,
      NULL,
      0,
      NULL,
      0,
      3,
      2.916661,
      0,
      0.401324,
      6,
      5,
      0.988845,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.042448,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143149,
      NULL,
      0.959632,
      0,
      1,
      NULL,
      1,
      0.489866,
      NULL,
      0.823553,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      0,
      0,
      3,
      0,
      1,
      NULL,
      2,
      3.249807,
      2.908479,
      0.545999,
      NULL,
      0.342625,
      NULL,
      3,
      1.599591,
      1.299469,
      2.279590,
      0.487972,
      0.584303,
      0.480288,
      0,
      0,
      1,
      1,
      3.636985,
      1,
      1,
      7.046285,
      5,
      10.475670,
      6.375992,
      1.413806,
      2,
      2,
      1.905588,
      3,
      3,
      3,
      23.613133,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.351588,
      NULL,
      '',
      '',
      1.827431,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1.125743,
      54.593571,
      112,
      48,
      3,
      71,
      3,
      1,
      1,
      0.045887,
      1.215997,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.981882,
      0,
      0.577108,
      0.771988,
      NULL,
      NULL,
      1.627122,
      NULL,
      NULL,
      3.678964,
      1.062397,
      1,
      2.200428,
      NULL,
      NULL,
      3,
      0.995223,
      0,
      1.311718,
      NULL,
      NULL,
      1.545236,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      1.959859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.127561,
      1.781562,
      1,
      1.173760,
      NULL,
      1.168187,
      NULL,
      NULL,
      0.212641,
      NULL,
      NULL,
      3,
      0.852181,
      0,
      NULL,
      3.468810,
      1.618948,
      3,
      0,
      1.692043,
      0,
      0,
      NULL,
      1.049079,
      1,
      1,
      0.180677,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235321,
      0,
      NULL,
      1.542540,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.615576,
      NULL,
      NULL,
      0.264740,
      NULL,
      NULL,
      0.728615,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.194992,
      NULL,
      NULL,
      1.399831,
      NULL,
      NULL,
      1.311503,
      NULL,
      NULL,
      2.757640,
      NULL,
      2.283943,
      1.651606,
      NULL,
      NULL,
      0,
      1.697127,
      0.066328,
      2.136502,
      1,
      0,
      2.319405,
      0,
      0.090310,
      5.972408,
      1.394238,
      NULL,
      0,
      NULL,
      2,
      3.689353,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      2,
      0,
      2.081843,
      3,
      5,
      4,
      0.863031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833222,
      1.845870,
      1,
      1.837163,
      0,
      NULL,
      NULL,
      1.245667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566452,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.308087,
      NULL,
      NULL,
      0.194745,
      NULL,
      NULL,
      1.811606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.481278,
      1.830879,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.585383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.984156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885046,
      1.035953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.124285,
      0.501333,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.164792,
      0.667547,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      7,
      5,
      NULL,
      NULL,
      2,
      1,
      NULL,
      5,
      1,
      1.893344,
      NULL,
      NULL,
      1.666479,
      0,
      535,
      0.559677,
      NULL,
      NULL,
      2,
      2.858801,
      396,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7288,
      1.426728,
      1.015728,
      0,
      1.408907,
      1,
      NULL,
      0,
      0,
      0.646639,
      0.967639,
      0.621037,
      1,
      1.013412,
      0,
      1.927580,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      5.809465,
      4.978683,
      7,
      NULL,
      1,
      1,
      1.614484,
      2.511453,
      0,
      NULL,
      2.613117,
      NULL,
      1.589492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355368,
      1,
      NULL,
      NULL,
      0.885885,
      NULL,
      1.219198,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.237127,
      NULL,
      2,
      1.230921,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.707799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.768322,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.960075,
      NULL,
      0.032886,
      NULL,
      2,
      NULL,
      1.776417,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.211459,
      NULL,
      1.480122,
      NULL,
      0.378638,
      NULL,
      52,
      1.192166,
      NULL,
      1.449983,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      1,
      0,
      1,
      63,
      NULL,
      2,
      4,
      2.157594,
      '23144',
      '0112',
      '',
      1,
      '',
      '',
      '',
      1.298366,
      '',
      '',
      '');
commit;
end;
/


