set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9813582';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.306516,
      3.393905,
      NULL,
      NULL,
      5,
      1,
      0,
      2,
      NULL,
      '41012103',
      67,
      73.591302,
      '0441024',
      0.033768,
      1.561006,
      2,
      1,
      '2310',
      4.580568,
      0.127549,
      NULL,
      NULL,
      ' 9-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 9- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-10-1986',
      NULL,
      NULL,
      2.033269,
      NULL,
      1,
      1.872362,
      1.965727,
      3.684262,
      0,
      NULL,
      1,
      NULL,
      8,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.788120,
      1,
      1,
      1.312381,
      1,
      1.779879,
      0,
      1.075661,
      1,
      2,
      NULL,
      0,
      1,
      5,
      2,
      2,
      0,
      1,
      1,
      0,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1.736857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.777034,
      0.773426,
      NULL,
      1,
      NULL,
      1.599137,
      1.115381,
      1,
      NULL,
      NULL,
      1,
      2,
      3,
      2,
      0.805635,
      1.626775,
      1,
      0,
      1,
      0,
      2.859031,
      0,
      1,
      5.282770,
      0.839299,
      NULL,
      NULL,
      1.634693,
      NULL,
      NULL,
      4,
      0,
      5,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      5,
      0,
      1,
      4,
      0,
      3,
      2,
      5,
      0,
      3,
      1,
      NULL,
      5,
      1,
      NULL,
      3,
      5,
      5,
      NULL,
      2,
      4,
      0,
      5,
      1,
      ' 2- 9-1985',
      NULL,
      ' 6- 7-1982',
      NULL,
      1.183091,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986187,
      2.287529,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532631,
      0,
      5.542171,
      1.327837,
      1.619483,
      3,
      0.689303,
      NULL,
      NULL,
      NULL,
      0.332787,
      3.819634,
      0.423674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877052,
      NULL,
      0,
      1.403099,
      0.605149,
      0.197828,
      0.773962,
      0.370089,
      3.314679,
      0,
      0.223488,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773033,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      NULL,
      1,
      2,
      3,
      2,
      2,
      2,
      1,
      0.226435,
      0,
      NULL,
      1.941917,
      NULL,
      0.507693,
      0.457180,
      0,
      0,
      NULL,
      1,
      1.228127,
      1,
      NULL,
      0,
      1,
      5.875981,
      10,
      1,
      2.756827,
      0,
      1,
      1.075698,
      1,
      7.002490,
      3.553991,
      1.707896,
      3,
      NULL,
      3,
      0,
      42,
      NULL,
      39,
      NULL,
      0,
      0.238412,
      NULL,
      '43123',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.901153,
      '',
      '',
      '',
      1.417770,
      10,
      NULL,
      NULL,
      1,
      37,
      0.883851,
      0.295672,
      1,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.233615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649922,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.050277,
      NULL,
      NULL,
      0.867960,
      NULL,
      NULL,
      1.888064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892496,
      0.489846,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.667293,
      NULL,
      NULL,
      NULL,
      1.197874,
      NULL,
      NULL,
      NULL,
      0.311637,
      NULL,
      1.190218,
      1,
      1.476372,
      1.126039,
      NULL,
      1.536460,
      3.144249,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      2,
      2.817944,
      NULL,
      3.281529,
      0.568287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.732032,
      1.796101,
      2.036456,
      1,
      1.971127,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.836302,
      NULL,
      NULL,
      NULL,
      3.578478,
      1.172444,
      2.067849,
      3.977255,
      NULL,
      NULL,
      1.030285,
      1,
      2.010785,
      0,
      NULL,
      NULL,
      0,
      5.740429,
      3.864915,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315814,
      NULL,
      NULL,
      1.974429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709525,
      NULL,
      NULL,
      0.268387,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.153474,
      NULL,
      NULL,
      NULL,
      NULL,
      2.767517,
      1,
      NULL,
      NULL,
      1.834365,
      0,
      8,
      5.537804,
      5,
      2.857781,
      0,
      NULL,
      NULL,
      3,
      0,
      3.947031,
      2,
      3,
      0.661750,
      0.228596,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      3.566600,
      1.042004,
      NULL,
      3.707706,
      1,
      2.386590,
      NULL,
      NULL,
      3.501857,
      3,
      0.305689,
      0.668634,
      NULL,
      1,
      NULL,
      4,
      5,
      1.173066,
      0,
      NULL,
      0,
      1,
      0,
      1.049202,
      0,
      2.789030,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.828204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329999,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      0.836141,
      1.413325,
      2.064897,
      0.618052,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      149,
      NULL,
      NULL,
      NULL,
      3.418782,
      NULL,
      NULL,
      NULL,
      0.906627,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.301554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.709298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.757178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647145,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      3,
      0.477822,
      19.212725,
      12.635561,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.130595,
      NULL,
      0,
      NULL,
      21.639491,
      NULL,
      1.708447,
      0,
      0,
      NULL,
      1,
      1.155357,
      1.272887,
      1.387370,
      0,
      NULL,
      0.169798,
      1.370687,
      NULL,
      NULL,
      0.019237,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1.022408,
      3,
      0,
      2,
      1,
      1.066881,
      2,
      1,
      0,
      3.741895,
      3.754298,
      NULL,
      0,
      1.209197,
      NULL,
      0.220215,
      2.801345,
      NULL,
      NULL,
      0.985949,
      NULL,
      0.986669,
      0.729794,
      NULL,
      1.802448,
      0.073872,
      NULL,
      NULL,
      2,
      NULL,
      1.976878,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      1.012951,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.654698,
      NULL,
      1.429681,
      NULL,
      1,
      5,
      NULL,
      1,
      NULL,
      NULL,
      30,
      NULL,
      4,
      2.368025,
      NULL,
      '14140',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


