set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835115';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      '1443',
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      '11-29-2001',
      59.370724,
      2,
      NULL,
      NULL,
      2,
      ' 8-22-1998',
      NULL,
      ' 5-12-1978',
      NULL,
      0.842397,
      0,
      NULL,
      1.301465,
      0.613206,
      3,
      0,
      0.901130,
      NULL,
      6,
      1.370481,
      4.210399,
      118.016802,
      NULL,
      4,
      21.026784,
      0,
      0,
      10,
      0,
      0,
      1,
      1,
      NULL,
      0.699041,
      0,
      1.263506,
      1,
      1.964421,
      165.880329,
      5,
      5,
      6,
      NULL,
      2,
      NULL,
      0,
      0,
      3,
      NULL,
      3,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0,
      2,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      3.558584,
      NULL,
      0,
      1,
      1.932074,
      0,
      NULL,
      0.365113,
      0,
      0.161370,
      0.799670,
      1.299785,
      1.785261,
      0.469917,
      1,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      1.497081,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0,
      0,
      NULL,
      2,
      3.364524,
      0,
      2,
      2,
      NULL,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      4,
      NULL,
      0,
      2,
      4,
      5,
      4,
      0,
      0,
      1,
      5,
      1,
      1,
      NULL,
      0,
      2,
      4.750252,
      2.941066,
      ' 3-23-1990',
      999,
      ' 5-16-1977',
      514,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      8,
      0,
      NULL,
      4,
      0.015749,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.614060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357260,
      NULL,
      1.123551,
      2.584427,
      1,
      1,
      0.272184,
      NULL,
      32.642131,
      1.331512,
      1.369749,
      184.349996,
      1236.062478,
      1563,
      NULL,
      0.299391,
      2.958294,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1.004508,
      NULL,
      3,
      50.884371,
      55.632474,
      31.239432,
      161.529292,
      NULL,
      91.349413,
      0.658726,
      1.056958,
      1,
      3,
      0.164455,
      1,
      1,
      0,
      1,
      NULL,
      11,
      6.724525,
      4,
      4.504067,
      3,
      NULL,
      1.165192,
      2,
      7.511949,
      0.188146,
      2,
      1.585375,
      44.751660,
      0,
      NULL,
      NULL,
      NULL,
      4,
      55.274897,
      1,
      1.174959,
      2,
      '03023',
      '',
      '',
      1.657350,
      '',
      '',
      NULL,
      3,
      '44034',
      '',
      '',
      1.892057,
      10,
      270.744225,
      25.100158,
      2,
      15.542751,
      12.285046,
      24,
      NULL,
      NULL,
      19.215989,
      NULL,
      1.598445,
      NULL,
      NULL,
      1.742802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.728329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.837033,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.417988,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.493359,
      NULL,
      3,
      NULL,
      3.065359,
      1.830592,
      NULL,
      0.375282,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0.393434,
      1,
      1.936592,
      1,
      1,
      NULL,
      NULL,
      0.246006,
      NULL,
      NULL,
      0.884312,
      NULL,
      10,
      11,
      NULL,
      2.028586,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.217028,
      8,
      NULL,
      3,
      1,
      0.402951,
      0,
      NULL,
      NULL,
      3,
      2.854868,
      NULL,
      0,
      12,
      4,
      1,
      NULL,
      NULL,
      6.106098,
      0,
      2.429160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.959306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.549844,
      NULL,
      10,
      1.488945,
      13.509030,
      1.070532,
      NULL,
      2,
      3,
      8.809395,
      7.823645,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.206610,
      3.987269,
      0.442248,
      0,
      NULL,
      3,
      NULL,
      NULL,
      6,
      7,
      1.027913,
      NULL,
      8.242187,
      5,
      3,
      3.067914,
      4,
      1.876753,
      NULL,
      NULL,
      NULL,
      10,
      0.316420,
      NULL,
      0.700139,
      NULL,
      NULL,
      0,
      3,
      2.440342,
      2,
      3,
      1.144449,
      1.136345,
      0.940472,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.631009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.392643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443393,
      NULL,
      NULL,
      0.118925,
      NULL,
      NULL,
      0.102050,
      NULL,
      NULL,
      0,
      1.081281,
      1,
      0,
      0.618242,
      2.980452,
      3,
      NULL,
      NULL,
      0.997218,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.736524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371223,
      1.116541,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      2.853828,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.664483,
      0.403926,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      1.296141,
      NULL,
      NULL,
      2.894870,
      4.901382,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.294131,
      73.118619,
      71.019481,
      NULL,
      24,
      0.578892,
      0,
      NULL,
      NULL,
      3.530319,
      14,
      2,
      NULL,
      NULL,
      NULL,
      1.461200,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065583,
      NULL,
      46.329158,
      0,
      NULL,
      0.783639,
      NULL,
      1,
      0,
      1.156030,
      NULL,
      NULL,
      1,
      0.732691,
      1.622686,
      NULL,
      0.764844,
      0,
      NULL,
      0.380180,
      1.606691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.448991,
      3.182665,
      0,
      NULL,
      3,
      5,
      1.558227,
      NULL,
      3,
      14,
      17,
      0.174005,
      1,
      12.387641,
      0,
      5.007693,
      NULL,
      1.443938,
      11,
      5.213560,
      0.777305,
      0.158497,
      8.694298,
      0.361765,
      NULL,
      NULL,
      0.784143,
      9.729886,
      14.997002,
      0,
      NULL,
      19.996864,
      0.192802,
      6,
      6,
      0,
      NULL,
      9.987263,
      0,
      1.558736,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933624,
      1,
      0.259375,
      1.362478,
      1.386842,
      3,
      5,
      5,
      0.755342,
      0.811765,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      '33141',
      '',
      '',
      1,
      '',
      '',
      '',
      3.273280,
      '10204',
      '',
      '');
commit;
end;
/


