set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734866';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '2220',
      1,
      1,
      NULL,
      NULL,
      ' 7-14-1994',
      NULL,
      NULL,
      1,
      0,
      0,
      ' 2-15-1979',
      NULL,
      1,
      84,
      NULL,
      3,
      ' 7-27-1985',
      ' 9-20-1983',
      ' 6-12-1986',
      0.516178,
      1,
      0.433759,
      0.500505,
      1,
      NULL,
      1,
      1,
      0.322217,
      NULL,
      6,
      2,
      5,
      12.433400,
      11.046036,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.610354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2.004533,
      2,
      1,
      1,
      0,
      1,
      NULL,
      2,
      0,
      NULL,
      2,
      3,
      5,
      NULL,
      0,
      NULL,
      1,
      0,
      0.337500,
      NULL,
      NULL,
      0.822093,
      NULL,
      NULL,
      4,
      NULL,
      6,
      3.086389,
      NULL,
      0.507084,
      0,
      1.494055,
      1,
      1,
      1,
      1,
      1,
      1.536883,
      2,
      1,
      3,
      NULL,
      3.896626,
      4,
      3,
      0,
      6,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.071696,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      5,
      NULL,
      0,
      NULL,
      1,
      0,
      5,
      1,
      5.083722,
      NULL,
      NULL,
      NULL,
      0,
      0.510550,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1,
      3,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      4,
      3,
      1,
      4,
      NULL,
      0,
      4,
      5,
      1,
      NULL,
      5,
      NULL,
      3,
      7.325723,
      1,
      ' 3-23-1995',
      859.297934,
      NULL,
      97.239343,
      0.202431,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.960081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971242,
      0,
      6,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.643289,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299116,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.041390,
      NULL,
      23,
      3.333082,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      3,
      1,
      1,
      3,
      1,
      1,
      3,
      1,
      NULL,
      0,
      0,
      1.224364,
      NULL,
      3.959519,
      0.445066,
      1.459274,
      0,
      0.874459,
      1,
      1.765304,
      1,
      0,
      0,
      1,
      0.441153,
      NULL,
      0,
      3.569329,
      1.987510,
      NULL,
      NULL,
      7,
      0.795215,
      8,
      3,
      4.707633,
      2,
      4,
      NULL,
      1.473785,
      3.916107,
      NULL,
      3,
      1.268861,
      NULL,
      1,
      37,
      65,
      NULL,
      5.868146,
      NULL,
      '31304',
      '',
      '',
      1.493404,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.794131,
      36,
      31.508703,
      7,
      3.812644,
      6,
      0.381318,
      2,
      5,
      2.563227,
      0,
      2.838389,
      0.291621,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.978016,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      0.149713,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      1,
      0.917893,
      NULL,
      1,
      NULL,
      2,
      0,
      1.735556,
      5.009768,
      5,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.625874,
      NULL,
      NULL,
      NULL,
      0,
      0.530366,
      1,
      3,
      NULL,
      2,
      NULL,
      1,
      3,
      0,
      1,
      0,
      3.101963,
      NULL,
      0,
      2,
      2.342946,
      1,
      1.016523,
      NULL,
      0.163719,
      NULL,
      0.514810,
      3.291398,
      1,
      3.852800,
      1,
      0.987930,
      1,
      0.726168,
      NULL,
      0.628982,
      NULL,
      NULL,
      0.852233,
      NULL,
      7,
      1,
      0.945731,
      NULL,
      NULL,
      NULL,
      0.459746,
      NULL,
      NULL,
      NULL,
      0.203303,
      NULL,
      NULL,
      0.468255,
      NULL,
      NULL,
      1,
      1.577726,
      NULL,
      1.537137,
      NULL,
      NULL,
      4.968797,
      NULL,
      NULL,
      1,
      3.406614,
      0,
      3.803993,
      0,
      0,
      2.499601,
      NULL,
      NULL,
      0.890944,
      NULL,
      NULL,
      1.405372,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      0,
      0.529019,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      3.949187,
      1,
      1.649472,
      NULL,
      NULL,
      NULL,
      1,
      0.461112,
      2.195723,
      2.320859,
      3,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.441589,
      3.410800,
      0.603233,
      0,
      NULL,
      0,
      2,
      0,
      2.616713,
      0.072631,
      2.547635,
      NULL,
      0.615746,
      2.386555,
      4,
      2.142876,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.013306,
      1,
      1.918125,
      0.027623,
      NULL,
      2,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.846381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.276384,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.320431,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.038595,
      1.986910,
      1.956625,
      3.161378,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.455307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0.306614,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0.337337,
      NULL,
      NULL,
      4.261121,
      1,
      NULL,
      NULL,
      2.736306,
      1,
      1,
      3,
      1,
      NULL,
      49.423663,
      3.473759,
      62.133679,
      9.139076,
      1.559439,
      NULL,
      NULL,
      NULL,
      119,
      69,
      1,
      11.841089,
      41.545639,
      1,
      NULL,
      NULL,
      1.942916,
      NULL,
      0.939105,
      183,
      4,
      1.505194,
      1,
      0,
      0.263337,
      0,
      0,
      1.441116,
      0.604400,
      0,
      1,
      1.779675,
      0,
      1,
      0.914778,
      1.770047,
      1.007454,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.391016,
      0.757551,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007306,
      2,
      NULL,
      3.625043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.940949,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.898034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733969,
      2.954675,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      309.239494,
      NULL,
      0.544770,
      NULL,
      1,
      NULL,
      0,
      1,
      1.093368,
      NULL,
      NULL,
      0.640831,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      0.508496,
      NULL,
      1,
      1.700276,
      0.195789,
      0,
      0,
      1,
      1,
      0.963236,
      3,
      0.718833,
      1.303330,
      0,
      1,
      0.507393,
      NULL,
      1,
      0.728904,
      1,
      1.122120,
      NULL,
      3,
      0,
      0.537786,
      1,
      3,
      NULL,
      0,
      1.175718,
      1.070145,
      NULL,
      2,
      NULL,
      1,
      0.196838,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.288846,
      0.921194,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      54.069493,
      17.070750,
      0,
      0.815242,
      3,
      '43024',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


