set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5312661';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '0314211',
      2.771669,
      1,
      0,
      0,
      '1144',
      0,
      0,
      NULL,
      NULL,
      '11- 0-2003',
      36,
      NULL,
      0,
      1,
      0.445857,
      ' 4-10-1986',
      NULL,
      2,
      NULL,
      4.898444,
      3,
      ' 4-14-2002',
      ' 5- 6-1975',
      ' 8- 6-1974',
      NULL,
      0,
      0.823090,
      2.369626,
      1,
      NULL,
      2,
      1.534702,
      1,
      1,
      NULL,
      14.709361,
      5,
      0,
      NULL,
      NULL,
      32,
      NULL,
      3,
      4.472726,
      1.338292,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      6,
      5,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0.215351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.312185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      2,
      0,
      2,
      1,
      2,
      3,
      0,
      0,
      0,
      2,
      1,
      1,
      0,
      0,
      0.916786,
      NULL,
      0.391055,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      2,
      1,
      1,
      0,
      0,
      5,
      NULL,
      0,
      1.418955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      655,
      3,
      1.118414,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.633971,
      0.803748,
      0,
      3.757477,
      3.437531,
      4,
      3,
      NULL,
      NULL,
      NULL,
      2.492176,
      0.030645,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.969387,
      1.092417,
      0.600491,
      1,
      0,
      1,
      3.845589,
      130.455480,
      1.796588,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      0,
      3,
      2,
      3,
      2,
      1,
      3,
      1,
      2,
      0,
      0.042616,
      NULL,
      3,
      7.908792,
      NULL,
      1,
      0.303841,
      0,
      1.223143,
      4.217306,
      0,
      NULL,
      5,
      NULL,
      0,
      1,
      NULL,
      3.538391,
      1.323606,
      NULL,
      4.649131,
      2.333188,
      NULL,
      NULL,
      4,
      NULL,
      1.449752,
      0,
      0.184759,
      3.519730,
      1.754147,
      28.991455,
      2,
      NULL,
      35,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      '34411',
      '34011',
      0.698217,
      NULL,
      '',
      NULL,
      3.615892,
      '11040',
      NULL,
      '',
      NULL,
      37.254013,
      109,
      28,
      1.405916,
      NULL,
      11.672794,
      13,
      0,
      0.441242,
      NULL,
      NULL,
      1.431326,
      NULL,
      NULL,
      1.599767,
      NULL,
      NULL,
      1.676261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388073,
      NULL,
      NULL,
      1.752154,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588421,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.264713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.940264,
      NULL,
      NULL,
      0.797502,
      NULL,
      NULL,
      1.048572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.596338,
      1,
      2,
      1,
      NULL,
      2,
      0.102336,
      4.332482,
      1.670201,
      1,
      NULL,
      1.788506,
      3.134173,
      1,
      2.587972,
      0.066637,
      NULL,
      1.219371,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603721,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.291236,
      NULL,
      NULL,
      1.244715,
      NULL,
      NULL,
      1.242706,
      NULL,
      NULL,
      1.318331,
      NULL,
      NULL,
      3.205836,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.923959,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.047276,
      1.706248,
      1,
      0.658188,
      1.628334,
      1,
      1,
      2,
      1,
      2.506129,
      2,
      1,
      0,
      NULL,
      NULL,
      0.674594,
      0.484453,
      0.429959,
      0.775686,
      1.559068,
      0,
      4,
      3.524841,
      1.661294,
      5,
      0,
      5,
      1,
      NULL,
      NULL,
      1,
      1,
      1.264087,
      0.173094,
      0.834695,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.652762,
      3,
      2,
      1,
      1,
      NULL,
      2.625997,
      NULL,
      NULL,
      NULL,
      496.143045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143447,
      NULL,
      NULL,
      NULL,
      1.088839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.876161,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      2,
      NULL,
      9,
      0,
      1,
      NULL,
      NULL,
      0.014618,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.250713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      13.777671,
      0,
      430,
      NULL,
      1.893596,
      1,
      0,
      1.907940,
      NULL,
      0.198099,
      0.258302,
      0.892150,
      0,
      1,
      1.725565,
      0,
      1,
      0.073978,
      1.833627,
      1.564143,
      0,
      1.780432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      4.501876,
      0.002301,
      4,
      5,
      NULL,
      5,
      2.454985,
      1.549571,
      NULL,
      0.824111,
      NULL,
      NULL,
      0.893461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.108114,
      NULL,
      NULL,
      1.021873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.948097,
      NULL,
      0.422308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932040,
      NULL,
      0,
      4,
      6,
      0.602084,
      NULL,
      NULL,
      36,
      57.136800,
      1,
      1,
      3,
      '41422',
      '23143',
      '11211',
      0.825903,
      '',
      NULL,
      '',
      1,
      '11202',
      '',
      '');
commit;
end;
/


