set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9756071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.366985,
      NULL,
      3.586474,
      0,
      3.372882,
      2.498598,
      NULL,
      2,
      NULL,
      '31334442',
      31.573362,
      43,
      '3124110',
      2,
      0.565887,
      NULL,
      3,
      '1044',
      4.872896,
      0,
      NULL,
      NULL,
      ' 7- 4-1974',
      97.153517,
      44,
      NULL,
      0,
      NULL,
      ' 1-24-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-24-2003',
      ' 1-12-1984',
      NULL,
      1.559852,
      0.611281,
      NULL,
      NULL,
      0.699948,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.677541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      5,
      1.542546,
      1,
      1,
      0,
      4,
      0,
      4,
      1,
      1,
      2,
      0,
      2,
      NULL,
      4.956679,
      3,
      2,
      1,
      0,
      1.348065,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.195532,
      1.635892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.471062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0,
      4,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      5.127462,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      4,
      NULL,
      0,
      3,
      1,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      0,
      0.498177,
      NULL,
      ' 4- 6-1980',
      NULL,
      ' 4-15-1984',
      0,
      3,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      4.120069,
      1.793030,
      1.927556,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.164310,
      3.822009,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.620985,
      2,
      0.730839,
      1.423731,
      2.291448,
      3,
      NULL,
      0,
      NULL,
      1.665781,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.427105,
      0.821749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      8,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400548,
      NULL,
      NULL,
      1,
      2,
      2,
      2,
      1,
      2,
      2,
      NULL,
      1,
      NULL,
      1.812144,
      3,
      4,
      1,
      NULL,
      NULL,
      0.292508,
      NULL,
      NULL,
      0,
      NULL,
      0.716236,
      0,
      0,
      0,
      0,
      1.998433,
      NULL,
      11,
      NULL,
      NULL,
      7,
      5.386885,
      0,
      4,
      1,
      NULL,
      NULL,
      0.408216,
      3,
      39.068598,
      0,
      2.077387,
      44,
      NULL,
      46,
      13.914571,
      0,
      NULL,
      2.660062,
      '0111',
      '43201',
      '',
      1.936757,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0,
      35.610745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.704214,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.811767,
      1.487055,
      NULL,
      1.918407,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.021927,
      NULL,
      1.216391,
      1,
      1.123368,
      1.840522,
      0.119013,
      1.389917,
      0.695039,
      3.167108,
      NULL,
      1,
      0.592039,
      0.008593,
      0.291593,
      0.377180,
      NULL,
      0,
      1.301257,
      NULL,
      1.443575,
      1.455303,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.783857,
      NULL,
      3.262341,
      NULL,
      3,
      NULL,
      3.455360,
      NULL,
      35,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.853581,
      NULL,
      0.889255,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.036834,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.640474,
      NULL,
      0.330440,
      NULL,
      1.312868,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.846490,
      1,
      1,
      0,
      NULL,
      2,
      1,
      1.816410,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.972740,
      NULL,
      1,
      0.923115,
      NULL,
      NULL,
      3.540753,
      NULL,
      1.644476,
      1.937527,
      NULL,
      1,
      1,
      NULL,
      1,
      1.592372,
      NULL,
      0,
      3.278072,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.048936,
      NULL,
      NULL,
      NULL,
      0.407714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924252,
      NULL,
      0.832195,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      84.685314,
      102,
      1,
      NULL,
      2,
      '4010',
      '32341',
      '',
      1.586721,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


