set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9845877';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2.612741,
      3.798544,
      3,
      2.100003,
      2.071380,
      NULL,
      0,
      '124',
      '31222243',
      NULL,
      3.656202,
      '1201221',
      2.267821,
      NULL,
      3,
      NULL,
      '3020',
      NULL,
      1,
      NULL,
      NULL,
      '11-26-2002',
      131,
      75,
      NULL,
      NULL,
      3.707687,
      ' 6-27-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 9-27-1999',
      ' 0-25-1999',
      NULL,
      0.715378,
      2.051517,
      2,
      NULL,
      2.978502,
      2,
      3,
      NULL,
      NULL,
      NULL,
      5.281857,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      3,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      3,
      5,
      4,
      1,
      5,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      3,
      4,
      1,
      NULL,
      NULL,
      9,
      1,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.546843,
      3,
      NULL,
      1.530154,
      2.979090,
      1,
      0,
      2,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      1,
      1,
      5,
      0,
      2,
      1.257574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0.986268,
      NULL,
      1,
      0,
      4,
      2,
      2,
      NULL,
      3,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      5,
      0,
      1,
      1,
      0,
      3,
      5,
      4,
      2,
      0,
      1,
      1,
      4.783972,
      0.518986,
      NULL,
      NULL,
      '10-16-1980',
      188,
      3,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.112362,
      NULL,
      3.453729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366975,
      1.437976,
      7.351361,
      0,
      0.976994,
      1,
      0.241638,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.358128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.375100,
      1,
      1.431251,
      2.420419,
      6.743644,
      3,
      0,
      17.610041,
      56.521375,
      0.579939,
      1,
      1,
      NULL,
      1,
      1,
      2,
      0,
      2,
      3,
      0,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      0.312462,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      3.205241,
      0.313701,
      8,
      9.611982,
      6.434732,
      6,
      0,
      3.339619,
      3,
      NULL,
      0,
      3.918087,
      3,
      0,
      16,
      1,
      NULL,
      54,
      NULL,
      69,
      65,
      1,
      2,
      NULL,
      '44022',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.730847,
      '',
      '',
      NULL,
      3,
      17,
      119.828231,
      NULL,
      1.200439,
      26,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.876438,
      0,
      NULL,
      NULL,
      0.268737,
      NULL,
      NULL,
      NULL,
      1,
      2.998707,
      0,
      NULL,
      NULL,
      1.762954,
      1.833827,
      0.731315,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      1.143557,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199237,
      0,
      1.706529,
      10,
      1,
      7.998928,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.357482,
      0.486512,
      3.213154,
      1.530300,
      NULL,
      NULL,
      1,
      1.818329,
      NULL,
      3.703519,
      0.085126,
      NULL,
      0,
      0.168170,
      0.073674,
      3,
      0,
      1.669291,
      0,
      1,
      0,
      0.730432,
      0.945006,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.469488,
      2,
      1,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.529477,
      NULL,
      NULL,
      NULL,
      0.234106,
      NULL,
      NULL,
      1,
      NULL,
      1.597814,
      0.999765,
      0,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      6,
      0,
      0.130734,
      1.679280,
      0.496311,
      NULL,
      NULL,
      5.637183,
      NULL,
      1.812694,
      0.931616,
      NULL,
      NULL,
      1.302409,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.879693,
      NULL,
      NULL,
      1.242466,
      0.596760,
      3.418396,
      2.192564,
      NULL,
      7.517505,
      1,
      NULL,
      NULL,
      1,
      1.033190,
      2.518594,
      1,
      NULL,
      3,
      4,
      5,
      NULL,
      5,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2.712446,
      0.492344,
      3.731977,
      0.159661,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.878106,
      NULL,
      0,
      3,
      1.455495,
      3,
      2.239002,
      3,
      3,
      3.445330,
      1.009872,
      2,
      0,
      1,
      7,
      0.886708,
      0.348566,
      NULL,
      1.432971,
      3,
      3,
      1,
      0.110842,
      0,
      0.824063,
      0.255588,
      NULL,
      NULL,
      NULL,
      1.337749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.492536,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      0.573960,
      0.175119,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1.394050,
      NULL,
      NULL,
      NULL,
      390,
      NULL,
      NULL,
      NULL,
      3.713652,
      NULL,
      NULL,
      NULL,
      3.649636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.147580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.767391,
      16.689267,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      1.190105,
      NULL,
      NULL,
      1.085311,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.430048,
      1,
      1.303287,
      0,
      1,
      1.350948,
      1.070517,
      1.989849,
      NULL,
      0.236341,
      1,
      0.187907,
      1,
      0,
      1.121102,
      1.582511,
      1.087552,
      0.783203,
      1.325501,
      0.841866,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.368568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707101,
      0.932230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141320,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139885,
      1.602836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.774635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.079783,
      0,
      NULL,
      1.659368,
      0.090739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.900183,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.016430,
      0.449547,
      0,
      NULL,
      0.654630,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0.369821,
      3,
      NULL,
      0.670011,
      0.737325,
      NULL,
      0.303490,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.637689,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.170631,
      1.973218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      4,
      1,
      1.324147,
      1,
      37,
      121.528710,
      4,
      1,
      3,
      '31013',
      '32321',
      '',
      NULL,
      '',
      NULL,
      '',
      0.800493,
      '',
      '',
      NULL);
commit;
end;
/


