set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '1113210',
      3,
      0.705908,
      2,
      3,
      '3401',
      2.596954,
      2.180018,
      0,
      67,
      ' 6-29-1989',
      73.297054,
      NULL,
      4,
      0.242967,
      0.075672,
      ' 2-10-1994',
      60,
      4,
      42,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      0.216202,
      1.980830,
      2.106932,
      1.121320,
      NULL,
      0,
      0.695220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.893197,
      7,
      1,
      26,
      4,
      NULL,
      4.076408,
      1.086046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      7,
      2,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      5,
      0,
      NULL,
      3,
      NULL,
      1,
      5,
      0,
      1,
      NULL,
      1,
      1.578625,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      1.099732,
      0.753905,
      0,
      1,
      1.539718,
      3.518579,
      1,
      0.916473,
      0.696338,
      1,
      0,
      0.841884,
      0.377154,
      1,
      NULL,
      1,
      1.433992,
      NULL,
      0,
      0,
      4.221762,
      0,
      0,
      1.508287,
      0,
      NULL,
      NULL,
      0.170340,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      1.502780,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      4,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      4,
      0,
      0,
      2,
      NULL,
      1,
      0,
      3,
      1,
      2,
      2,
      NULL,
      NULL,
      0.701686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739227,
      0.575308,
      NULL,
      1,
      NULL,
      1.940998,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.768214,
      NULL,
      0.322479,
      0.154912,
      0,
      1.860579,
      NULL,
      NULL,
      NULL,
      0.000517,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      1,
      1,
      2,
      1,
      1,
      0,
      3,
      1,
      1,
      3,
      3.745299,
      1,
      2.543311,
      0,
      1,
      0.787928,
      3,
      NULL,
      NULL,
      0.752882,
      NULL,
      1,
      0,
      0.277294,
      0.754783,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607191,
      45,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      '01433',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      5,
      127,
      2.417462,
      2,
      9.894320,
      6.955188,
      NULL,
      3,
      0,
      0.860960,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359799,
      NULL,
      NULL,
      NULL,
      3,
      1.084304,
      1.003901,
      NULL,
      NULL,
      3,
      10,
      0,
      0.730293,
      NULL,
      NULL,
      NULL,
      1.100176,
      0.405949,
      0,
      NULL,
      NULL,
      0.531206,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.140505,
      NULL,
      NULL,
      19.452116,
      0,
      2,
      0.648565,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068022,
      0.134491,
      0,
      1,
      NULL,
      1,
      0,
      1.638508,
      0,
      NULL,
      1,
      3.067388,
      0,
      1.625646,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.815787,
      NULL,
      NULL,
      NULL,
      4.567006,
      1.581969,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.438637,
      NULL,
      NULL,
      2.736257,
      NULL,
      NULL,
      NULL,
      3.559662,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.961361,
      NULL,
      0,
      3.196018,
      1,
      0.732687,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.222507,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.285042,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.957775,
      3,
      NULL,
      5.001254,
      1.263082,
      NULL,
      2.935867,
      NULL,
      NULL,
      2,
      1.994476,
      1,
      1.757400,
      2.087520,
      1.265340,
      3.901604,
      NULL,
      1.633598,
      3,
      7,
      2,
      1.393201,
      1,
      1.880658,
      1,
      NULL,
      NULL,
      2,
      2.796774,
      1.354434,
      1.872709,
      1,
      0,
      1.359466,
      NULL,
      1.437004,
      1,
      3.564610,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510915,
      3.485515,
      NULL,
      NULL,
      1.481981,
      NULL,
      NULL,
      4.458493,
      NULL,
      1,
      1.853959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066511,
      NULL,
      0.944416,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.380147,
      NULL,
      1,
      0.831405,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.475083,
      NULL,
      1.066118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.034630,
      NULL,
      NULL,
      NULL,
      3,
      0.349987,
      NULL,
      NULL,
      3.697100,
      0.946920,
      2.112314,
      NULL,
      1.538470,
      0.300796,
      NULL,
      NULL,
      3.778628,
      1,
      2.792292,
      NULL,
      0,
      1,
      0.201682,
      NULL,
      0.543705,
      0.463566,
      NULL,
      NULL,
      8.117179,
      1.493447,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.170650,
      NULL,
      NULL,
      2.782185,
      NULL,
      6.554774,
      0.667500,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.840038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.335897,
      1,
      1,
      1,
      1,
      1.150467,
      0,
      1.312021,
      NULL,
      NULL,
      0,
      NULL,
      0.125491,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.088207,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.493125,
      NULL,
      12,
      NULL,
      1.634264,
      16,
      34,
      0.285003,
      1.918166,
      NULL,
      NULL,
      1,
      NULL,
      1.513428,
      NULL,
      0.309198,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.904636,
      NULL,
      0,
      NULL,
      1.989800,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      0.988043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769564,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541674,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321329,
      NULL,
      0,
      0.037259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      5.547434,
      NULL,
      2.968627,
      3.580628,
      NULL,
      NULL,
      1.950122,
      0,
      NULL,
      NULL,
      2,
      0,
      0.668441,
      1,
      16.201480,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      3.286775,
      NULL,
      2.193374,
      1.068874,
      1,
      NULL,
      3.034351,
      1,
      3.839927,
      0.218945,
      1,
      0,
      NULL,
      0,
      2,
      0,
      0,
      3.190034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      6,
      6,
      0.924548,
      NULL,
      NULL,
      69,
      70,
      1,
      0,
      4,
      '00101',
      '12344',
      '',
      0,
      '34334',
      NULL,
      '',
      3,
      '4124',
      '4002',
      '');
commit;
end;
/


