set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6916891';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '0311202',
      3.032945,
      0.923217,
      3,
      0,
      NULL,
      NULL,
      1.540157,
      NULL,
      NULL,
      '11-15-1978',
      52.261418,
      NULL,
      NULL,
      NULL,
      1,
      '11- 2-1988',
      84,
      3,
      330,
      107.836876,
      0,
      '11-27-2000',
      ' 6- 3-1978',
      ' 6-12-1988',
      3.700362,
      NULL,
      1.113056,
      1.960674,
      0,
      NULL,
      0,
      1,
      NULL,
      337.967992,
      6,
      7.241240,
      0.668114,
      4.812630,
      9.419011,
      3,
      18.450030,
      0,
      NULL,
      5,
      1.785480,
      0,
      0,
      0.948750,
      0,
      1.141170,
      NULL,
      NULL,
      0.029737,
      1.996990,
      183.104830,
      0,
      6,
      5,
      3,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1.638943,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.429001,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.074459,
      1,
      NULL,
      0.786468,
      0.341629,
      1,
      0,
      1,
      0,
      2.803641,
      2.382537,
      1,
      0,
      2,
      NULL,
      0,
      1,
      1,
      0.097739,
      NULL,
      NULL,
      1.341964,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1.762558,
      0,
      0,
      1,
      1,
      2,
      NULL,
      0.536408,
      2,
      1,
      NULL,
      2,
      1,
      3,
      2,
      1,
      2,
      NULL,
      2,
      5,
      2,
      NULL,
      2,
      NULL,
      3,
      3,
      4,
      3,
      5,
      NULL,
      NULL,
      1,
      4,
      4,
      0,
      ' 1- 6-1991',
      1101.745548,
      '11- 2-2003',
      1651,
      1.102703,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0.512297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1096,
      0.106807,
      0.332645,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1,
      1,
      3,
      1,
      0.056517,
      2,
      6,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.629564,
      1,
      5,
      3,
      1,
      ' 6- 7-1985',
      NULL,
      ' 9-13-1976',
      NULL,
      1.229641,
      1,
      NULL,
      3.391009,
      0.218609,
      0.839449,
      NULL,
      2,
      0.641241,
      1.733119,
      2,
      129.148899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2,
      1,
      1,
      3,
      3,
      2,
      NULL,
      0,
      3,
      3,
      NULL,
      1.082973,
      NULL,
      0.479252,
      1.441283,
      1,
      8,
      0,
      0.424700,
      3.981718,
      0.229192,
      1.372994,
      1,
      0.292354,
      NULL,
      3,
      1,
      2.524303,
      0.886793,
      7.616573,
      NULL,
      6.924624,
      5,
      NULL,
      1,
      3,
      1.389936,
      1,
      2.373918,
      NULL,
      2,
      33.966363,
      2,
      NULL,
      NULL,
      32,
      NULL,
      47.258430,
      2,
      3,
      3.386792,
      '40114',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.238244,
      '',
      '',
      NULL,
      0.134483,
      20,
      410.387304,
      NULL,
      1.190148,
      16.473629,
      41.150219,
      74.888215,
      2,
      NULL,
      3,
      0.116804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394839,
      0.597509,
      3,
      2.985614,
      2.076872,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      1.518022,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.168453,
      NULL,
      NULL,
      0.447064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.660255,
      6.191885,
      NULL,
      0.903049,
      0,
      3,
      0,
      1.101788,
      0,
      2.690728,
      NULL,
      NULL,
      0.654929,
      0.034667,
      1,
      NULL,
      NULL,
      1.652867,
      NULL,
      NULL,
      2,
      1.587544,
      NULL,
      3.866438,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1.398781,
      0.050552,
      1.569838,
      NULL,
      2,
      NULL,
      1.966900,
      NULL,
      NULL,
      2.757415,
      1.386170,
      NULL,
      0.194686,
      0,
      1.165985,
      9.222246,
      6,
      5.388815,
      NULL,
      1.953571,
      0.803007,
      3,
      1.390767,
      2.880385,
      0,
      1,
      NULL,
      1.754589,
      NULL,
      NULL,
      2.252627,
      1,
      0,
      1.402643,
      1.795797,
      0,
      1.120196,
      NULL,
      NULL,
      NULL,
      0,
      1.177591,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.215574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.206692,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981688,
      0,
      2,
      NULL,
      1.250611,
      5.854531,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      3.741955,
      3,
      0,
      2,
      3,
      NULL,
      4.219836,
      NULL,
      0.370298,
      0,
      0.918673,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3.390580,
      2.084867,
      1.959388,
      6,
      4,
      5,
      NULL,
      1,
      7,
      3,
      3,
      1,
      NULL,
      1.872386,
      3,
      1,
      1.287491,
      NULL,
      NULL,
      6,
      1.916656,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332162,
      NULL,
      NULL,
      1.979432,
      NULL,
      NULL,
      0.578626,
      NULL,
      NULL,
      1.106492,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719714,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.102433,
      1,
      NULL,
      1.753418,
      NULL,
      NULL,
      0.241744,
      1,
      NULL,
      2.987639,
      2.306529,
      NULL,
      1.706980,
      2,
      1.592935,
      2.214059,
      NULL,
      NULL,
      NULL,
      1.341397,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1231,
      NULL,
      NULL,
      NULL,
      2.722170,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.795973,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.425124,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.436016,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.456109,
      NULL,
      NULL,
      NULL,
      1.085556,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.036148,
      NULL,
      17.995706,
      1.389046,
      NULL,
      NULL,
      0,
      1.499606,
      0,
      2,
      57,
      24.813189,
      0.867664,
      12.744014,
      7.409100,
      NULL,
      NULL,
      0.023658,
      424,
      43.483486,
      0,
      1.045684,
      0,
      1,
      1,
      NULL,
      0.544438,
      NULL,
      1.094034,
      1,
      NULL,
      NULL,
      1.321579,
      1.125016,
      0.227532,
      1.922214,
      0,
      0.793995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      5.598723,
      0.449841,
      1,
      NULL,
      10.297003,
      2,
      0,
      1.902710,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.606790,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.188751,
      NULL,
      1,
      1,
      NULL,
      1,
      0.844317,
      NULL,
      0,
      1.771312,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      3.099164,
      0,
      0.335603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      0,
      7,
      0.160700,
      0,
      2.322668,
      NULL,
      45.319004,
      NULL,
      3,
      NULL,
      NULL,
      '',
      NULL,
      0.674938,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


