set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9892585';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      4.862111,
      4,
      1.050903,
      3,
      2.308737,
      NULL,
      3,
      '421',
      '20430411',
      NULL,
      49,
      '0123244',
      3,
      NULL,
      6,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      ' 5-13-1982',
      48,
      104.085391,
      NULL,
      0.768596,
      3.032523,
      ' 0-13-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '11-13-2001',
      0,
      0,
      0,
      2.864288,
      0.163831,
      1,
      0,
      0.401242,
      NULL,
      4,
      7,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.539604,
      1.007924,
      0.030710,
      0,
      0.557198,
      1.776191,
      0.550468,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      2,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      5.420840,
      0,
      0,
      1,
      NULL,
      0.417885,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      2,
      2.788802,
      0.527802,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      NULL,
      5,
      1,
      1,
      1,
      1,
      2,
      NULL,
      4.475694,
      0,
      1,
      1,
      0,
      1.478858,
      NULL,
      0.531508,
      5,
      0,
      0,
      3,
      1,
      0,
      2,
      NULL,
      NULL,
      3,
      5,
      3,
      NULL,
      NULL,
      3,
      0,
      5,
      NULL,
      2,
      5,
      5,
      NULL,
      1,
      1,
      0,
      0.710697,
      0.133741,
      ' 7- 3-1994',
      148,
      ' 5-26-1979',
      80.107788,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      1.612921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      0.347065,
      2,
      1,
      1,
      2,
      1.847715,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.047262,
      7.908899,
      0.416080,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.963690,
      0,
      0.765576,
      NULL,
      0.570411,
      NULL,
      NULL,
      0.855678,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763267,
      2,
      2,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      2,
      2,
      0,
      3.569770,
      4.164111,
      3,
      0,
      0,
      NULL,
      1,
      3,
      1.572896,
      NULL,
      0.776657,
      1,
      0,
      0,
      1.765413,
      1,
      1.352131,
      3.466037,
      1.269010,
      9.270392,
      9.537379,
      5,
      NULL,
      NULL,
      1.905107,
      1,
      1,
      6.959015,
      3,
      2.425695,
      3,
      7,
      3,
      NULL,
      49,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      '43330',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      2,
      12,
      45.275848,
      2,
      2.304131,
      11.553636,
      0,
      NULL,
      2,
      NULL,
      1.397100,
      NULL,
      1.043999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532833,
      0,
      NULL,
      2,
      3.160217,
      3.841090,
      1,
      NULL,
      NULL,
      0.437149,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.366482,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      4.749815,
      5.023270,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.295496,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      3.916509,
      2.663228,
      3.281050,
      3.273458,
      3,
      1,
      1.955117,
      NULL,
      0.861579,
      1.115674,
      0.463471,
      0.659246,
      1,
      0.484234,
      1,
      0.337181,
      1,
      3,
      3,
      1,
      1,
      1,
      3.614027,
      0.523798,
      NULL,
      NULL,
      NULL,
      0.289647,
      2.931708,
      NULL,
      8.856932,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982569,
      0.811838,
      3.610437,
      1,
      NULL,
      2.421848,
      3.825469,
      NULL,
      6.498736,
      NULL,
      9,
      3.008236,
      0.239243,
      2,
      1,
      0.592071,
      1,
      5.199737,
      2.283888,
      4.686358,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.655954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.576502,
      3,
      3.905563,
      2.829429,
      0,
      NULL,
      2,
      7,
      1,
      8,
      5.711296,
      1,
      NULL,
      NULL,
      2,
      2,
      0,
      3,
      NULL,
      1,
      1,
      1.968752,
      NULL,
      9,
      4.730157,
      4.321744,
      2.534359,
      3,
      NULL,
      0.634967,
      2,
      1.879849,
      3.229293,
      0,
      1.994487,
      0.307626,
      3.635120,
      1,
      8,
      4,
      4,
      NULL,
      4.999628,
      7,
      NULL,
      1,
      4,
      1,
      NULL,
      0,
      1.655313,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.029463,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.277243,
      NULL,
      NULL,
      2.111347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.425803,
      NULL,
      NULL,
      NULL,
      1.497905,
      1.404980,
      0.890730,
      1,
      0.162170,
      1.237967,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.312954,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.801152,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.429534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.335441,
      NULL,
      NULL,
      NULL,
      0.310327,
      NULL,
      NULL,
      NULL,
      6.137175,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      6,
      NULL,
      0,
      6.485458,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.138317,
      1.393957,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0.759483,
      0.002807,
      0,
      0.198847,
      1.996987,
      NULL,
      1.798815,
      1.028179,
      0.534731,
      0,
      0.552017,
      1.578100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      2,
      3.926755,
      0,
      0.833689,
      2.509133,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0.138295,
      NULL,
      1.834974,
      1.721357,
      NULL,
      0.775848,
      0,
      NULL,
      1.055397,
      0.837485,
      NULL,
      1.029903,
      2.118264,
      NULL,
      2,
      NULL,
      NULL,
      0.651589,
      1.897320,
      NULL,
      0.356953,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.192772,
      NULL,
      NULL,
      NULL,
      1.414449,
      0.862867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892090,
      NULL,
      0.911522,
      NULL,
      1,
      4,
      1,
      2,
      0,
      3,
      13,
      NULL,
      5,
      4.378816,
      0,
      '34012',
      '',
      NULL,
      1.104614,
      '',
      '',
      '',
      0.548403,
      NULL,
      '',
      NULL);
commit;
end;
/


