set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '1103110',
      3.100445,
      1,
      6,
      1,
      '1320',
      NULL,
      1.856353,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      2,
      NULL,
      1.268230,
      ' 8- 8-1995',
      NULL,
      2,
      285.794374,
      NULL,
      1,
      ' 0-22-2000',
      NULL,
      ' 2- 6-1977',
      2,
      0.880062,
      1.383485,
      3.070456,
      1,
      0.530024,
      NULL,
      NULL,
      0,
      1.243665,
      8,
      8.766341,
      2.914409,
      14.212223,
      NULL,
      5,
      6.412109,
      5,
      0,
      4,
      0,
      1,
      2,
      0.243906,
      0.915438,
      1.610024,
      NULL,
      NULL,
      1.892055,
      0,
      0,
      1,
      3,
      1,
      0.609865,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      3.542304,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.739139,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      1.002879,
      0.404458,
      1,
      0,
      3,
      2.200983,
      2.056793,
      0,
      NULL,
      2,
      1.797314,
      1,
      0,
      1,
      0.081067,
      NULL,
      0,
      1,
      3.559600,
      1,
      NULL,
      0.324793,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      2,
      2,
      1,
      4,
      1,
      5,
      3,
      0,
      NULL,
      5,
      1,
      2,
      3,
      1,
      4,
      4,
      3,
      0,
      5,
      0,
      1,
      2,
      1,
      3,
      4,
      1.958314,
      0,
      NULL,
      43,
      ' 8-13-2002',
      NULL,
      3.410710,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0.261106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      1.959051,
      0.576693,
      1,
      1,
      5,
      0,
      0.917591,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.066485,
      NULL,
      3,
      0,
      0.533631,
      NULL,
      NULL,
      1,
      4,
      0.966640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.038783,
      0.858033,
      NULL,
      0.234250,
      1,
      0,
      3.703525,
      0.435655,
      0.815736,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      1,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      2,
      0.538163,
      0,
      2.427337,
      0.209833,
      NULL,
      1,
      1,
      NULL,
      1,
      1.826328,
      0,
      1.196541,
      0.980049,
      NULL,
      1,
      NULL,
      1.407365,
      0.926165,
      5.244411,
      5,
      1.117558,
      7,
      4.042650,
      3.462798,
      1,
      1,
      2,
      2.121832,
      3,
      1,
      6,
      NULL,
      0,
      NULL,
      46,
      23,
      10,
      2,
      2.922214,
      0,
      '3142',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      21.617197,
      18,
      1.359022,
      1.813711,
      37.544996,
      0.763666,
      11,
      NULL,
      NULL,
      3,
      0.411024,
      0.843942,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.357098,
      NULL,
      NULL,
      1.107307,
      NULL,
      NULL,
      0.689662,
      NULL,
      NULL,
      NULL,
      1.748196,
      1,
      1.264731,
      NULL,
      NULL,
      1.774326,
      NULL,
      NULL,
      1.695271,
      NULL,
      NULL,
      0.572462,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.351079,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      3.128202,
      3,
      NULL,
      2.167829,
      0.472917,
      1.353584,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.045794,
      9.157617,
      0.964315,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.662721,
      NULL,
      2,
      1.552895,
      0.748732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.043255,
      1,
      NULL,
      1.550583,
      NULL,
      NULL,
      0,
      3.233922,
      NULL,
      0.469473,
      NULL,
      NULL,
      0.537363,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.333867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.586539,
      3,
      1.403038,
      NULL,
      NULL,
      NULL,
      1,
      1,
      7.626360,
      NULL,
      3,
      0.130226,
      NULL,
      NULL,
      1,
      1.182534,
      1.861108,
      2.194931,
      0.651714,
      2,
      NULL,
      3.968138,
      NULL,
      3.097182,
      0,
      3,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      3,
      2.513399,
      1,
      3.373875,
      1,
      3,
      3,
      7.426902,
      4,
      NULL,
      5.255212,
      1,
      0.573139,
      NULL,
      NULL,
      1.222821,
      1.075703,
      NULL,
      1,
      1.431852,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.649155,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.642113,
      NULL,
      NULL,
      2.210605,
      NULL,
      NULL,
      1.082829,
      NULL,
      3.546376,
      2.095296,
      3.073573,
      0.076599,
      2.176088,
      0,
      6.107225,
      NULL,
      5,
      NULL,
      0.797791,
      NULL,
      90,
      NULL,
      0.216211,
      NULL,
      2,
      NULL,
      0.657026,
      NULL,
      3.234228,
      3,
      NULL,
      NULL,
      1.013439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205084,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368604,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.316884,
      1.371252,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3.170292,
      3.641246,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.302756,
      2.920917,
      NULL,
      3,
      1.778996,
      3,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3.685128,
      2,
      1,
      NULL,
      3,
      2,
      0.019520,
      NULL,
      2,
      11,
      10.101028,
      NULL,
      0.398041,
      NULL,
      NULL,
      2.844422,
      NULL,
      4,
      6,
      0,
      29,
      2,
      3.445826,
      3,
      1,
      2.988771,
      0.088601,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      62.472770,
      12.011547,
      1.638311,
      NULL,
      0.609110,
      1.880828,
      1.309675,
      1.483557,
      1,
      0,
      0.214449,
      1.757199,
      NULL,
      1,
      0,
      0,
      0.753397,
      1,
      0.336518,
      3,
      NULL,
      NULL,
      NULL,
      1.157368,
      NULL,
      NULL,
      NULL,
      1.806457,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      0,
      NULL,
      2.267695,
      1.454434,
      NULL,
      11.784881,
      NULL,
      0.633917,
      1,
      1.424375,
      NULL,
      1.282091,
      0,
      3.704600,
      1,
      1,
      1.947780,
      1,
      0,
      NULL,
      0.177907,
      1,
      1,
      2.758070,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      2.043878,
      0,
      3,
      2,
      0.404911,
      0,
      2.448870,
      0.829933,
      NULL,
      0,
      0,
      0.726126,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3.888245,
      1.315135,
      1,
      0.542334,
      0,
      1,
      NULL,
      NULL,
      0,
      1.464323,
      0.115193,
      3,
      2.018939,
      3,
      1.774604,
      0,
      NULL,
      1.804436,
      1.616329,
      3.016220,
      3,
      NULL,
      15,
      54,
      1,
      NULL,
      1,
      0,
      3,
      1,
      1.029311,
      NULL,
      4,
      5,
      3,
      0,
      NULL,
      NULL,
      NULL,
      114,
      NULL,
      2,
      3,
      '4122',
      '',
      '',
      2,
      '43312',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


