set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '1424030',
      3.110926,
      0,
      1,
      1,
      '3203',
      2.309331,
      0.570528,
      NULL,
      NULL,
      ' 4-17-1977',
      20.169598,
      NULL,
      NULL,
      3,
      NULL,
      '11- 5-1983',
      34,
      0.298779,
      NULL,
      102,
      NULL,
      NULL,
      ' 9- 0-1987',
      NULL,
      NULL,
      0,
      1,
      0,
      1.531179,
      0.158636,
      2,
      1.377627,
      0.313221,
      14.240298,
      3,
      NULL,
      NULL,
      6.532575,
      NULL,
      4,
      NULL,
      3,
      NULL,
      5.551456,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0.466836,
      1.384943,
      NULL,
      0,
      3,
      0,
      4,
      3,
      4,
      0,
      0,
      1,
      3,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      2,
      0,
      1,
      1.609524,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      0.094311,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      2,
      NULL,
      3,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0.555397,
      NULL,
      NULL,
      0,
      0,
      1,
      4,
      4,
      5,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      5,
      5,
      NULL,
      3,
      1,
      3,
      3,
      0,
      3,
      1,
      NULL,
      0.526546,
      3,
      '11- 3-1990',
      144.523447,
      ' 4- 5-1987',
      NULL,
      1.698308,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.240930,
      0.577459,
      1.801313,
      NULL,
      1.024363,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.887400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879775,
      NULL,
      NULL,
      NULL,
      1,
      0.042710,
      2.188655,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      0,
      1,
      2,
      0,
      3,
      2,
      3,
      0,
      NULL,
      3.156064,
      3,
      NULL,
      5,
      0.977330,
      0.256989,
      NULL,
      1,
      1,
      NULL,
      1.939710,
      0,
      0.686240,
      0.628005,
      0.810459,
      NULL,
      1.837441,
      1,
      0,
      4.059744,
      5,
      1.377015,
      2,
      8,
      1.475281,
      0,
      2,
      5.084465,
      0.883512,
      1,
      0.114214,
      45,
      NULL,
      0.560719,
      NULL,
      83,
      66,
      80,
      NULL,
      1,
      1.589117,
      '10003',
      '',
      '',
      0.946311,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      1.910834,
      126.902922,
      59.650724,
      1.474642,
      56.356816,
      0.524135,
      1.417341,
      NULL,
      1,
      NULL,
      NULL,
      1.662104,
      NULL,
      NULL,
      3.568919,
      1.429517,
      1,
      NULL,
      1.026472,
      0,
      NULL,
      1.193322,
      NULL,
      2.690144,
      1,
      0.219931,
      NULL,
      2,
      2,
      1.713085,
      NULL,
      1,
      0.303337,
      NULL,
      NULL,
      1.609822,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.858470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.629907,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.184615,
      NULL,
      NULL,
      2.874949,
      19,
      5.523707,
      NULL,
      NULL,
      NULL,
      0.415395,
      0,
      NULL,
      1.164741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.340521,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.713608,
      NULL,
      NULL,
      0.251165,
      NULL,
      NULL,
      NULL,
      3.475415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.440817,
      NULL,
      NULL,
      5.631466,
      0,
      2.265403,
      1.818399,
      1,
      1.333250,
      1.988536,
      NULL,
      0.619005,
      NULL,
      1.368590,
      3,
      0,
      1,
      3,
      0,
      0,
      3.329146,
      0.897671,
      NULL,
      3.611991,
      3.699677,
      3,
      NULL,
      3.144005,
      0,
      2,
      9,
      8,
      1.903322,
      1,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      0.512786,
      1.220317,
      0.499129,
      NULL,
      NULL,
      NULL,
      1.421592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.422021,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740946,
      0,
      1.807415,
      1.252000,
      0.864422,
      NULL,
      0.396830,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844287,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.910836,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.099580,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.071671,
      NULL,
      NULL,
      1.684781,
      NULL,
      NULL,
      1.628761,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427159,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0.397312,
      1,
      0,
      0,
      0,
      0,
      0.403560,
      0,
      0.672287,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      11.079988,
      0,
      4,
      NULL,
      NULL,
      9.325342,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1.971169,
      NULL,
      0.719498,
      0,
      NULL,
      0,
      0.866693,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773679,
      1.187872,
      NULL,
      1,
      2,
      NULL,
      0.962747,
      0.367066,
      NULL,
      NULL,
      1.432311,
      NULL,
      0.444327,
      1,
      NULL,
      1.490107,
      1,
      NULL,
      1,
      1.008457,
      0.579676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.591675,
      NULL,
      1,
      NULL,
      2,
      6,
      3,
      1.218713,
      NULL,
      2,
      62.324112,
      87,
      NULL,
      0.782405,
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


