set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.868628,
      3,
      3,
      '1002',
      1.404589,
      1.785041,
      NULL,
      NULL,
      ' 1-26-2000',
      46.908149,
      NULL,
      NULL,
      3,
      0,
      NULL,
      75,
      NULL,
      591,
      15,
      1,
      NULL,
      '11- 3-1987',
      ' 3- 5-1977',
      0.504485,
      NULL,
      0.255693,
      3.461878,
      1.638753,
      0,
      NULL,
      1.758379,
      1,
      7,
      7,
      NULL,
      NULL,
      11.707255,
      19.138655,
      NULL,
      16.164259,
      5,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      1,
      NULL,
      2,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      1,
      1,
      1,
      1,
      1.915018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      5,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      1,
      0,
      0,
      1.457597,
      NULL,
      1.008621,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      1,
      2,
      3,
      2.733987,
      ' 0- 2-1983',
      360,
      ' 0- 0-1997',
      75.835253,
      1,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0.472338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609879,
      1,
      1.432039,
      1.167538,
      1.222445,
      0.249519,
      1.408049,
      NULL,
      NULL,
      NULL,
      1.425192,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405504,
      1,
      NULL,
      1,
      NULL,
      1.614759,
      0.210098,
      0,
      NULL,
      0.140832,
      0.688710,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      2,
      NULL,
      3,
      1,
      3,
      2,
      0,
      0,
      1,
      NULL,
      1.316280,
      NULL,
      1.431343,
      NULL,
      1.357622,
      3.716308,
      NULL,
      1,
      0.346179,
      1,
      NULL,
      1.768160,
      0.371745,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      24,
      NULL,
      0,
      NULL,
      0.741970,
      '11111',
      '',
      '',
      0.993847,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      64.352424,
      17.759181,
      NULL,
      1,
      26.813179,
      3.300609,
      0.099990,
      0,
      1.203577,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.534130,
      NULL,
      NULL,
      0.953582,
      NULL,
      NULL,
      0.735108,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0.612324,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372521,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.379360,
      5.690214,
      2,
      1,
      0.478061,
      NULL,
      NULL,
      NULL,
      0.685602,
      NULL,
      NULL,
      NULL,
      1,
      17,
      8.352188,
      NULL,
      NULL,
      NULL,
      1.882412,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045582,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.382206,
      NULL,
      NULL,
      1.038327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134868,
      NULL,
      NULL,
      1.424700,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      0.907587,
      1,
      1.638677,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.729834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.857638,
      0,
      NULL,
      NULL,
      NULL,
      4,
      4.026783,
      1,
      NULL,
      NULL,
      2.982765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.948244,
      2.509193,
      2,
      1,
      NULL,
      NULL,
      2.873572,
      1,
      1,
      0,
      1,
      NULL,
      0.307348,
      NULL,
      NULL,
      3,
      1,
      3.578318,
      1,
      0.879361,
      NULL,
      7,
      NULL,
      3,
      1.959201,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.897468,
      1,
      1.963656,
      0.696139,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.046803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.786051,
      NULL,
      NULL,
      0.829391,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0.596034,
      1.881238,
      NULL,
      1,
      NULL,
      NULL,
      0.225813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.054838,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147557,
      NULL,
      NULL,
      NULL,
      0.220662,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.822875,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.886582,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.945209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.812042,
      1.707063,
      1,
      1.038505,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1.849459,
      1.592440,
      NULL,
      1,
      0,
      1.069321,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      9.869964,
      NULL,
      5.974348,
      1,
      1,
      NULL,
      2.977848,
      2,
      1.963365,
      1,
      NULL,
      NULL,
      1.791933,
      NULL,
      NULL,
      1.604291,
      NULL,
      NULL,
      1.084590,
      NULL,
      NULL,
      NULL,
      1.812790,
      NULL,
      0,
      1.402971,
      NULL,
      1.877250,
      2.221507,
      NULL,
      1,
      0.782925,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410609,
      1.247484,
      NULL,
      1,
      0,
      NULL,
      2.592376,
      NULL,
      1.085802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4,
      2,
      3,
      1.259172,
      NULL,
      NULL,
      75.959836,
      49.580863,
      2,
      0.729646,
      3,
      '04442',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


