set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '4430340',
      0.341675,
      1,
      0,
      NULL,
      '1111',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.903428,
      NULL,
      NULL,
      1,
      2,
      ' 9- 4-1988',
      NULL,
      2,
      276,
      95.889770,
      NULL,
      ' 5-29-2002',
      ' 8-16-1978',
      '10- 7-1977',
      1.518884,
      1.650756,
      1.469008,
      NULL,
      1.500086,
      1.348888,
      1,
      0.093272,
      NULL,
      7,
      NULL,
      1.183943,
      5,
      13.711393,
      2,
      5,
      23,
      3,
      0,
      2.274121,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      5,
      1,
      4,
      NULL,
      3,
      2,
      5,
      2,
      1,
      2,
      0,
      1,
      5,
      0,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      1.341910,
      NULL,
      NULL,
      NULL,
      0,
      1.138953,
      0.488518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1.765299,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      4,
      NULL,
      0,
      1,
      3.614390,
      0,
      0,
      0,
      0,
      0.053048,
      NULL,
      1.529051,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      1,
      4,
      NULL,
      4,
      5,
      0,
      1,
      5,
      3,
      NULL,
      NULL,
      1,
      1,
      1.347173,
      NULL,
      ' 6- 7-1996',
      357,
      NULL,
      485.804815,
      2.461052,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721777,
      NULL,
      0,
      1.443643,
      0,
      0.895459,
      NULL,
      NULL,
      NULL,
      0.326189,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.270298,
      1,
      1,
      0,
      1,
      3.776203,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      3,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      0.429882,
      1.869648,
      NULL,
      1.346107,
      1.803388,
      5.281913,
      0,
      0.482404,
      NULL,
      1,
      NULL,
      0.917772,
      1,
      0.543642,
      1,
      0,
      3,
      0,
      NULL,
      4.473867,
      NULL,
      10,
      11.950828,
      6.542754,
      5,
      2.658127,
      5,
      3,
      NULL,
      1.501884,
      NULL,
      1,
      2,
      NULL,
      NULL,
      43,
      NULL,
      3,
      NULL,
      2,
      '23414',
      NULL,
      '',
      1.176531,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      44.968652,
      NULL,
      72.907902,
      NULL,
      73,
      3,
      0.394222,
      2,
      NULL,
      0,
      0,
      1.221030,
      NULL,
      NULL,
      NULL,
      1.766007,
      NULL,
      3,
      1.530949,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      2,
      2.857753,
      NULL,
      0,
      1,
      0.764458,
      1.580520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.731761,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417942,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.731125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.601609,
      2.130057,
      3,
      1,
      NULL,
      0,
      2.062208,
      0,
      6.948312,
      1.486736,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267103,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.068506,
      3,
      0.453934,
      0.967197,
      NULL,
      NULL,
      2.000866,
      6.657296,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      4,
      2.106781,
      1,
      1,
      NULL,
      0.816974,
      2,
      NULL,
      2.495910,
      NULL,
      6.168865,
      NULL,
      7.180434,
      2.749752,
      0,
      1.368338,
      0,
      3,
      0.543300,
      2,
      2,
      2,
      3.628906,
      2,
      2.546621,
      7.484915,
      2.492357,
      0.839773,
      NULL,
      NULL,
      NULL,
      0.947384,
      NULL,
      3,
      0.641282,
      1,
      NULL,
      1.443005,
      0,
      3,
      NULL,
      NULL,
      0.301908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.639866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.949018,
      1,
      0.212068,
      1.079229,
      0.888729,
      0.167766,
      1.501749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.691782,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.253279,
      4.667948,
      NULL,
      0,
      NULL,
      NULL,
      1.288376,
      NULL,
      NULL,
      0.044360,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115284,
      NULL,
      1.068383,
      NULL,
      0,
      1,
      1.913183,
      1.921979,
      1,
      0.831750,
      0,
      0,
      0.416937,
      1,
      1,
      1.199195,
      0,
      NULL,
      0,
      1,
      1.025293,
      0.420684,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0.534035,
      2,
      2,
      1.000581,
      3,
      3.332486,
      3,
      2,
      0.901745,
      1,
      1.738635,
      NULL,
      0.241679,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.386146,
      1.112793,
      NULL,
      0.619572,
      2,
      NULL,
      0.192113,
      0.789318,
      NULL,
      2.656201,
      3,
      NULL,
      1.722515,
      0.634276,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.985869,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.645186,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.090901,
      1.586196,
      0.294064,
      61,
      NULL,
      3,
      0,
      2.325786,
      '01003',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.875461,
      '',
      '',
      NULL);
commit;
end;
/


