set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0172938';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      NULL,
      1,
      NULL,
      1,
      2,
      0.480063,
      1.348513,
      '410',
      '13133034',
      28,
      37.253097,
      '4331021',
      1,
      1.823594,
      NULL,
      3,
      '3313',
      0.069600,
      NULL,
      NULL,
      NULL,
      ' 0-19-2003',
      11,
      13.085140,
      NULL,
      NULL,
      3,
      '10-19-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 0-13-2003',
      3,
      0.081609,
      0.993240,
      1.285900,
      NULL,
      1.228721,
      1,
      1.728579,
      NULL,
      NULL,
      NULL,
      9.791322,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      1,
      1.151610,
      NULL,
      1,
      0,
      0.137624,
      1.523284,
      1,
      0,
      3,
      5,
      4,
      2,
      3,
      1,
      4,
      5,
      1,
      NULL,
      5,
      5,
      2,
      3,
      0,
      0,
      7,
      NULL,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3,
      1,
      0.147079,
      NULL,
      0.240504,
      NULL,
      2,
      2.357182,
      3,
      2.260988,
      2.379450,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      4,
      6.664271,
      0,
      2,
      1.244642,
      0,
      NULL,
      NULL,
      0.257269,
      NULL,
      NULL,
      1,
      1,
      3,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      0,
      NULL,
      1,
      0,
      2,
      3,
      4,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      5,
      0,
      5,
      NULL,
      3,
      2,
      1,
      1,
      3,
      3,
      '10-24-1994',
      160,
      ' 2-13-2002',
      20,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.547593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.829513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.145557,
      8.488716,
      1,
      1.841283,
      4.810675,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.115797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162627,
      NULL,
      1.008353,
      0,
      1,
      NULL,
      0.203662,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.899904,
      1.924012,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      0,
      1,
      2,
      1,
      NULL,
      3,
      NULL,
      0.027937,
      1,
      NULL,
      NULL,
      1.782543,
      1.114786,
      1.016002,
      1,
      NULL,
      0,
      0,
      1,
      0,
      2,
      NULL,
      0.147127,
      3.204108,
      9,
      3.943096,
      4,
      7,
      5.724004,
      3.421943,
      0.038753,
      2,
      1.986234,
      3.759129,
      3,
      36.759118,
      2,
      NULL,
      78,
      NULL,
      NULL,
      NULL,
      0,
      0.625246,
      1,
      '04233',
      NULL,
      '',
      0.748299,
      NULL,
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      3.125691,
      7.739204,
      104,
      16.590248,
      0.389092,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166271,
      1,
      0.214180,
      0,
      NULL,
      NULL,
      0,
      0.385356,
      NULL,
      1,
      0,
      0,
      2,
      0.565867,
      1,
      2,
      0.572738,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0.662508,
      NULL,
      0.608032,
      NULL,
      3.617746,
      NULL,
      1.637068,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.870137,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.621167,
      0,
      3,
      NULL,
      NULL,
      0,
      0.923362,
      0,
      1,
      0,
      1,
      1,
      3.749741,
      0,
      2.689486,
      3,
      3.852233,
      0.877384,
      1,
      0.045219,
      0,
      0,
      1.616505,
      1.111871,
      1,
      NULL,
      NULL,
      1,
      1.974443,
      NULL,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      3.491786,
      1,
      1.217654,
      2.894496,
      0.927965,
      NULL,
      1.090427,
      NULL,
      1.927399,
      0.358533,
      NULL,
      1.697956,
      1.755900,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.194254,
      NULL,
      NULL,
      0.511611,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.784846,
      0.237515,
      2.200526,
      1.473651,
      NULL,
      NULL,
      9,
      0.919976,
      9.568948,
      NULL,
      7,
      7,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.153741,
      2,
      NULL,
      4.726087,
      3,
      0,
      1.979983,
      2,
      1.581093,
      3,
      3,
      NULL,
      NULL,
      3,
      0,
      2,
      3.849763,
      1.437116,
      NULL,
      3,
      4,
      NULL,
      3,
      2,
      1,
      4,
      0.914055,
      1,
      1.062433,
      1,
      0.820308,
      0.428782,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.551234,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965995,
      NULL,
      NULL,
      NULL,
      1.800004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.168708,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.391089,
      NULL,
      NULL,
      NULL,
      2.281776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.959250,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.619412,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      15.499840,
      NULL,
      NULL,
      NULL,
      1.162822,
      NULL,
      NULL,
      NULL,
      2.218733,
      7.304146,
      2,
      NULL,
      0,
      0.063135,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317811,
      NULL,
      0.915757,
      0,
      NULL,
      0,
      0.135165,
      NULL,
      NULL,
      1.034209,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0.010794,
      0.141477,
      1,
      1.504156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3,
      5.779880,
      0.899954,
      2.649381,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.733146,
      NULL,
      NULL,
      NULL,
      0.243804,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.983424,
      NULL,
      3,
      2.653877,
      NULL,
      0,
      NULL,
      NULL,
      3.245824,
      0.300564,
      NULL,
      1.847496,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.185698,
      1,
      1.664556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      4,
      3,
      1,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1.091718,
      2,
      '30134',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


