set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7833744';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      NULL,
      18.412839,
      '4323102',
      3.856215,
      NULL,
      1,
      NULL,
      '0231',
      NULL,
      1,
      NULL,
      NULL,
      ' 0- 7-1985',
      NULL,
      6.603331,
      NULL,
      3.283770,
      1.548970,
      ' 4- 9-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 0-22-1980',
      NULL,
      ' 3-14-1996',
      1.836599,
      1,
      NULL,
      0,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      6,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0.380294,
      NULL,
      0.509606,
      0,
      134,
      NULL,
      NULL,
      5,
      1,
      3,
      1,
      2,
      3,
      2,
      2,
      3,
      5,
      1,
      0,
      NULL,
      0,
      11.399032,
      NULL,
      NULL,
      1,
      1,
      1.181794,
      NULL,
      NULL,
      1.478332,
      NULL,
      NULL,
      1,
      NULL,
      0.646332,
      2.255743,
      1,
      3,
      1.670864,
      0,
      1.879435,
      NULL,
      1.659550,
      0,
      NULL,
      3.338770,
      2,
      0.154294,
      2,
      0,
      2.243190,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0.905388,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      5,
      3,
      NULL,
      0,
      4,
      1,
      0,
      2,
      1,
      4,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      5,
      3,
      2,
      1,
      0,
      0,
      1,
      3,
      4,
      4,
      0,
      5,
      5,
      1,
      3,
      NULL,
      NULL,
      5,
      4,
      3,
      6,
      0,
      NULL,
      2068.249888,
      NULL,
      2013.494104,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.555111,
      5,
      0.397720,
      NULL,
      0.853917,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.878720,
      1.161959,
      NULL,
      0.549134,
      0,
      0,
      1,
      NULL,
      NULL,
      1.789044,
      1.224038,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3,
      0,
      0,
      2,
      3,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      0.670404,
      2,
      2,
      NULL,
      0.375018,
      0.319211,
      0,
      0,
      0.391837,
      1.961702,
      NULL,
      NULL,
      1.565851,
      1.370279,
      0,
      1,
      2,
      0,
      5,
      NULL,
      3,
      1,
      5,
      3,
      1.913448,
      0.533608,
      4,
      1,
      2.267726,
      2.852715,
      NULL,
      3,
      1.661792,
      25,
      NULL,
      27,
      31.496425,
      NULL,
      5.184253,
      0.918937,
      '33340',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2.103278,
      '4100',
      '',
      '',
      2.136472,
      7,
      207.690768,
      NULL,
      3,
      17.976559,
      8.963613,
      139.883084,
      3,
      3.068835,
      0,
      0.453742,
      0.374613,
      NULL,
      NULL,
      1.496054,
      1,
      1,
      1,
      NULL,
      0.670487,
      NULL,
      NULL,
      0.895217,
      1.022840,
      NULL,
      2.679667,
      NULL,
      0,
      1.788890,
      2.028652,
      0.521716,
      3,
      1.678430,
      1,
      0.486470,
      0,
      NULL,
      NULL,
      NULL,
      0.244598,
      1.513045,
      0,
      NULL,
      NULL,
      0.759816,
      NULL,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499139,
      NULL,
      NULL,
      NULL,
      1.936520,
      1,
      1,
      0,
      NULL,
      NULL,
      1.000863,
      NULL,
      NULL,
      1,
      0.314235,
      1.214775,
      2,
      0.849637,
      0,
      NULL,
      1,
      1,
      0.901287,
      3.976095,
      0,
      2.986743,
      3.637460,
      3.856520,
      0.240142,
      3.234719,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.240615,
      NULL,
      NULL,
      0,
      0.050764,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.263570,
      2,
      1.086350,
      2.045492,
      2,
      1.541908,
      1,
      1.104266,
      NULL,
      NULL,
      NULL,
      0.312668,
      NULL,
      0.401957,
      1,
      2,
      1,
      1,
      0,
      7,
      NULL,
      0.815999,
      1.887979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.033556,
      NULL,
      NULL,
      0.646475,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558591,
      2,
      1.075194,
      2,
      4,
      NULL,
      1.347275,
      0,
      5.907360,
      0.253905,
      NULL,
      NULL,
      1.584002,
      0.431618,
      3,
      1.102263,
      3,
      3,
      2,
      3,
      3.320890,
      5.494371,
      NULL,
      8.002251,
      NULL,
      NULL,
      0,
      0.588272,
      NULL,
      NULL,
      3.010566,
      3,
      0,
      2.957291,
      1.623147,
      1,
      1.465751,
      3,
      4.842629,
      3.894571,
      5.391517,
      NULL,
      1.099455,
      1,
      4,
      0.446706,
      0,
      1.142145,
      0.413184,
      0,
      1.759869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.553144,
      NULL,
      NULL,
      3.539635,
      NULL,
      NULL,
      1.985867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.738111,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.847574,
      NULL,
      NULL,
      NULL,
      0.791236,
      NULL,
      NULL,
      NULL,
      0.457467,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057518,
      NULL,
      NULL,
      NULL,
      7.576775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      67,
      514,
      0.337179,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.546623,
      NULL,
      NULL,
      1.929914,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      58,
      18.082981,
      NULL,
      NULL,
      1.989127,
      1,
      0,
      1,
      1,
      NULL,
      1.855095,
      1.096729,
      0,
      1,
      1.236891,
      0.628195,
      0.145584,
      1.130032,
      0.749860,
      0.092592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.924281,
      7,
      6.164846,
      2,
      1,
      NULL,
      0,
      1,
      0,
      1.608884,
      NULL,
      NULL,
      NULL,
      3.331664,
      NULL,
      0,
      1.398248,
      NULL,
      1,
      3.748108,
      NULL,
      1.554113,
      1.614105,
      NULL,
      1.366795,
      1.159100,
      NULL,
      3.974881,
      0.407278,
      NULL,
      3.881887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.761247,
      0.817381,
      NULL,
      1.131678,
      1.127513,
      NULL,
      0.203781,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      6,
      2,
      1.171160,
      1,
      2,
      25.465439,
      NULL,
      3,
      4,
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


