set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9758171';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      0,
      NULL,
      2.634570,
      0.752561,
      NULL,
      0,
      2.843858,
      NULL,
      '00144242',
      26,
      35,
      NULL,
      NULL,
      0,
      2,
      2,
      '3300',
      3,
      0,
      NULL,
      NULL,
      '10-16-1982',
      NULL,
      52,
      NULL,
      2,
      0.847235,
      ' 2-17-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 5-1975',
      3.016820,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      1.253756,
      0,
      2.079088,
      4,
      7.267569,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.970235,
      0.724288,
      1,
      0.102335,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      2,
      1,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.791296,
      1,
      2,
      NULL,
      1,
      NULL,
      1.778177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0.454526,
      1,
      0,
      NULL,
      1,
      1.140815,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      3,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      6,
      1,
      ' 3-26-1977',
      448,
      ' 2-21-1991',
      36.161971,
      0.687011,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.375463,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.588682,
      3,
      0,
      0,
      4.264505,
      3,
      NULL,
      NULL,
      NULL,
      1.205627,
      5,
      2.521235,
      0,
      NULL,
      0,
      1.192424,
      ' 0-28-1999',
      NULL,
      NULL,
      124,
      NULL,
      NULL,
      NULL,
      0.616828,
      2.609550,
      0.237367,
      0,
      1,
      NULL,
      0.333659,
      1.371750,
      NULL,
      1,
      0.006903,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0,
      2,
      2,
      NULL,
      3,
      3,
      3,
      2,
      2,
      2,
      2,
      0,
      2.116964,
      NULL,
      0.909655,
      0,
      2,
      0.793887,
      0.886188,
      0,
      0,
      0,
      0.696377,
      1.821211,
      1,
      1,
      1,
      3.210304,
      0,
      1.408053,
      10.354114,
      NULL,
      3.392810,
      8.426055,
      7,
      NULL,
      2.480485,
      0.869804,
      NULL,
      2.756657,
      0.695606,
      37.009075,
      3,
      NULL,
      54,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.102823,
      '31440',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      12,
      120,
      2.202201,
      NULL,
      17,
      5,
      1.606033,
      1,
      0,
      1.407787,
      NULL,
      0,
      NULL,
      NULL,
      0.533675,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.889131,
      1,
      1,
      1.754431,
      NULL,
      NULL,
      0.153017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      0,
      1.242252,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.413954,
      1,
      NULL,
      1.090131,
      0.937439,
      NULL,
      NULL,
      0.061500,
      NULL,
      NULL,
      0.402530,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338304,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.330893,
      NULL,
      1.667458,
      8.956304,
      7.671563,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.634982,
      1.186007,
      1,
      NULL,
      1.349162,
      NULL,
      NULL,
      3.488667,
      3,
      1.873247,
      3,
      1,
      2,
      0.773411,
      NULL,
      NULL,
      4.054835,
      NULL,
      3.559083,
      0,
      NULL,
      NULL,
      1.491102,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.411297,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.157246,
      NULL,
      NULL,
      1,
      1.269412,
      1.817090,
      NULL,
      NULL,
      NULL,
      0.987232,
      0.061176,
      5.613168,
      0,
      0,
      3.435522,
      0.466308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.834750,
      NULL,
      0,
      1,
      7,
      2,
      6.449041,
      2.871190,
      2.411486,
      1,
      0,
      NULL,
      2.988062,
      0,
      NULL,
      NULL,
      0.069323,
      3,
      0,
      3.513246,
      3.839078,
      NULL,
      5,
      0.976056,
      4.153708,
      3.713918,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      2.862246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886812,
      NULL,
      NULL,
      0.806066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904926,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.704389,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      12.741656,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800001,
      NULL,
      NULL,
      0,
      0.842047,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      3.278227,
      NULL,
      NULL,
      0.628233,
      3,
      NULL,
      NULL,
      10.023147,
      NULL,
      NULL,
      NULL,
      0,
      1.367728,
      NULL,
      NULL,
      NULL,
      0.201629,
      0,
      0,
      2.588521,
      11.429314,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.642775,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.386919,
      NULL,
      NULL,
      0.095608,
      3.198730,
      0,
      NULL,
      1.224395,
      1,
      1.545245,
      0.930245,
      NULL,
      0,
      0.049396,
      1,
      1,
      1,
      1.208212,
      1,
      1,
      0.442709,
      NULL,
      0.052130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.140871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710044,
      0.690780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.258946,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137843,
      NULL,
      1.240609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5.567062,
      2.394917,
      2,
      2,
      3,
      14,
      3.093414,
      3.296117,
      NULL,
      0,
      0,
      NULL,
      1.231545,
      1.595688,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.794846,
      NULL,
      0,
      0,
      NULL,
      0,
      0.723558,
      NULL,
      0.939382,
      0.856594,
      NULL,
      0,
      0.375975,
      NULL,
      NULL,
      1.227654,
      NULL,
      0.937687,
      1.303100,
      NULL,
      1,
      0.985070,
      NULL,
      3.705823,
      0.285918,
      1.179741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      4,
      1.594510,
      NULL,
      NULL,
      74,
      NULL,
      1,
      5.474690,
      2,
      '00031',
      '',
      '',
      0.376117,
      '',
      '',
      NULL,
      0.492306,
      '',
      NULL,
      '');
commit;
end;
/


